/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import dev.langchain4j.data.message.AudioContent;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ContentType;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.data.message.VideoContent;
import dev.langchain4j.exception.TimeoutException;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.model.chat.Capability;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.ollama.AbstractOllamaLanguageModelInfrastructure;
import dev.langchain4j.model.ollama.OllamaChatModel;
import dev.langchain4j.model.output.FinishReason;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

class OllamaChatModelIT
extends AbstractOllamaLanguageModelInfrastructure {
    static final String MODEL_NAME = "tinydolphin";

    OllamaChatModelIT() {
    }

    @Test
    void should_respect_numPredict() {
        int numPredict = 1;
        OllamaChatModel model = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(OllamaChatModelIT.ollamaBaseUrl(ollama))).modelName(MODEL_NAME)).numPredict(Integer.valueOf(numPredict))).temperature(Double.valueOf(0.0))).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).build();
        UserMessage userMessage = UserMessage.from((String)"What is the capital of Germany?");
        ChatResponse response = model.chat(new ChatMessage[]{userMessage});
        Assertions.assertThat((String)response.aiMessage().text()).doesNotContain(new CharSequence[]{"Berlin"});
        ChatResponseMetadata metadata = response.metadata();
        Assertions.assertThat((String)metadata.modelName()).isEqualTo(MODEL_NAME);
        Assertions.assertThat((Comparable)metadata.finishReason()).isEqualTo((Object)FinishReason.LENGTH);
        Assertions.assertThat((Integer)metadata.tokenUsage().outputTokenCount()).isBetween(Integer.valueOf(numPredict), Integer.valueOf(numPredict + 2));
    }

    @Test
    void should_generate_valid_json() {
        OllamaChatModel model = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(OllamaChatModelIT.ollamaBaseUrl(ollama))).modelName(MODEL_NAME)).responseFormat(ResponseFormat.JSON)).temperature(Double.valueOf(0.0))).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).build();
        String userMessage = "Return JSON with two fields: name and age of John Doe, 42 years old.";
        ChatResponse response = model.chat(new ChatMessage[]{UserMessage.from((String)userMessage)});
        String json = response.aiMessage().text();
        Assertions.assertThat((String)json).isEqualToIgnoringWhitespace((CharSequence)"{\"name\": \"John Doe\", \"age\": 42}");
        ChatResponseMetadata metadata = response.metadata();
        Assertions.assertThat((String)metadata.modelName()).isEqualTo(MODEL_NAME);
        Assertions.assertThat((Comparable)metadata.finishReason()).isEqualTo((Object)FinishReason.STOP);
    }

    @Test
    void should_return_set_capabilities() {
        OllamaChatModel model = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(OllamaChatModelIT.ollamaBaseUrl(ollama))).modelName(MODEL_NAME)).supportedCapabilities(new Capability[]{Capability.RESPONSE_FORMAT_JSON_SCHEMA})).build();
        Assertions.assertThat((Collection)model.supportedCapabilities()).contains((Object[])new Capability[]{Capability.RESPONSE_FORMAT_JSON_SCHEMA});
    }

    @ParameterizedTest
    @ValueSource(ints={1, 10, 100, 500})
    void should_handle_timeout(int millis) {
        Duration timeout = Duration.ofMillis(millis);
        OllamaChatModel model = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(OllamaChatModelIT.ollamaBaseUrl(ollama))).modelName(MODEL_NAME)).maxRetries(Integer.valueOf(0)).timeout(timeout)).build();
        Assertions.assertThatThrownBy(() -> OllamaChatModelIT.lambda$should_handle_timeout$0((ChatModel)model)).isExactlyInstanceOf(TimeoutException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"notSupportedContentTypesProvider"})
    void should_throw_when_not_supported_content_types_used(List<ContentType> contentTypes) {
        OllamaChatModel model = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(OllamaChatModelIT.ollamaBaseUrl(ollama))).modelName(MODEL_NAME)).maxRetries(Integer.valueOf(0)).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).build();
        UserMessage userMessage = OllamaChatModelIT.createUserMessageBasedOnContentTypes(contentTypes);
        org.junit.jupiter.api.Assertions.assertThrows(UnsupportedFeatureException.class, () -> model.chat(new ChatMessage[]{userMessage}));
    }

    @ParameterizedTest
    @MethodSource(value={"supportedContentTypesProvider"})
    void should_not_throw_when_supported_content_types_used(List<ContentType> contentTypes) {
        OllamaChatModel model = ((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)((OllamaChatModel.OllamaChatModelBuilder)OllamaChatModel.builder().baseUrl(OllamaChatModelIT.ollamaBaseUrl(ollama))).modelName(MODEL_NAME)).maxRetries(Integer.valueOf(0)).timeout(Duration.ofMillis(1L))).logRequests(Boolean.valueOf(true))).logResponses(Boolean.valueOf(true))).build();
        UserMessage userMessage = OllamaChatModelIT.createUserMessageBasedOnContentTypes(contentTypes);
        org.junit.jupiter.api.Assertions.assertThrows(TimeoutException.class, () -> model.chat(new ChatMessage[]{userMessage}));
    }

    static UserMessage createUserMessageBasedOnContentTypes(List<ContentType> contentTypes) {
        return UserMessage.from(contentTypes.stream().map(OllamaChatModelIT::createContentBasedOnType).toList());
    }

    static Content createContentBasedOnType(ContentType contentType) {
        return switch (contentType) {
            case ContentType.AUDIO -> AudioContent.from((String)"VGhpcyBpcyBhIHRlc3QgY29udGVudHM=", (String)"audio/mpeg");
            case ContentType.IMAGE -> ImageContent.from((String)"VGhpcyBpcyBhIHRlc3QgY29udGVudHM=", (String)"image/jpeg");
            case ContentType.PDF -> VideoContent.from((String)"VGhpcyBpcyBhIHRlc3QgY29udGVudHM=", (String)"application/pdf");
            case ContentType.TEXT -> TextContent.from((String)"Test text content.");
            case ContentType.VIDEO -> VideoContent.from((String)"VGhpcyBpcyBhIHRlc3QgY29udGVudHM=", (String)"video/mp4");
            default -> {
                org.junit.jupiter.api.Assertions.fail((String)("Cannot create user message from content type: " + String.valueOf(contentType)));
                yield TextContent.from((String)"Text text content.");
            }
        };
    }

    static Stream<List<ContentType>> notSupportedContentTypesProvider() {
        return Stream.of(List.of(ContentType.AUDIO), List.of(ContentType.PDF), List.of(ContentType.VIDEO), List.of(ContentType.TEXT, ContentType.AUDIO), List.of(ContentType.TEXT, ContentType.PDF), List.of(ContentType.TEXT, ContentType.VIDEO), List.of(ContentType.IMAGE, ContentType.AUDIO), List.of(ContentType.IMAGE, ContentType.PDF), List.of(ContentType.IMAGE, ContentType.VIDEO), List.of(ContentType.TEXT, ContentType.AUDIO, ContentType.IMAGE), List.of(ContentType.TEXT, ContentType.PDF, ContentType.IMAGE), List.of(ContentType.TEXT, ContentType.VIDEO, ContentType.IMAGE), List.of(ContentType.AUDIO, ContentType.IMAGE, ContentType.PDF, ContentType.TEXT, ContentType.VIDEO));
    }

    static Stream<List<ContentType>> supportedContentTypesProvider() {
        return Stream.of(List.of(ContentType.TEXT), List.of(ContentType.IMAGE, ContentType.TEXT), List.of(ContentType.TEXT, ContentType.IMAGE), List.of(ContentType.IMAGE, ContentType.IMAGE, ContentType.TEXT), List.of(ContentType.IMAGE, ContentType.TEXT, ContentType.IMAGE));
    }

    private static /* synthetic */ void lambda$should_handle_timeout$0(ChatModel model) throws Throwable {
        model.chat("hi");
    }
}

