/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.ollama;

import com.github.dockerjava.api.command.InspectContainerResponse;
import dev.langchain4j.internal.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.Container;
import org.testcontainers.ollama.OllamaContainer;
import org.testcontainers.utility.DockerImageName;

public class LC4jOllamaContainer
extends OllamaContainer {
    private static final Logger log = LoggerFactory.getLogger(LC4jOllamaContainer.class);
    private List<String> models = new ArrayList<String>();

    public LC4jOllamaContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
    }

    public LC4jOllamaContainer withModel(String model) {
        this.models.add(model);
        return this;
    }

    public LC4jOllamaContainer withModels(List<String> models) {
        this.models = models;
        return this;
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        if (!Utils.isNullOrEmpty(this.models)) {
            for (String model : this.models) {
                try {
                    log.info("Start pulling the '{}' model ... would take several minutes ...", (Object)model);
                    Container.ExecResult r = this.execInContainer(new String[]{"ollama", "pull", model});
                    log.info("Model pulling competed! {}", (Object)r);
                }
                catch (IOException | InterruptedException e) {
                    throw new RuntimeException("Error pulling model", e);
                }
            }
        }
    }
}

