/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.http.client;

import dev.langchain4j.Internal;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.http.client.sse.ServerSentEventParser;
import dev.langchain4j.internal.ValidationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Internal
public class MockHttpClient
implements HttpClient {
    private final List<HttpRequest> requests = Collections.synchronizedList(new ArrayList());
    private final SuccessfulHttpResponse response;
    private final List<ServerSentEvent> events;

    public MockHttpClient() {
        this.response = null;
        this.events = List.of();
    }

    public MockHttpClient(SuccessfulHttpResponse response) {
        this.response = (SuccessfulHttpResponse)ValidationUtils.ensureNotNull((Object)response, (String)"response");
        this.events = List.of();
    }

    public MockHttpClient(List<ServerSentEvent> events) {
        this.response = null;
        this.events = (List)ValidationUtils.ensureNotEmpty(events, (String)"events");
    }

    public MockHttpClient(SuccessfulHttpResponse response, List<ServerSentEvent> events) {
        this.response = (SuccessfulHttpResponse)ValidationUtils.ensureNotNull((Object)response, (String)"response");
        this.events = (List)ValidationUtils.ensureNotEmpty(events, (String)"events");
    }

    public List<HttpRequest> requests() {
        return this.requests;
    }

    public HttpRequest request() {
        if (this.requests.size() != 1) {
            throw new IllegalStateException("Expected 1 request, but got: " + this.requests.size());
        }
        return this.requests.get(0);
    }

    public SuccessfulHttpResponse execute(HttpRequest request) {
        this.requests.add(request);
        return this.response;
    }

    public void execute(HttpRequest request, ServerSentEventParser parser, ServerSentEventListener listener) {
        this.requests.add(request);
        listener.onOpen(this.response);
        this.events.forEach(arg_0 -> ((ServerSentEventListener)listener).onEvent(arg_0));
        listener.onClose();
    }

    public static MockHttpClient thatAlwaysResponds(SuccessfulHttpResponse response) {
        return new MockHttpClient(response);
    }

    public static MockHttpClient thatAlwaysResponds(List<ServerSentEvent> events) {
        return new MockHttpClient(events);
    }

    public static MockHttpClient thatAlwaysResponds(SuccessfulHttpResponse response, List<ServerSentEvent> events) {
        return new MockHttpClient(response, events);
    }
}

