/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.http.client.HttpClient;
import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.http.client.HttpClientBuilderLoader;
import dev.langchain4j.http.client.HttpMethod;
import dev.langchain4j.http.client.HttpRequest;
import dev.langchain4j.http.client.SuccessfulHttpResponse;
import dev.langchain4j.http.client.log.LoggingHttpClient;
import dev.langchain4j.http.client.sse.CancellationUnsupportedHandle;
import dev.langchain4j.http.client.sse.ServerSentEvent;
import dev.langchain4j.http.client.sse.ServerSentEventContext;
import dev.langchain4j.http.client.sse.ServerSentEventListener;
import dev.langchain4j.http.client.sse.ServerSentEventParsingHandle;
import dev.langchain4j.http.client.sse.ServerSentEventParsingHandleUtils;
import dev.langchain4j.internal.ExceptionMapper;
import dev.langchain4j.internal.InternalStreamingChatResponseHandlerUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.CompleteToolCall;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.chat.response.StreamingHandle;
import dev.langchain4j.model.googleai.GeminiCachedContent;
import dev.langchain4j.model.googleai.GeminiCountTokensRequest;
import dev.langchain4j.model.googleai.GeminiCountTokensResponse;
import dev.langchain4j.model.googleai.GeminiGenerateContentRequest;
import dev.langchain4j.model.googleai.GeminiGenerateContentResponse;
import dev.langchain4j.model.googleai.GeminiStreamingResponseBuilder;
import dev.langchain4j.model.googleai.GoogleAiBatchEmbeddingRequest;
import dev.langchain4j.model.googleai.GoogleAiBatchEmbeddingResponse;
import dev.langchain4j.model.googleai.GoogleAiEmbeddingRequest;
import dev.langchain4j.model.googleai.GoogleAiEmbeddingResponse;
import dev.langchain4j.model.googleai.GoogleAiListCachedContentsRequest;
import dev.langchain4j.model.googleai.GoogleAiListCachedContentsResponse;
import dev.langchain4j.model.googleai.Json;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class GeminiService {
    private static final String GEMINI_AI_ENDPOINT = "https://generativelanguage.googleapis.com/v1beta";
    private static final String API_KEY_HEADER_NAME = "x-goog-api-key";
    private static final Duration DEFAULT_CONNECT_TIMEOUT = Duration.ofSeconds(15L);
    private static final Duration DEFAULT_READ_TIMEOUT = Duration.ofSeconds(60L);
    private final HttpClient httpClient;
    private final String baseUrl;
    private final String apiKey;

    GeminiService(@Nullable HttpClientBuilder httpClientBuilder, String apiKey, String baseUrl, boolean logRequestsAndResponses, boolean logRequests, boolean logResponses, Logger logger, Duration timeout) {
        this.apiKey = ValidationUtils.ensureNotBlank((String)apiKey, (String)"apiKey");
        this.baseUrl = (String)Utils.getOrDefault((Object)baseUrl, (Object)GEMINI_AI_ENDPOINT);
        HttpClientBuilder builder = (HttpClientBuilder)Utils.getOrDefault((Object)httpClientBuilder, HttpClientBuilderLoader::loadHttpClientBuilder);
        HttpClient httpClient = builder.connectTimeout((Duration)Utils.firstNotNull((String)"connectTimeout", (Object[])new Duration[]{timeout, builder.connectTimeout(), DEFAULT_CONNECT_TIMEOUT})).readTimeout((Duration)Utils.firstNotNull((String)"readTimeout", (Object[])new Duration[]{timeout, builder.readTimeout(), DEFAULT_READ_TIMEOUT})).build();
        this.httpClient = logRequestsAndResponses || logResponses || logRequests ? new LoggingHttpClient(httpClient, Boolean.valueOf(logRequestsAndResponses || logRequests), Boolean.valueOf(logRequestsAndResponses || logResponses), logger) : httpClient;
    }

    GeminiGenerateContentResponse generateContent(String modelName, GeminiGenerateContentRequest request) {
        String url = String.format("%s/models/%s:generateContent", this.baseUrl, modelName);
        return this.sendRequest(url, this.apiKey, request, GeminiGenerateContentResponse.class);
    }

    GeminiCountTokensResponse countTokens(String modelName, GeminiCountTokensRequest request) {
        String url = String.format("%s/models/%s:countTokens", this.baseUrl, modelName);
        return this.sendRequest(url, this.apiKey, request, GeminiCountTokensResponse.class);
    }

    GoogleAiEmbeddingResponse embed(String modelName, GoogleAiEmbeddingRequest request) {
        String url = String.format("%s/models/%s:embedContent", this.baseUrl, modelName);
        return this.sendRequest(url, this.apiKey, request, GoogleAiEmbeddingResponse.class);
    }

    GoogleAiBatchEmbeddingResponse batchEmbed(String modelName, GoogleAiBatchEmbeddingRequest request) {
        String url = String.format("%s/models/%s:batchEmbedContents", this.baseUrl, modelName);
        return this.sendRequest(url, this.apiKey, request, GoogleAiBatchEmbeddingResponse.class);
    }

    GeminiCachedContent createCachedContent(String modelName, GeminiCachedContent cachedContent) {
        cachedContent.setModel("models/" + modelName);
        String url = this.baseUrl + "/cachedContents";
        return this.sendRequest(url, this.apiKey, cachedContent, GeminiCachedContent.class);
    }

    GoogleAiListCachedContentsResponse listCachedContents(GoogleAiListCachedContentsRequest request) {
        String url = this.baseUrl + "/cachedContents?pageSize=" + request.getPageSize() + (String)(request.getPageToken() != null ? "&pageToken=" + request.getPageToken() : "");
        return this.sendGetRequest(url, this.apiKey, GoogleAiListCachedContentsResponse.class);
    }

    void deleteCachedContent(String id) {
        String url = this.baseUrl + "/cachedContents/" + id;
        HttpRequest request = this.buildHttpRequest(HttpMethod.DELETE, url, this.apiKey, null);
        this.httpClient.execute(request);
    }

    void generateContentStream(String modelName, GeminiGenerateContentRequest request, boolean includeCodeExecutionOutput, Boolean returnThinking, StreamingChatResponseHandler handler) {
        String url = String.format("%s/models/%s:streamGenerateContent?alt=sse", this.baseUrl, modelName);
        this.streamRequest(url, this.apiKey, request, includeCodeExecutionOutput, returnThinking, handler);
    }

    private <T> T sendRequest(String url, String apiKey, Object requestBody, Class<T> responseType) {
        String jsonBody = Json.toJson(requestBody);
        HttpRequest request = this.buildHttpRequest(HttpMethod.POST, url, apiKey, jsonBody);
        SuccessfulHttpResponse response = this.httpClient.execute(request);
        return Json.fromJson(response.body(), responseType);
    }

    private <T> T sendGetRequest(String url, String apiKey, Class<T> responseType) {
        HttpRequest request = this.buildHttpRequest(HttpMethod.GET, url, apiKey, null);
        SuccessfulHttpResponse response = this.httpClient.execute(request);
        return Json.fromJson(response.body(), responseType);
    }

    private void streamRequest(String url, String apiKey, Object requestBody, boolean includeCodeExecutionOutput, final Boolean returnThinking, final StreamingChatResponseHandler handler) {
        String jsonBody = Json.toJson(requestBody);
        HttpRequest httpRequest = this.buildHttpRequest(HttpMethod.POST, url, apiKey, jsonBody);
        final GeminiStreamingResponseBuilder responseBuilder = new GeminiStreamingResponseBuilder(includeCodeExecutionOutput, returnThinking);
        this.httpClient.execute(httpRequest, new ServerSentEventListener(){
            AtomicInteger toolIndex = new AtomicInteger(0);
            volatile StreamingHandle streamingHandle;
            final /* synthetic */ GeminiService this$0;
            {
                this.this$0 = this$0;
            }

            public void onEvent(ServerSentEvent event) {
                this.onEvent(event, new ServerSentEventContext((ServerSentEventParsingHandle)new CancellationUnsupportedHandle()));
            }

            public void onEvent(ServerSentEvent event, ServerSentEventContext context) {
                if (this.streamingHandle == null) {
                    this.streamingHandle = ServerSentEventParsingHandleUtils.toStreamingHandle((ServerSentEventParsingHandle)context.parsingHandle());
                }
                GeminiGenerateContentResponse response = Json.fromJson(event.data(), GeminiGenerateContentResponse.class);
                GeminiStreamingResponseBuilder.TextAndTools textAndTools = responseBuilder.append(response);
                textAndTools.maybeText().ifPresent(text -> InternalStreamingChatResponseHandlerUtils.onPartialResponse((StreamingChatResponseHandler)handler, (String)text, (StreamingHandle)this.streamingHandle));
                textAndTools.maybeThought().ifPresent(thought -> {
                    if (Boolean.TRUE.equals(returnThinking)) {
                        InternalStreamingChatResponseHandlerUtils.onPartialThinking((StreamingChatResponseHandler)handler, (String)thought, (StreamingHandle)this.streamingHandle);
                    } else if (returnThinking == null) {
                        InternalStreamingChatResponseHandlerUtils.onPartialResponse((StreamingChatResponseHandler)handler, (String)thought, (StreamingHandle)this.streamingHandle);
                    }
                });
                for (ToolExecutionRequest tool : textAndTools.tools()) {
                    CompleteToolCall completeToolCall = new CompleteToolCall(this.toolIndex.get(), tool);
                    InternalStreamingChatResponseHandlerUtils.onCompleteToolCall((StreamingChatResponseHandler)handler, (CompleteToolCall)completeToolCall);
                    this.toolIndex.incrementAndGet();
                }
            }

            public void onClose() {
                if (this.streamingHandle == null || !this.streamingHandle.isCancelled()) {
                    ChatResponse completeResponse = responseBuilder.build();
                    InternalStreamingChatResponseHandlerUtils.onCompleteResponse((StreamingChatResponseHandler)handler, (ChatResponse)completeResponse);
                }
            }

            public void onError(Throwable error) {
                RuntimeException mappedError = ExceptionMapper.DEFAULT.mapException(error);
                InternalStreamingChatResponseHandlerUtils.withLoggingExceptions(() -> handler.onError((Throwable)mappedError));
            }
        });
    }

    private HttpRequest buildHttpRequest(HttpMethod method, String url, String apiKey, String jsonBody) {
        return HttpRequest.builder().method(method).url(url).addHeader("Content-Type", new String[]{"application/json"}).addHeader("User-Agent", new String[]{"LangChain4j"}).addHeader(API_KEY_HEADER_NAME, new String[]{apiKey}).body(jsonBody).build();
    }
}

