/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import dev.langchain4j.http.client.HttpClientBuilder;
import dev.langchain4j.internal.JsonSchemaElementUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.listener.ChatModelListener;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.request.json.JsonEnumSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.googleai.FunctionMapper;
import dev.langchain4j.model.googleai.GeminiCacheManager;
import dev.langchain4j.model.googleai.GeminiCachingConfig;
import dev.langchain4j.model.googleai.GeminiContent;
import dev.langchain4j.model.googleai.GeminiFunctionCallingConfig;
import dev.langchain4j.model.googleai.GeminiGenerateContentRequest;
import dev.langchain4j.model.googleai.GeminiGenerationConfig;
import dev.langchain4j.model.googleai.GeminiHarmBlockThreshold;
import dev.langchain4j.model.googleai.GeminiHarmCategory;
import dev.langchain4j.model.googleai.GeminiMode;
import dev.langchain4j.model.googleai.GeminiRole;
import dev.langchain4j.model.googleai.GeminiSafetySetting;
import dev.langchain4j.model.googleai.GeminiSchema;
import dev.langchain4j.model.googleai.GeminiService;
import dev.langchain4j.model.googleai.GeminiThinkingConfig;
import dev.langchain4j.model.googleai.GeminiToolConfig;
import dev.langchain4j.model.googleai.PartsAndContentsMapper;
import dev.langchain4j.model.googleai.SchemaMapper;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;

class BaseGeminiChatModel {
    protected final GeminiService geminiService;
    protected final GeminiCacheManager cacheManager;
    protected final GeminiFunctionCallingConfig functionCallingConfig;
    protected final boolean allowCodeExecution;
    protected final boolean includeCodeExecutionOutput;
    protected final List<GeminiSafetySetting> safetySettings;
    protected final List<ChatModelListener> listeners;
    protected final GeminiThinkingConfig thinkingConfig;
    protected final Boolean returnThinking;
    protected final boolean sendThinking;
    protected final Integer seed;
    protected final Integer logprobs;
    protected final Boolean responseLogprobs;
    protected final Boolean enableEnhancedCivicAnswers;
    protected final boolean useNativeJsonSchema;
    protected final GeminiCachingConfig cachingConfig;
    protected final ChatRequestParameters defaultRequestParameters;

    protected BaseGeminiChatModel(GoogleAiGeminiChatModelBaseBuilder<?> builder, GeminiService geminiService) {
        ValidationUtils.ensureNotBlank((String)builder.apiKey, (String)"apiKey");
        this.geminiService = geminiService;
        this.functionCallingConfig = builder.functionCallingConfig;
        this.allowCodeExecution = (Boolean)Utils.getOrDefault((Object)builder.allowCodeExecution, (Object)false);
        this.includeCodeExecutionOutput = (Boolean)Utils.getOrDefault((Object)builder.includeCodeExecutionOutput, (Object)false);
        this.safetySettings = Utils.copyIfNotNull(builder.safetySettings);
        this.listeners = Utils.copy(builder.listeners);
        this.thinkingConfig = builder.thinkingConfig;
        this.returnThinking = builder.returnThinking;
        this.sendThinking = (Boolean)Utils.getOrDefault((Object)builder.sendThinking, (Object)false);
        this.seed = builder.seed;
        this.responseLogprobs = (Boolean)Utils.getOrDefault((Object)builder.responseLogprobs, (Object)false);
        this.enableEnhancedCivicAnswers = (Boolean)Utils.getOrDefault((Object)builder.enableEnhancedCivicAnswers, (Object)false);
        this.logprobs = builder.logprobs;
        this.useNativeJsonSchema = builder.useNativeJsonSchema;
        this.cachingConfig = builder.cachingConfig;
        this.cacheManager = this.cachingConfig != null && this.cachingConfig.isCacheSystemMessages() ? (this.cachingConfig.getCacheManagerProvider() != null ? this.cachingConfig.getCacheManagerProvider().apply(geminiService) : new GeminiCacheManager(geminiService)) : null;
        ChatRequestParameters parameters = builder.defaultRequestParameters != null ? builder.defaultRequestParameters : DefaultChatRequestParameters.EMPTY;
        this.defaultRequestParameters = ChatRequestParameters.builder().modelName((String)Utils.getOrDefault((Object)builder.modelName, (Object)parameters.modelName())).temperature((Double)Utils.getOrDefault((Object)builder.temperature, (Object)parameters.temperature())).topP((Double)Utils.getOrDefault((Object)builder.topP, (Object)parameters.topP())).topK((Integer)Utils.getOrDefault((Object)builder.topK, (Object)parameters.topK())).frequencyPenalty((Double)Utils.getOrDefault((Object)builder.frequencyPenalty, (Object)parameters.frequencyPenalty())).presencePenalty((Double)Utils.getOrDefault((Object)builder.presencePenalty, (Object)parameters.presencePenalty())).maxOutputTokens((Integer)Utils.getOrDefault((Object)builder.maxOutputTokens, (Object)parameters.maxOutputTokens())).stopSequences(Utils.getOrDefault(builder.stopSequences, (List)parameters.stopSequences())).toolSpecifications(parameters.toolSpecifications()).toolChoice((ToolChoice)Utils.getOrDefault((Object)BaseGeminiChatModel.toToolChoice(this.functionCallingConfig), (Object)parameters.toolChoice())).responseFormat((ResponseFormat)Utils.getOrDefault((Object)builder.responseFormat, (Object)parameters.responseFormat())).build();
    }

    protected static GeminiService buildGeminiService(GoogleAiGeminiChatModelBaseBuilder<?> builder) {
        return new GeminiService(builder.httpClientBuilder, builder.apiKey, builder.baseUrl, (Boolean)Utils.getOrDefault((Object)builder.logRequestsAndResponses, (Object)false), (Boolean)Utils.getOrDefault((Object)builder.logRequests, (Object)false), (Boolean)Utils.getOrDefault((Object)builder.logResponses, (Object)false), builder.logger, builder.timeout);
    }

    protected GeminiGenerateContentRequest createGenerateContentRequest(ChatRequest chatRequest) {
        ChatRequestParameters parameters = chatRequest.parameters();
        GeminiContent systemInstruction = new GeminiContent(GeminiRole.MODEL.toString());
        List<GeminiContent> geminiContentList = PartsAndContentsMapper.fromMessageToGContent(chatRequest.messages(), systemInstruction, this.sendThinking);
        String cachedContent = null;
        if (systemInstruction.getParts().isEmpty()) {
            systemInstruction = null;
        } else if (this.cachingConfig != null && this.cachingConfig.isCacheSystemMessages()) {
            cachedContent = this.cacheManager.getOrCreateCached(this.cachingConfig.getCacheKey(), this.cachingConfig.getTtl(), systemInstruction, chatRequest.modelName());
            systemInstruction = null;
        }
        ResponseFormat responseFormat = chatRequest.responseFormat();
        GeminiSchema schema = null;
        Map responseJsonSchema = null;
        if (responseFormat != null && responseFormat.jsonSchema() != null) {
            if (this.useNativeJsonSchema) {
                responseJsonSchema = JsonSchemaElementUtils.toMap((JsonSchemaElement)responseFormat.jsonSchema().rootElement());
            } else {
                schema = SchemaMapper.fromJsonSchemaToGSchema(responseFormat.jsonSchema());
            }
        }
        return GeminiGenerateContentRequest.builder().contents(geminiContentList).systemInstruction(systemInstruction).generationConfig(GeminiGenerationConfig.builder().candidateCount(1).maxOutputTokens(parameters.maxOutputTokens()).responseMimeType(BaseGeminiChatModel.computeMimeType(responseFormat)).responseSchema(schema).responseJsonSchema(responseJsonSchema).stopSequences(parameters.stopSequences()).temperature(parameters.temperature()).topK(parameters.topK()).seed(this.seed).topP(parameters.topP()).presencePenalty(parameters.presencePenalty()).frequencyPenalty(parameters.frequencyPenalty()).responseLogprobs(this.responseLogprobs).logprobs(this.logprobs).thinkingConfig(this.thinkingConfig).build()).cachedContent(cachedContent).safetySettings(this.safetySettings).tools(FunctionMapper.fromToolSepcsToGTool(chatRequest.toolSpecifications(), this.allowCodeExecution)).toolConfig(this.toToolConfig(parameters.toolChoice(), this.functionCallingConfig)).build();
    }

    private GeminiToolConfig toToolConfig(ToolChoice toolChoice, GeminiFunctionCallingConfig functionCallingConfig) {
        if (toolChoice == null && functionCallingConfig == null) {
            return null;
        }
        GeminiMode geminiMode = Optional.ofNullable(functionCallingConfig).map(GeminiFunctionCallingConfig::getMode).orElse(null);
        List allowedFunctionNames = Optional.ofNullable(functionCallingConfig).map(GeminiFunctionCallingConfig::getAllowedFunctionNames).orElse(null);
        if (toolChoice != null) {
            geminiMode = BaseGeminiChatModel.toGeminiMode(toolChoice);
        }
        return new GeminiToolConfig(new GeminiFunctionCallingConfig(geminiMode, allowedFunctionNames));
    }

    protected static String computeMimeType(ResponseFormat responseFormat) {
        if (responseFormat == null || ResponseFormatType.TEXT.equals((Object)responseFormat.type())) {
            return "text/plain";
        }
        if (ResponseFormatType.JSON.equals((Object)responseFormat.type()) && responseFormat.jsonSchema() != null && responseFormat.jsonSchema().rootElement() != null && responseFormat.jsonSchema().rootElement() instanceof JsonEnumSchema) {
            return "text/x.enum";
        }
        return "application/json";
    }

    private static GeminiMode toGeminiMode(ToolChoice toolChoice) {
        return switch (toolChoice) {
            default -> throw new IncompatibleClassChangeError();
            case ToolChoice.AUTO -> GeminiMode.AUTO;
            case ToolChoice.REQUIRED -> GeminiMode.ANY;
            case ToolChoice.NONE -> GeminiMode.NONE;
        };
    }

    private static ToolChoice toToolChoice(GeminiFunctionCallingConfig config) {
        if (config == null || config.getMode() == null) {
            return null;
        }
        return switch (config.getMode()) {
            default -> throw new IncompatibleClassChangeError();
            case GeminiMode.AUTO -> ToolChoice.AUTO;
            case GeminiMode.ANY -> ToolChoice.REQUIRED;
            case GeminiMode.NONE -> null;
        };
    }

    public static abstract class GoogleAiGeminiChatModelBaseBuilder<B extends GoogleAiGeminiChatModelBaseBuilder<B>> {
        protected HttpClientBuilder httpClientBuilder;
        protected ChatRequestParameters defaultRequestParameters;
        protected String apiKey;
        protected String baseUrl;
        protected String modelName;
        protected Double temperature;
        protected Integer topK;
        protected Integer seed;
        protected Double topP;
        protected Double frequencyPenalty;
        protected Double presencePenalty;
        protected Integer maxOutputTokens;
        protected Duration timeout;
        protected ResponseFormat responseFormat;
        protected List<String> stopSequences;
        protected GeminiFunctionCallingConfig functionCallingConfig;
        protected Boolean allowCodeExecution;
        protected Boolean includeCodeExecutionOutput;
        protected Boolean logRequestsAndResponses;
        protected Boolean logRequests;
        protected Boolean logResponses;
        protected Logger logger;
        protected Boolean responseLogprobs;
        protected Boolean enableEnhancedCivicAnswers;
        protected List<GeminiSafetySetting> safetySettings;
        protected GeminiThinkingConfig thinkingConfig;
        protected Boolean returnThinking;
        protected Boolean sendThinking;
        protected Integer logprobs;
        protected boolean useNativeJsonSchema;
        protected GeminiCachingConfig cachingConfig;
        protected List<ChatModelListener> listeners;

        protected B builder() {
            return (B)this;
        }

        public B httpClientBuilder(HttpClientBuilder httpClientBuilder) {
            this.httpClientBuilder = httpClientBuilder;
            return this.builder();
        }

        public B defaultRequestParameters(ChatRequestParameters defaultRequestParameters) {
            this.defaultRequestParameters = defaultRequestParameters;
            return this.builder();
        }

        public B apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this.builder();
        }

        public B baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this.builder();
        }

        public B modelName(String modelName) {
            this.modelName = modelName;
            return this.builder();
        }

        public B timeout(Duration timeout) {
            this.timeout = timeout;
            return this.builder();
        }

        public B listeners(List<ChatModelListener> listeners) {
            this.listeners = listeners;
            return this.builder();
        }

        public B includeCodeExecutionOutput(Boolean includeCodeExecutionOutput) {
            this.includeCodeExecutionOutput = includeCodeExecutionOutput;
            return this.builder();
        }

        public B logRequestsAndResponses(Boolean logRequestsAndResponses) {
            this.logRequestsAndResponses = logRequestsAndResponses;
            return this.builder();
        }

        public B logRequests(Boolean logRequests) {
            this.logRequests = logRequests;
            return this.builder();
        }

        public B logResponses(Boolean logResponses) {
            this.logResponses = logResponses;
            return this.builder();
        }

        public B logger(Logger logger) {
            this.logger = logger;
            return this.builder();
        }

        public B toolConfig(GeminiFunctionCallingConfig toolConfig) {
            this.functionCallingConfig = toolConfig;
            return this.builder();
        }

        public B toolConfig(GeminiMode mode, String ... allowedFunctionNames) {
            this.functionCallingConfig = new GeminiFunctionCallingConfig(mode, Arrays.asList(allowedFunctionNames));
            return this.builder();
        }

        public B safetySettings(Map<GeminiHarmCategory, GeminiHarmBlockThreshold> safetySettingMap) {
            this.safetySettings = safetySettingMap.entrySet().stream().map(entry -> new GeminiSafetySetting((GeminiHarmCategory)((Object)((Object)entry.getKey())), (GeminiHarmBlockThreshold)((Object)((Object)entry.getValue())))).toList();
            return this.builder();
        }

        public B temperature(Double temperature) {
            this.temperature = temperature;
            return this.builder();
        }

        public B topK(Integer topK) {
            this.topK = topK;
            return this.builder();
        }

        public B seed(Integer seed) {
            this.seed = seed;
            return this.builder();
        }

        public B topP(Double topP) {
            this.topP = topP;
            return this.builder();
        }

        public B frequencyPenalty(Double frequencyPenalty) {
            this.frequencyPenalty = frequencyPenalty;
            return this.builder();
        }

        public B presencePenalty(Double presencePenalty) {
            this.presencePenalty = presencePenalty;
            return this.builder();
        }

        public B maxOutputTokens(Integer maxOutputTokens) {
            this.maxOutputTokens = maxOutputTokens;
            return this.builder();
        }

        public B responseFormat(ResponseFormat responseFormat) {
            this.responseFormat = responseFormat;
            return this.builder();
        }

        public B useNativeJsonSchema(boolean useNativeJsonSchema) {
            this.useNativeJsonSchema = useNativeJsonSchema;
            return this.builder();
        }

        public B stopSequences(List<String> stopSequences) {
            this.stopSequences = stopSequences;
            return this.builder();
        }

        public B allowCodeExecution(Boolean allowCodeExecution) {
            this.allowCodeExecution = allowCodeExecution;
            return this.builder();
        }

        public B safetySettings(List<GeminiSafetySetting> safetySettings) {
            this.safetySettings = safetySettings;
            return this.builder();
        }

        public B thinkingConfig(GeminiThinkingConfig thinkingConfig) {
            this.thinkingConfig = thinkingConfig;
            return this.builder();
        }

        public B returnThinking(Boolean returnThinking) {
            this.returnThinking = returnThinking;
            return this.builder();
        }

        public B sendThinking(Boolean sendThinking) {
            this.sendThinking = sendThinking;
            return this.builder();
        }

        public B responseLogprobs(Boolean responseLogprobs) {
            this.responseLogprobs = responseLogprobs;
            return this.builder();
        }

        public B logprobs(Integer logprobs) {
            this.logprobs = logprobs;
            return this.builder();
        }

        public B enableEnhancedCivicAnswers(Boolean enableEnhancedCivicAnswers) {
            this.enableEnhancedCivicAnswers = enableEnhancedCivicAnswers;
            return this.builder();
        }

        public B cachingConfig(GeminiCachingConfig cachingConfig) {
            this.cachingConfig = cachingConfig;
            return this.builder();
        }
    }
}

