/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.web.search;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.web.search.WebSearchOrganicResult;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class WebSearchOrganicResultTest {
    WebSearchOrganicResultTest() {
    }

    @Test
    void should_build_webSearchOrganicResult_with_default_values() {
        WebSearchOrganicResult webSearchOrganicResult = WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://google.com"));
        Assertions.assertThat((String)webSearchOrganicResult.title()).isEqualTo("title");
        Assertions.assertThat((URI)webSearchOrganicResult.url()).hasToString("https://google.com");
        Assertions.assertThat((String)webSearchOrganicResult.snippet()).isNull();
        Assertions.assertThat((String)webSearchOrganicResult.content()).isNull();
        Assertions.assertThat((Map)webSearchOrganicResult.metadata()).isEmpty();
    }

    @Test
    void should_build_webSearchOrganicResult_with_custom_snippet() {
        WebSearchOrganicResult webSearchOrganicResult = WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://google.com"), (String)"snippet", null);
        Assertions.assertThat((String)webSearchOrganicResult.title()).isEqualTo("title");
        Assertions.assertThat((URI)webSearchOrganicResult.url()).hasToString("https://google.com");
        Assertions.assertThat((String)webSearchOrganicResult.snippet()).isEqualTo("snippet");
        Assertions.assertThat((String)webSearchOrganicResult.content()).isNull();
        Assertions.assertThat((Map)webSearchOrganicResult.metadata()).isEmpty();
        Assertions.assertThat((Object)webSearchOrganicResult).hasToString("WebSearchOrganicResult{title='title', url=https://google.com, snippet='snippet', content='null', metadata={}}");
    }

    @Test
    void should_build_webSearchOrganicResult_with_custom_content() {
        WebSearchOrganicResult webSearchOrganicResult = WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://google.com"), null, (String)"content");
        Assertions.assertThat((String)webSearchOrganicResult.title()).isEqualTo("title");
        Assertions.assertThat((URI)webSearchOrganicResult.url()).hasToString("https://google.com");
        Assertions.assertThat((String)webSearchOrganicResult.snippet()).isNull();
        Assertions.assertThat((String)webSearchOrganicResult.content()).isEqualTo("content");
        Assertions.assertThat((Map)webSearchOrganicResult.metadata()).isEmpty();
        Assertions.assertThat((Object)webSearchOrganicResult).hasToString("WebSearchOrganicResult{title='title', url=https://google.com, snippet='null', content='content', metadata={}}");
    }

    @Test
    void should_build_webSearchOrganicResult_with_custom_title_link_and_metadata() {
        WebSearchOrganicResult webSearchOrganicResult = WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://google.com"), (String)"snippet", null, Stream.of(new AbstractMap.SimpleEntry<String, String>("key", "value")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        Assertions.assertThat((String)webSearchOrganicResult.title()).isEqualTo("title");
        Assertions.assertThat((URI)webSearchOrganicResult.url()).hasToString("https://google.com");
        Assertions.assertThat((String)webSearchOrganicResult.snippet()).isEqualTo("snippet");
        Assertions.assertThat((Map)webSearchOrganicResult.metadata()).containsExactly(new Map.Entry[]{new AbstractMap.SimpleEntry<String, String>("key", "value")});
        Assertions.assertThat((Object)webSearchOrganicResult).hasToString("WebSearchOrganicResult{title='title', url=https://google.com, snippet='snippet', content='null', metadata={key=value}}");
    }

    @Test
    void equals_and_hash() {
        WebSearchOrganicResult wsor1 = WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://google.com"), (String)"snippet", null, Stream.of(new AbstractMap.SimpleEntry<String, String>("key", "value")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        WebSearchOrganicResult wsor2 = WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://google.com"), (String)"snippet", null, Stream.of(new AbstractMap.SimpleEntry<String, String>("key", "value")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)wsor1).isEqualTo((Object)wsor1)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)wsor2)).hasSameHashCodeAs((Object)wsor2);
        Assertions.assertThat((Object)WebSearchOrganicResult.from((String)"other title", (URI)URI.create("https://google.com"), (String)"snippet", null, Stream.of(new AbstractMap.SimpleEntry<String, String>("key", "value")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))).isNotEqualTo((Object)wsor1);
        Assertions.assertThat((Object)WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://docs.langchain4j.dev"), (String)"snippet", null, Stream.of(new AbstractMap.SimpleEntry<String, String>("key", "value")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))).isNotEqualTo((Object)wsor1);
        Assertions.assertThat((Object)WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://google.com"), (String)"other snippet", null, Stream.of(new AbstractMap.SimpleEntry<String, String>("key", "value")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))).isNotEqualTo((Object)wsor1);
        Assertions.assertThat((Object)WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://google.com"), (String)"snippet", null, Stream.of(new AbstractMap.SimpleEntry<String, String>("other key", "value")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))).isNotEqualTo((Object)wsor1);
    }

    @Test
    void should_return_textSegment() {
        WebSearchOrganicResult webSearchOrganicResult = WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://google.com"), (String)"snippet", null, Stream.of(new AbstractMap.SimpleEntry<String, String>("key", "value")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        Assertions.assertThat((String)webSearchOrganicResult.toTextSegment().text()).isEqualTo("title\nsnippet");
        Assertions.assertThat((Object)webSearchOrganicResult.toTextSegment().metadata()).isEqualTo((Object)Metadata.from(Stream.of(new AbstractMap.SimpleEntry<String, String>("url", "https://google.com"), new AbstractMap.SimpleEntry<String, String>("key", "value")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
    }

    @Test
    void should_return_textSegment_when_metadata_is_null_with_all_factories_and_constructors() {
        URI url = URI.create("https://google.com");
        WebSearchOrganicResult fromWithContentAndMetadata = WebSearchOrganicResult.from((String)"title", (URI)url, (String)"snippet", null, null);
        WebSearchOrganicResult fromWithoutContent = WebSearchOrganicResult.from((String)"title", (URI)url, (String)"snippet", null);
        WebSearchOrganicResult usingConstructor = new WebSearchOrganicResult("title", url, "snippet", null, null);
        String expectedText = "title\nsnippet";
        Metadata expectedMetadata = Metadata.from(Map.of("url", "https://google.com"));
        Assertions.assertThat((String)fromWithContentAndMetadata.toTextSegment().text()).isEqualTo(expectedText);
        Assertions.assertThat((Object)fromWithContentAndMetadata.toTextSegment().metadata()).isEqualTo((Object)expectedMetadata);
        Assertions.assertThat((String)fromWithoutContent.toTextSegment().text()).isEqualTo(expectedText);
        Assertions.assertThat((Object)fromWithoutContent.toTextSegment().metadata()).isEqualTo((Object)expectedMetadata);
        Assertions.assertThat((String)usingConstructor.toTextSegment().text()).isEqualTo(expectedText);
        Assertions.assertThat((Object)usingConstructor.toTextSegment().metadata()).isEqualTo((Object)expectedMetadata);
    }

    @Test
    void should_return_document() {
        WebSearchOrganicResult webSearchOrganicResult = WebSearchOrganicResult.from((String)"title", (URI)URI.create("https://google.com"), (String)"snippet", null, Stream.of(new AbstractMap.SimpleEntry<String, String>("key", "value")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        Assertions.assertThat((String)webSearchOrganicResult.toDocument().text()).isEqualTo("title\nsnippet");
        Assertions.assertThat((Object)webSearchOrganicResult.toDocument().metadata()).isEqualTo((Object)Metadata.from(Stream.of(new AbstractMap.SimpleEntry<String, String>("url", "https://google.com"), new AbstractMap.SimpleEntry<String, String>("key", "value")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))));
    }

    @Test
    void should_throw_illegalArgumentException_without_title() {
        IllegalArgumentException exception = (IllegalArgumentException)AssertionsForClassTypes.assertThatExceptionOfType(IllegalArgumentException.class).isThrownBy(() -> WebSearchOrganicResult.from(null, (URI)URI.create("https://google.com"), (String)"snippet", (String)"content")).actual();
        Assertions.assertThat((Throwable)exception).hasMessage("title cannot be null or blank");
    }
}

