/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.filter.comparison;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.store.embedding.filter.comparison.IsNotEqualTo;
import java.util.HashMap;
import java.util.UUID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class IsNotEqualToTest {
    IsNotEqualToTest() {
    }

    @Test
    void isNotEqualToFilter() {
        String key = "testKey";
        String unequalValue = "notEqual";
        IsNotEqualTo subject = new IsNotEqualTo(key, (Object)"testValue");
        this.assertIsNotEqualToObject(subject);
        this.assertMetadataDoesNotContainKey(subject);
        this.assertValuesAreNumbersNotEqual(key);
        this.assertUuidAndStringComparison(key);
        this.assertUnequalStringValues(key, unequalValue);
        this.assertEqualStringValues(key);
    }

    private void assertIsNotEqualToObject(IsNotEqualTo subject) {
        Assertions.assertThat((boolean)subject.test(new Object())).isFalse();
    }

    private void assertMetadataDoesNotContainKey(IsNotEqualTo subject) {
        Assertions.assertThat((boolean)subject.test((Object)new Metadata(new HashMap()))).isTrue();
    }

    private void assertValuesAreNumbersNotEqual(String key) {
        Metadata metadata = new Metadata(new HashMap());
        metadata.put(key, 123);
        IsNotEqualTo subject = new IsNotEqualTo(key, (Object)1234);
        Assertions.assertThat((boolean)subject.test((Object)metadata)).isTrue();
    }

    private void assertUuidAndStringComparison(String key) {
        UUID uuid = UUID.randomUUID();
        IsNotEqualTo subject = new IsNotEqualTo(key, (Object)uuid);
        Metadata metadata = new Metadata(new HashMap());
        metadata.put(key, uuid.toString() + "extra");
        Assertions.assertThat((boolean)subject.test((Object)metadata)).isTrue();
    }

    private void assertUnequalStringValues(String key, String unequalValue) {
        IsNotEqualTo subject = new IsNotEqualTo(key, (Object)unequalValue);
        Metadata metadata = new Metadata(new HashMap());
        metadata.put(key, "testValue");
        Assertions.assertThat((boolean)subject.test((Object)metadata)).isTrue();
    }

    private void assertEqualStringValues(String key) {
        IsNotEqualTo subject = new IsNotEqualTo(key, (Object)"testValue");
        Metadata metadata = new Metadata(new HashMap());
        metadata.put(key, "testValue");
        Assertions.assertThat((boolean)subject.test((Object)metadata)).isFalse();
    }

    @Test
    void test_nullComparisonValue() {
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> new IsNotEqualTo("key", null)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("comparisonValue with key 'key' cannot be null");
    }

    @Test
    void test_emptyStringComparison() {
        IsNotEqualTo subject = new IsNotEqualTo("value", (Object)"");
        Metadata metadata = new Metadata(new HashMap());
        metadata.put("value", "");
        Assertions.assertThat((boolean)subject.test((Object)metadata)).isFalse();
        metadata.put("value", " ");
        Assertions.assertThat((boolean)subject.test((Object)metadata)).isTrue();
    }

    @Test
    void test_nullMetadata() {
        IsNotEqualTo subject = new IsNotEqualTo("key", (Object)"value");
        Assertions.assertThat((boolean)subject.test(null)).isFalse();
    }

    @Test
    void test_getters() {
        String key = "testKey";
        String value = "testValue";
        IsNotEqualTo subject = new IsNotEqualTo(key, (Object)value);
        Assertions.assertThat((String)subject.key()).isEqualTo(key);
        Assertions.assertThat((Object)subject.comparisonValue()).isEqualTo((Object)value);
    }
}

