/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.filter.comparison;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.store.embedding.filter.comparison.IsEqualTo;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class IsEqualToTest {
    IsEqualToTest() {
    }

    @Test
    void shouldReturnFalseWhenNotMetadata() {
        IsEqualTo isEqualTo = new IsEqualTo("key", (Object)"value");
        Assertions.assertThat((boolean)isEqualTo.test((Object)"notMetadata")).isFalse();
    }

    @Test
    void shouldReturnFalseWhenKeyNotFound() {
        IsEqualTo isEqualTo = new IsEqualTo("key", (Object)"value");
        Metadata metadata = new Metadata(Map.of());
        Assertions.assertThat((boolean)isEqualTo.test((Object)metadata)).isFalse();
    }

    @Test
    void shouldReturnTrueWhenValuesAreNumbers() {
        IsEqualTo isEqualTo = new IsEqualTo("key", (Object)2);
        Metadata metadata = new Metadata(Map.of("key", 2));
        Assertions.assertThat((boolean)isEqualTo.test((Object)metadata)).isTrue();
    }

    @Test
    void shouldReturnTrueWhenValuesAreStrings() {
        IsEqualTo isEqualTo = new IsEqualTo("key", (Object)"value");
        Metadata metadata = new Metadata((Map)new HashMap<String, Object>(){
            {
                this.put("key", "value");
            }
        });
        Assertions.assertThat((boolean)isEqualTo.test((Object)metadata)).isTrue();
    }

    @Test
    void shouldReturnTrueWhenActualValueIsUUIDAsString() {
        final UUID uuid = UUID.randomUUID();
        IsEqualTo isEqualTo = new IsEqualTo("key", (Object)uuid);
        Metadata metadata = new Metadata((Map)new HashMap<String, Object>(this){
            final /* synthetic */ IsEqualToTest this$0;
            {
                this.this$0 = this$0;
                this.put("key", uuid.toString());
            }
        });
        Assertions.assertThat((boolean)isEqualTo.test((Object)metadata)).isTrue();
    }

    @Test
    void shouldReturnFalseWhenValuesAreDifferent() {
        IsEqualTo isEqualTo = new IsEqualTo("key", (Object)"value1");
        Metadata metadata = new Metadata(Map.of("key", "value2"));
        Assertions.assertThat((boolean)isEqualTo.test((Object)metadata)).isFalse();
    }

    @Test
    void shouldReturnTrueWhenComparingDifferentNumberTypes() {
        IsEqualTo isEqualTo = new IsEqualTo("key", (Object)1L);
        Metadata metadata = new Metadata(Map.of("key", 1));
        Assertions.assertThat((boolean)isEqualTo.test((Object)metadata)).isTrue();
    }

    @Test
    void shouldHandleCaseSensitiveStringComparison() {
        IsEqualTo isEqualTo = new IsEqualTo("key", (Object)"Value");
        Metadata metadata = new Metadata(Map.of("key", "value"));
        Assertions.assertThat((boolean)isEqualTo.test((Object)metadata)).isFalse();
    }

    @Test
    void shouldReturnFalseWhenTestingNullObject() {
        IsEqualTo isEqualTo = new IsEqualTo("key", (Object)"value");
        Assertions.assertThat((boolean)isEqualTo.test(null)).isFalse();
    }

    @Test
    void shouldThrowExceptionWhenComparisonValueIsNull() {
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> new IsEqualTo("key", null)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("comparisonValue with key 'key' cannot be null");
    }

    @Test
    void shouldHandleKeyWithSpecialCharacters() {
        IsEqualTo isEqualTo = new IsEqualTo("key.with.dots", (Object)"value");
        Metadata metadata = new Metadata(Map.of("key.with.dots", "value"));
        Assertions.assertThat((boolean)isEqualTo.test((Object)metadata)).isTrue();
    }

    @Test
    void shouldHandleFloatingPointComparison() {
        IsEqualTo isEqualTo = new IsEqualTo("key", (Object)0.1);
        Metadata metadata = new Metadata(Map.of("key", 0.1));
        Assertions.assertThat((boolean)isEqualTo.test((Object)metadata)).isTrue();
    }
}

