/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.query;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.rag.query.Metadata;
import dev.langchain4j.rag.query.Query;
import java.util.Arrays;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class QueryTest {
    QueryTest() {
    }

    @Test
    void create() {
        String queryText = "query";
        Query query = Query.from((String)queryText);
        Assertions.assertThat((String)query.text()).isEqualTo(queryText);
        Assertions.assertThat((Object)query.metadata()).isNull();
    }

    @Test
    void create_with_metadata() {
        String queryText = "query";
        Metadata metadata = Metadata.from((ChatMessage)UserMessage.from((String)"user message"), (Object)42, Arrays.asList(UserMessage.from((String)"Hello"), AiMessage.from((String)"Hi, how can I help you today?")));
        Query query = Query.from((String)queryText, (Metadata)metadata);
        Assertions.assertThat((String)query.text()).isEqualTo(queryText);
        Assertions.assertThat((Object)query.metadata()).isSameAs((Object)metadata);
    }

    @Test
    void equals_hash_code() {
        Metadata metadata1 = Metadata.from((ChatMessage)UserMessage.from((String)"user message"), (Object)42, Arrays.asList(UserMessage.from((String)"Hello"), AiMessage.from((String)"Hi, how can I help you today?")));
        Query query1 = Query.from((String)"query", (Metadata)metadata1);
        Metadata metadata2 = Metadata.from((ChatMessage)UserMessage.from((String)"another user message"), (Object)666, Arrays.asList(UserMessage.from((String)"Bye"), AiMessage.from((String)"Bye-bye")));
        Query query2 = Query.from((String)"query 2", (Metadata)metadata2);
        Metadata metadata3 = Metadata.from((ChatMessage)UserMessage.from((String)"user message"), (Object)42, Arrays.asList(UserMessage.from((String)"Hello"), AiMessage.from((String)"Hi, how can I help you today?")));
        Query query3 = Query.from((String)"query", (Metadata)metadata3);
        ((ObjectAssert)Assertions.assertThat((Object)query1).isNotEqualTo((Object)query2)).doesNotHaveSameHashCodeAs((Object)query2);
        ((ObjectAssert)Assertions.assertThat((Object)query1).isEqualTo((Object)query3)).hasSameHashCodeAs((Object)query3);
    }

    @Test
    void to_string() {
        Metadata metadata = Metadata.from((ChatMessage)UserMessage.from((String)"user message"), (Object)42, Arrays.asList(UserMessage.from((String)"Hello"), AiMessage.from((String)"Hi, how can I help you today?")));
        Query query = Query.from((String)"query", (Metadata)metadata);
        String toString = query.toString();
        Assertions.assertThat((String)toString).isEqualToIgnoringWhitespace((CharSequence)"Query { text = \"query\", metadata = Metadata { chatMessage = UserMessage { name = null, contents = [TextContent { text = \"user message\" }], attributes = {} }, chatMemory = [UserMessage { name = null, contents = [TextContent { text = \"Hello\" }], attributes = {} }, AiMessage { text = \"Hi, how can I help you today?\", thinking = null, toolExecutionRequests = [], attributes = {} }], invocationContext = DefaultInvocationContext{invocationId=null, interfaceName='null', methodName='null', methodArguments=[], chatMemoryId=42, invocationParameters=null, managedParameters=null, timestamp=null} } }\n");
    }

    @Test
    void should_create_query_with_null_text() {
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> Query.from(null)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("text cannot be null");
    }

    @Test
    void should_handle_multiline_query_text() {
        String multilineText = "first line\nsecond line\nthird line";
        Query query = Query.from((String)multilineText);
        Assertions.assertThat((String)query.text()).isEqualTo(multilineText);
        Assertions.assertThat((Object)query.metadata()).isNull();
    }

    @Test
    void should_not_be_equal_to_null() {
        Query query = Query.from((String)"test");
        Assertions.assertThat((Object)query).isNotEqualTo(null);
    }

    @Test
    void should_not_be_equal_to_different_type() {
        Query query = Query.from((String)"test");
        String notAQuery = "test";
        Assertions.assertThat((Object)query).isNotEqualTo((Object)notAQuery);
    }

    @Test
    void should_be_equal_to_itself() {
        Query query = Query.from((String)"test query");
        Assertions.assertThat((Object)query).isEqualTo((Object)query);
        Assertions.assertThat((Object)query).hasSameHashCodeAs((Object)query);
    }

    @Test
    void should_handle_queries_with_same_text_but_different_metadata() {
        String sameText = "identical text";
        Metadata metadata1 = Metadata.from((ChatMessage)UserMessage.from((String)"message1"), (Object)1, Arrays.asList(new ChatMessage[0]));
        Metadata metadata2 = Metadata.from((ChatMessage)UserMessage.from((String)"message2"), (Object)2, Arrays.asList(new ChatMessage[0]));
        Query query1 = Query.from((String)sameText, (Metadata)metadata1);
        Query query2 = Query.from((String)sameText, (Metadata)metadata2);
        Assertions.assertThat((Object)query1).isNotEqualTo((Object)query2);
        Assertions.assertThat((Object)query1).doesNotHaveSameHashCodeAs((Object)query2);
    }

    @Test
    void should_handle_queries_with_different_text_but_same_metadata() {
        Metadata sameMetadata = Metadata.from((ChatMessage)UserMessage.from((String)"message"), (Object)1, Arrays.asList(new ChatMessage[0]));
        Query query1 = Query.from((String)"text1", (Metadata)sameMetadata);
        Query query2 = Query.from((String)"text2", (Metadata)sameMetadata);
        Assertions.assertThat((Object)query1).isNotEqualTo((Object)query2);
        Assertions.assertThat((Object)query1).doesNotHaveSameHashCodeAs((Object)query2);
    }

    @Test
    void should_have_consistent_hash_code() {
        Metadata metadata = Metadata.from((ChatMessage)UserMessage.from((String)"message"), (Object)1, Arrays.asList(new ChatMessage[0]));
        Query query = Query.from((String)"test", (Metadata)metadata);
        int hashCode1 = query.hashCode();
        int hashCode2 = query.hashCode();
        Assertions.assertThat((int)hashCode1).isEqualTo(hashCode2);
    }

    @Test
    void toString_should_handle_query_without_metadata() {
        Query query = Query.from((String)"simple query");
        String toString = query.toString();
        Assertions.assertThat((String)toString).contains(new CharSequence[]{"simple query"});
        Assertions.assertThat((String)toString).contains(new CharSequence[]{"metadata = null"});
    }

    @Test
    void toString_should_not_be_null_or_empty() {
        Query queryWithoutMetadata = Query.from((String)"test");
        Query queryWithMetadata = Query.from((String)"test", (Metadata)Metadata.from((ChatMessage)UserMessage.from((String)"msg"), (Object)1, Arrays.asList(new ChatMessage[0])));
        ((AbstractStringAssert)Assertions.assertThat((String)queryWithoutMetadata.toString()).isNotNull()).isNotEmpty();
        ((AbstractStringAssert)Assertions.assertThat((String)queryWithMetadata.toString()).isNotNull()).isNotEmpty();
    }
}

