/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.rag.query;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.rag.query.Metadata;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class MetadataTest {
    MetadataTest() {
    }

    @Test
    void create() {
        UserMessage userMessage = UserMessage.from((String)"user message");
        int chatMemoryId = 42;
        List<ChatMessage> chatMemory = Arrays.asList(UserMessage.from((String)"Hello"), AiMessage.from((String)"Hi, how can I help you today?"));
        Metadata metadata = Metadata.from((ChatMessage)userMessage, (Object)chatMemoryId, chatMemory);
        Assertions.assertThat((Object)metadata.chatMessage()).isSameAs((Object)userMessage);
        Assertions.assertThat((Object)metadata.chatMemoryId()).isSameAs((Object)chatMemoryId);
        Assertions.assertThat((List)metadata.chatMemory()).isNotSameAs(chatMemory).isEqualTo(chatMemory);
    }

    @Test
    void equals_hash_code() {
        Metadata metadata1 = Metadata.from((ChatMessage)UserMessage.from((String)"user message"), (Object)42, Arrays.asList(UserMessage.from((String)"Hello"), AiMessage.from((String)"Hi, how can I help you today?")));
        Metadata metadata2 = Metadata.from((ChatMessage)UserMessage.from((String)"another user message"), (Object)666, Arrays.asList(UserMessage.from((String)"Bye"), AiMessage.from((String)"Bye-bye")));
        Metadata metadata3 = Metadata.from((ChatMessage)UserMessage.from((String)"user message"), (Object)42, Arrays.asList(UserMessage.from((String)"Hello"), AiMessage.from((String)"Hi, how can I help you today?")));
        ((ObjectAssert)Assertions.assertThat((Object)metadata1).isNotEqualTo((Object)metadata2)).doesNotHaveSameHashCodeAs((Object)metadata2);
        ((ObjectAssert)Assertions.assertThat((Object)metadata1).isEqualTo((Object)metadata3)).hasSameHashCodeAs((Object)metadata3);
    }

    @Test
    void to_string() {
        Metadata metadata = Metadata.from((ChatMessage)UserMessage.from((String)"user message"), (Object)42, Arrays.asList(UserMessage.from((String)"Hello"), AiMessage.from((String)"Hi, how can I help you today?")));
        String toString = metadata.toString();
        Assertions.assertThat((String)toString).isEqualToIgnoringWhitespace((CharSequence)"Metadata { chatMessage = UserMessage { name = null, contents = [TextContent { text = \"user message\" }], attributes = {} }, chatMemory = [UserMessage { name = null, contents = [TextContent { text = \"Hello\" }], attributes = {} }, AiMessage { text = \"Hi, how can I help you today?\", thinking = null, toolExecutionRequests = [], attributes = {} }], invocationContext = DefaultInvocationContext{invocationId=null, interfaceName='null', methodName='null', methodArguments=[], chatMemoryId=42, invocationParameters=null, managedParameters=null, timestamp=null} }\n");
    }

    @Test
    void create_with_empty_chat_memory() {
        UserMessage userMessage = UserMessage.from((String)"user message");
        int chatMemoryId = 1;
        List<ChatMessage> chatMemory = Arrays.asList(new ChatMessage[0]);
        Metadata metadata = Metadata.from((ChatMessage)userMessage, (Object)chatMemoryId, chatMemory);
        Assertions.assertThat((Object)metadata.chatMessage()).isSameAs((Object)userMessage);
        Assertions.assertThat((Object)metadata.chatMemoryId()).isSameAs((Object)chatMemoryId);
        Assertions.assertThat((List)metadata.chatMemory()).isEmpty();
    }

    @Test
    void create_with_different_message_types() {
        AiMessage aiMessage = AiMessage.from((String)"ai response");
        int chatMemoryId = 1;
        List<ChatMessage> chatMemory = Arrays.asList(UserMessage.from((String)"Question 1"), AiMessage.from((String)"Answer 1"), UserMessage.from((String)"Question 2"));
        Metadata metadata = Metadata.from((ChatMessage)aiMessage, (Object)chatMemoryId, chatMemory);
        Assertions.assertThat((Object)metadata.chatMessage()).isSameAs((Object)aiMessage);
        Assertions.assertThat((Object)metadata.chatMemoryId()).isSameAs((Object)chatMemoryId);
        Assertions.assertThat((List)metadata.chatMemory()).hasSize(3);
    }

    @Test
    void create_with_zero_chat_memory_id() {
        UserMessage userMessage = UserMessage.from((String)"test message");
        int chatMemoryId = 0;
        List<ChatMessage> chatMemory = Arrays.asList(UserMessage.from((String)"Hello"));
        Metadata metadata = Metadata.from((ChatMessage)userMessage, (Object)chatMemoryId, chatMemory);
        Assertions.assertThat((Object)metadata.chatMemoryId()).isEqualTo((Object)0);
    }

    @Test
    void equals_with_null_chat_memory() {
        Metadata metadata1 = Metadata.from((ChatMessage)UserMessage.from((String)"message"), (Object)1, null);
        Metadata metadata2 = Metadata.from((ChatMessage)UserMessage.from((String)"message"), (Object)1, null);
        ((ObjectAssert)Assertions.assertThat((Object)metadata1).isEqualTo((Object)metadata2)).hasSameHashCodeAs((Object)metadata2);
    }

    @Test
    void equals_with_different_chat_memory_ids() {
        List<ChatMessage> chatMemory = Arrays.asList(UserMessage.from((String)"Hello"));
        Metadata metadata1 = Metadata.from((ChatMessage)UserMessage.from((String)"message"), (Object)1, chatMemory);
        Metadata metadata2 = Metadata.from((ChatMessage)UserMessage.from((String)"message"), (Object)2, chatMemory);
        ((ObjectAssert)Assertions.assertThat((Object)metadata1).isNotEqualTo((Object)metadata2)).doesNotHaveSameHashCodeAs((Object)metadata2);
    }

    @Test
    void equals_with_different_chat_messages() {
        List<ChatMessage> chatMemory = Arrays.asList(UserMessage.from((String)"Hello"));
        Metadata metadata1 = Metadata.from((ChatMessage)UserMessage.from((String)"message1"), (Object)1, chatMemory);
        Metadata metadata2 = Metadata.from((ChatMessage)UserMessage.from((String)"message2"), (Object)1, chatMemory);
        ((ObjectAssert)Assertions.assertThat((Object)metadata1).isNotEqualTo((Object)metadata2)).doesNotHaveSameHashCodeAs((Object)metadata2);
    }

    @Test
    void chat_memory_immutability() {
        List<ChatMessage> originalChatMemory = Arrays.asList(UserMessage.from((String)"Hello"), AiMessage.from((String)"Hi"));
        Metadata metadata = Metadata.from((ChatMessage)UserMessage.from((String)"message"), (Object)1, originalChatMemory);
        List retrievedChatMemory = metadata.chatMemory();
        Assertions.assertThat((List)retrievedChatMemory).isNotSameAs(originalChatMemory);
        Assertions.assertThat((List)retrievedChatMemory).isEqualTo(originalChatMemory);
    }

    @Test
    void should_handle_null_chat_message() {
        ((AbstractThrowableAssert)AssertionsForClassTypes.assertThatThrownBy(() -> Metadata.from(null, (Object)1, Arrays.asList(UserMessage.from((String)"user message")))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("chatMessage cannot be null");
    }
}

