/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.input.structured;

import dev.langchain4j.model.input.Prompt;
import dev.langchain4j.model.input.structured.StructuredPrompt;
import dev.langchain4j.model.input.structured.StructuredPromptProcessor;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StructuredPromptProcessorTest {
    StructuredPromptProcessorTest() {
    }

    @Test
    void prompt_with_single_variable() {
        Greeting structuredPrompt = new Greeting("Klaus");
        Prompt prompt = StructuredPromptProcessor.toPrompt((Object)structuredPrompt);
        Assertions.assertThat((String)prompt.text()).isEqualTo("Hello, my name is Klaus");
    }

    @Test
    void prompt_with_multiple_variables() {
        SuggestRecipes structuredPrompt = new SuggestRecipes();
        structuredPrompt.dish = "salad";
        structuredPrompt.maxPreparationTime = 5;
        structuredPrompt.ingredients = Arrays.asList("Tomato", "Cucumber", "Onion");
        Prompt prompt = StructuredPromptProcessor.toPrompt((Object)structuredPrompt);
        Assertions.assertThat((String)prompt.text()).isEqualTo("Suggest tasty salad recipes that can be prepared in 5 minutes.\nI have only [Tomato, Cucumber, Onion] in my fridge.");
    }

    @Test
    void prompt_with_various_number_types() {
        VariousNumbers numbers = new VariousNumbers();
        numbers.nDouble = 17.15;
        numbers.nFloat = 1.0f;
        numbers.nInt = 2;
        numbers.nShort = (short)10;
        numbers.nLong = 12L;
        Prompt prompt = StructuredPromptProcessor.toPrompt((Object)numbers);
        Assertions.assertThat((String)prompt.text()).isEqualTo("Example of numbers with floating point: 17.15, 1.0 and whole numbers: 2, 10, 12");
    }

    @StructuredPrompt(value={"Hello, my name is {{name}}"})
    record Greeting(String name) {
    }

    @StructuredPrompt(value={"Suggest tasty {{dish}} recipes that can be prepared in {{maxPreparationTime}} minutes.", "I have only {{ingredients}} in my fridge."})
    static class SuggestRecipes {
        private String dish;
        private int maxPreparationTime;
        private List<String> ingredients;

        SuggestRecipes() {
        }
    }

    @StructuredPrompt(value={"Example of numbers with floating point: {{nDouble}}, {{nFloat}} and whole numbers: {{nInt}}, {{nShort}}, {{nLong}}"})
    static class VariousNumbers {
        private double nDouble;
        private float nFloat;
        private int nInt;
        private short nShort;
        private long nLong;

        VariousNumbers() {
        }
    }
}

