/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.mock;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.model.chat.mock.StreamingChatModelMock;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class StreamingChatModelMockTest {
    @Test
    void test_toTokens() {
        AiMessage aiMessage = AiMessage.from((String)"Hello");
        List<String> tokens = StreamingChatModelMock.toTokens(aiMessage);
        Assertions.assertThat(tokens).containsExactly((Object[])new String[]{"H", "e", "l", "l", "o"});
    }

    @Test
    void test_toTokens_with_empty_string() {
        AiMessage aiMessage = AiMessage.from((String)"");
        List<String> tokens = StreamingChatModelMock.toTokens(aiMessage);
        Assertions.assertThat(tokens).isEmpty();
    }

    @Test
    void test_toTokens_preserves_consecutive_spaces() {
        AiMessage aiMessage = AiMessage.from((String)"a  b");
        List<String> tokens = StreamingChatModelMock.toTokens(aiMessage);
        Assertions.assertThat(tokens).containsExactly((Object[])new String[]{"a", " ", " ", "b"});
    }
}

