/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.mock;

import dev.langchain4j.Experimental;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.InternalStreamingChatResponseHandlerUtils;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.CompleteToolCall;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.chat.response.StreamingHandle;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@Experimental
public class StreamingChatModelMock
implements StreamingChatModel {
    private final Queue<AiMessage> aiMessages;
    private final RuntimeException exception;

    public StreamingChatModelMock(List<String> tokens) {
        this((Collection<AiMessage>)List.of(StreamingChatModelMock.toAiMessage(tokens)));
    }

    public StreamingChatModelMock(Collection<AiMessage> aiMessages) {
        this.aiMessages = new ConcurrentLinkedQueue<AiMessage>(ValidationUtils.ensureNotEmpty(aiMessages, (String)"aiMessages"));
        this.exception = null;
    }

    public StreamingChatModelMock(RuntimeException exception) {
        this.aiMessages = null;
        this.exception = (RuntimeException)ValidationUtils.ensureNotNull((Object)exception, (String)"exception");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doChat(ChatRequest chatRequest, StreamingChatResponseHandler handler) {
        if (this.exception != null) {
            handler.onError((Throwable)this.exception);
        } else {
            AiMessage aiMessage = (AiMessage)ValidationUtils.ensureNotNull((Object)this.aiMessages.poll(), (String)"aiMessage");
            ExecutorService executor = Executors.newSingleThreadExecutor();
            try {
                executor.execute(() -> {
                    SimpleStreamingHandle streamingHandle = new SimpleStreamingHandle();
                    for (String token : StreamingChatModelMock.toTokens(aiMessage)) {
                        if (streamingHandle.isCancelled()) {
                            return;
                        }
                        InternalStreamingChatResponseHandlerUtils.onPartialResponse((StreamingChatResponseHandler)handler, (String)token, (StreamingHandle)streamingHandle);
                    }
                    for (int i = 0; i < aiMessage.toolExecutionRequests().size(); ++i) {
                        ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(i);
                        CompleteToolCall completeToolCall = new CompleteToolCall(i, toolExecutionRequest);
                        InternalStreamingChatResponseHandlerUtils.onCompleteToolCall((StreamingChatResponseHandler)handler, (CompleteToolCall)completeToolCall);
                    }
                    ChatResponse chatResponse = ChatResponse.builder().aiMessage(aiMessage).build();
                    InternalStreamingChatResponseHandlerUtils.onCompleteResponse((StreamingChatResponseHandler)handler, (ChatResponse)chatResponse);
                });
            }
            finally {
                executor.shutdown();
            }
        }
    }

    private static AiMessage toAiMessage(List<String> tokens) {
        String text = String.join((CharSequence)"", tokens);
        return AiMessage.from((String)text);
    }

    static List<String> toTokens(AiMessage aiMessage) {
        if (Utils.isNullOrEmpty((String)aiMessage.text())) {
            return List.of();
        }
        return aiMessage.text().chars().mapToObj(c -> String.valueOf((char)c)).toList();
    }

    public static StreamingChatModelMock thatAlwaysStreams(String ... tokens) {
        return new StreamingChatModelMock(Arrays.asList(tokens));
    }

    public static StreamingChatModelMock thatAlwaysStreams(List<String> tokens) {
        return new StreamingChatModelMock(tokens);
    }

    public static StreamingChatModelMock thatAlwaysStreams(AiMessage aiMessage) {
        return new StreamingChatModelMock((Collection<AiMessage>)List.of(aiMessage));
    }

    public static StreamingChatModelMock thatAlwaysStreams(AiMessage ... aiMessages) {
        return new StreamingChatModelMock((Collection<AiMessage>)Arrays.asList(aiMessages));
    }

    public static StreamingChatModelMock thatAlwaysStreams(Collection<AiMessage> aiMessages) {
        return new StreamingChatModelMock(aiMessages);
    }

    public static StreamingChatModelMock thatAlwaysThrowsException() {
        return StreamingChatModelMock.thatAlwaysThrowsExceptionWithMessage("Something went wrong, but this is an expected exception");
    }

    public static StreamingChatModelMock thatAlwaysThrowsExceptionWithMessage(String message) {
        return new StreamingChatModelMock(new RuntimeException(message));
    }

    private static class SimpleStreamingHandle
    implements StreamingHandle {
        private boolean isCancelled;

        private SimpleStreamingHandle() {
        }

        public void cancel() {
            this.isCancelled = true;
        }

        public boolean isCancelled() {
            return this.isCancelled;
        }
    }
}

