/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.common;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.Content;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.data.message.UserMessage;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.StreamingChatModel;
import dev.langchain4j.model.chat.common.ChatResponseAndStreamingMetadata;
import dev.langchain4j.model.chat.common.StreamingMetadata;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ResponseFormatType;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonRawSchema;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.CompleteToolCall;
import dev.langchain4j.model.chat.response.PartialResponse;
import dev.langchain4j.model.chat.response.PartialResponseContext;
import dev.langchain4j.model.chat.response.PartialToolCall;
import dev.langchain4j.model.chat.response.PartialToolCallContext;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.api.condition.EnabledIf;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class AbstractBaseChatModelIT<M> {
    static final String CAT_IMAGE_URL = "https://upload.wikimedia.org/wikipedia/commons/e/e9/Felis_silvestris_silvestris_small_gradual_decrease_of_quality.png";
    static final String DICE_IMAGE_URL = "https://upload.wikimedia.org/wikipedia/commons/4/47/PNG_transparency_demonstration_1.png";
    static final ToolSpecification WEATHER_TOOL = ToolSpecification.builder().name("getWeather").parameters(JsonObjectSchema.builder().addStringProperty("city").build()).build();
    static final ResponseFormat RESPONSE_FORMAT = ResponseFormat.builder().type(ResponseFormatType.JSON).jsonSchema(JsonSchema.builder().name("Answer").rootElement((JsonSchemaElement)JsonObjectSchema.builder().addStringProperty("city").required(new String[]{"city"}).build()).build()).build();

    protected abstract List<M> models();

    protected List<M> modelsSupportingTools() {
        return this.models();
    }

    protected List<M> modelsSupportingStructuredOutputs() {
        return this.models();
    }

    protected List<M> modelsSupportingImageInputs() {
        return this.models();
    }

    protected String catImageUrl() {
        return CAT_IMAGE_URL;
    }

    protected String diceImageUrl() {
        return DICE_IMAGE_URL;
    }

    protected abstract ChatResponseAndStreamingMetadata chat(M var1, ChatRequest var2);

    @ParameterizedTest
    @MethodSource(value={"models"})
    protected void should_respect_user_message(M model) {
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"What is the capital of Germany?")}).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata = this.chat(model, chatRequest);
        ChatResponse chatResponse = chatResponseAndStreamingMetadata.chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).containsIgnoringCase((CharSequence)"Berlin");
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        ChatResponseMetadata chatResponseMetadata = chatResponse.metadata();
        if (this.assertChatResponseMetadataType()) {
            Assertions.assertThat((Object)chatResponseMetadata).isExactlyInstanceOf(this.chatResponseMetadataType(model));
        }
        if (this.assertResponseId()) {
            Assertions.assertThat((String)chatResponseMetadata.id()).isNotBlank();
        }
        if (this.assertResponseModel()) {
            Assertions.assertThat((String)chatResponseMetadata.modelName()).isNotBlank();
        }
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponseMetadata, model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponseMetadata.finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata streamingMetadata = chatResponseAndStreamingMetadata.streamingMetadata();
            Assertions.assertThat((String)streamingMetadata.concatenatedPartialResponses()).isEqualTo(aiMessage.text());
            Assertions.assertThat((int)streamingMetadata.timesOnPartialResponseWasCalled()).isGreaterThan(1);
            Assertions.assertThat(streamingMetadata.partialToolCalls()).isEmpty();
            Assertions.assertThat(streamingMetadata.completeToolCalls()).isEmpty();
            Assertions.assertThat((int)streamingMetadata.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = streamingMetadata.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    protected void should_respect_system_message(M model) {
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{SystemMessage.from((String)"Translate messages from user into German"), UserMessage.from((String)"Translate: 'I love you'")}).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        Assertions.assertThat((String)chatResponse.aiMessage().text()).containsIgnoringCase((CharSequence)"liebe");
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @EnabledIf(value="supportsModelNameParameter")
    protected void should_respect_modelName_in_chat_request(M model) {
        String modelName = this.customModelName();
        this.ensureModelNameIsDifferentFromDefault(modelName, model);
        ChatRequestParameters parameters = ChatRequestParameters.builder().modelName(modelName).maxOutputTokens(Integer.valueOf(1)).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Tell me a story")}).parameters(parameters).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        Assertions.assertThat((String)chatResponse.aiMessage().text()).isNotBlank();
        Assertions.assertThat((String)chatResponse.metadata().modelName()).isEqualTo(modelName);
    }

    protected String customModelName() {
        throw new RuntimeException("Please implement this method in a similar way to OpenAiChatModelIT");
    }

    private void ensureModelNameIsDifferentFromDefault(String modelName, M model) {
        ChatRequest.Builder chatRequestBuilder = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Tell me a story")});
        if (this.supportsMaxOutputTokensParameter()) {
            ChatRequestParameters parameters = ChatRequestParameters.builder().maxOutputTokens(Integer.valueOf(1)).build();
            chatRequestBuilder.parameters(parameters);
        }
        ChatRequest chatRequest = chatRequestBuilder.build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        Assertions.assertThat((String)chatResponse.metadata().modelName()).isNotEqualTo((Object)modelName);
    }

    @Test
    @EnabledIf(value="supportsModelNameParameter")
    protected void should_respect_modelName_in_default_model_parameters() {
        String modelName = this.customModelName();
        ChatRequestParameters parameters = ChatRequestParameters.builder().modelName(modelName).maxOutputTokens(Integer.valueOf(1)).build();
        M model = this.createModelWith(parameters);
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Tell me a story")}).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        Assertions.assertThat((String)chatResponse.aiMessage().text()).isNotBlank();
        Assertions.assertThat((String)chatResponse.metadata().modelName()).isEqualTo(modelName);
    }

    protected M createModelWith(ChatRequestParameters parameters) {
        throw new RuntimeException("Please implement this method in a similar way to OpenAiChatModelIT");
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @DisabledIf(value="supportsModelNameParameter")
    protected void should_fail_if_modelName_is_not_supported(M model) {
        String modelName = "dummy";
        ChatRequestParameters parameters = ChatRequestParameters.builder().modelName(modelName).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Tell me a story")}).parameters(parameters).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest)).isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("modelName").hasMessageContaining("not support");
        if (this.supportsDefaultRequestParameters()) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createModelWith(parameters)).isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("modelName").hasMessageContaining("not support");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @EnabledIf(value="supportsMaxOutputTokensParameter")
    protected void should_respect_maxOutputTokens_in_chat_request(M model) {
        int maxOutputTokens = 5;
        ChatRequestParameters parameters = ChatRequestParameters.builder().maxOutputTokens(Integer.valueOf(maxOutputTokens)).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Tell me a long story")}).parameters(parameters).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata = this.chat(model, chatRequest);
        ChatResponse chatResponse = chatResponseAndStreamingMetadata.chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).isNotBlank();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), maxOutputTokens, model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.LENGTH);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata streamingMetadata = chatResponseAndStreamingMetadata.streamingMetadata();
            Assertions.assertThat((String)streamingMetadata.concatenatedPartialResponses()).isEqualTo(aiMessage.text());
            Assertions.assertThat((int)streamingMetadata.timesOnPartialResponseWasCalled()).isLessThanOrEqualTo(maxOutputTokens);
            Assertions.assertThat(streamingMetadata.partialToolCalls()).isEmpty();
            Assertions.assertThat(streamingMetadata.completeToolCalls()).isEmpty();
            Assertions.assertThat((int)streamingMetadata.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = streamingMetadata.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
    }

    @Test
    @EnabledIf(value="supportsMaxOutputTokensParameter")
    protected void should_respect_maxOutputTokens_in_default_model_parameters() {
        int maxOutputTokens = 5;
        ChatRequestParameters parameters = ChatRequestParameters.builder().maxOutputTokens(Integer.valueOf(maxOutputTokens)).build();
        M model = this.createModelWith(parameters);
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Tell me a long story")}).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata = this.chat(model, chatRequest);
        ChatResponse chatResponse = chatResponseAndStreamingMetadata.chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).isNotBlank();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), maxOutputTokens, model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.LENGTH);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata streamingMetadata = chatResponseAndStreamingMetadata.streamingMetadata();
            Assertions.assertThat((String)streamingMetadata.concatenatedPartialResponses()).isEqualTo(aiMessage.text());
            Assertions.assertThat((int)streamingMetadata.timesOnPartialResponseWasCalled()).isLessThanOrEqualTo(maxOutputTokens);
            Assertions.assertThat(streamingMetadata.partialToolCalls()).isEmpty();
            Assertions.assertThat(streamingMetadata.completeToolCalls()).isEmpty();
            Assertions.assertThat((int)streamingMetadata.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = streamingMetadata.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @DisabledIf(value="supportsMaxOutputTokensParameter")
    protected void should_fail_if_maxOutputTokens_parameter_is_not_supported(M model) {
        int maxOutputTokens = 5;
        ChatRequestParameters parameters = ChatRequestParameters.builder().maxOutputTokens(Integer.valueOf(maxOutputTokens)).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Tell me a long story")}).parameters(parameters).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest)).isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("maxOutputTokens").hasMessageContaining("not support");
        if (this.supportsDefaultRequestParameters()) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createModelWith(parameters)).isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("maxOutputTokens").hasMessageContaining("not support");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @EnabledIf(value="supportsStopSequencesParameter")
    protected void should_respect_stopSequences_in_chat_request(M model) {
        List<String> stopSequences = List.of("World", " World");
        ChatRequestParameters parameters = ChatRequestParameters.builder().stopSequences(stopSequences).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Say 'Hello World'")}).parameters(parameters).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).containsIgnoringCase((CharSequence)"Hello");
        Assertions.assertThat((String)aiMessage.text()).doesNotContainIgnoringCase(new CharSequence[]{"World"});
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
    }

    @Test
    @EnabledIf(value="supportsStopSequencesParameter")
    protected void should_respect_stopSequences_in_default_model_parameters() {
        List<String> stopSequences = List.of("World", " World");
        ChatRequestParameters parameters = ChatRequestParameters.builder().stopSequences(stopSequences).build();
        M model = this.createModelWith(parameters);
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Say 'Hello World'")}).parameters(parameters).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).containsIgnoringCase((CharSequence)"Hello");
        Assertions.assertThat((String)aiMessage.text()).doesNotContainIgnoringCase(new CharSequence[]{"World"});
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @DisabledIf(value="supportsStopSequencesParameter")
    protected void should_fail_if_stopSequences_parameter_is_not_supported(M model) {
        List<String> stopSequences = List.of("World");
        ChatRequestParameters parameters = ChatRequestParameters.builder().stopSequences(stopSequences).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"Say 'Hello World'")}).parameters(parameters).build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest)).isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("stopSequences").hasMessageContaining("not support");
        if (this.supportsDefaultRequestParameters()) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.createModelWith(parameters)).isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("stopSequences").hasMessageContaining("not support");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @EnabledIf(value="supportsMaxOutputTokensParameter")
    protected void should_respect_common_parameters_wrapped_in_integration_specific_class_in_chat_request(M model) {
        int maxOutputTokens = 5;
        ChatRequestParameters parameters = this.createIntegrationSpecificParameters(maxOutputTokens);
        ChatRequest chatRequest = ChatRequest.builder().parameters(parameters).messages(new ChatMessage[]{UserMessage.from((String)"Tell me a long story")}).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).isNotBlank();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), maxOutputTokens, model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.LENGTH);
        }
    }

    @Test
    @EnabledIf(value="supportsMaxOutputTokensParameter")
    protected void should_respect_common_parameters_wrapped_in_integration_specific_class_in_default_model_parameters() {
        int maxOutputTokens = 5;
        ChatRequestParameters parameters = this.createIntegrationSpecificParameters(maxOutputTokens);
        M model = this.createModelWith(parameters);
        ChatRequest chatRequest = ChatRequest.builder().parameters(parameters).messages(new ChatMessage[]{UserMessage.from((String)"Tell me a long story")}).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).isNotBlank();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), maxOutputTokens, model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.LENGTH);
        }
    }

    protected ChatRequestParameters createIntegrationSpecificParameters(int maxOutputTokens) {
        throw new RuntimeException("Please implement this method in a similar way to OpenAiChatModelIT");
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingTools"})
    @EnabledIf(value="supportsTools")
    protected void should_execute_a_tool_then_answer(M model) {
        UserMessage userMessage = UserMessage.from((String)"What is the weather in Munich?");
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL}).build()).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata = this.chat(model, chatRequest);
        ChatResponse chatResponse = chatResponseAndStreamingMetadata.chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).hasSize(1);
        ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
        if (this.assertToolId(model)) {
            Assertions.assertThat((String)toolExecutionRequest.id()).isNotBlank();
        }
        Assertions.assertThat((String)toolExecutionRequest.name()).isEqualTo(WEATHER_TOOL.name());
        Assertions.assertThat((String)toolExecutionRequest.arguments()).isEqualToIgnoringWhitespace((CharSequence)"{\"city\":\"Munich\"}");
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.TOOL_EXECUTION);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata metadata = chatResponseAndStreamingMetadata.streamingMetadata();
            Assertions.assertThat((String)metadata.concatenatedPartialResponses()).isEqualTo(aiMessage.text());
            if (metadata.timesOnPartialResponseWasCalled() == 0) {
                Assertions.assertThat((String)aiMessage.text()).isNull();
            }
            if (this.supportsPartialToolStreaming((StreamingChatModel)model)) {
                Assertions.assertThat(metadata.partialToolCalls()).isNotEmpty();
                StringBuilder arguments = new StringBuilder();
                PartialToolCall previousToolCall = null;
                for (PartialToolCall toolCall : metadata.partialToolCalls()) {
                    Assertions.assertThat((int)toolCall.index()).isEqualTo(0);
                    Assertions.assertThat((String)toolCall.id()).isEqualTo(toolExecutionRequest.id());
                    Assertions.assertThat((String)toolCall.name()).isEqualTo(toolExecutionRequest.name());
                    Assertions.assertThat((String)toolCall.partialArguments()).isNotBlank();
                    arguments.append(toolCall.partialArguments());
                    if (previousToolCall != null) {
                        Assertions.assertThat((String)toolCall.id()).isEqualTo(previousToolCall.id());
                        Assertions.assertThat((String)toolCall.name()).isEqualTo(previousToolCall.name());
                    }
                    previousToolCall = toolCall;
                }
                Assertions.assertThat((StringBuilder)arguments).hasToString(toolExecutionRequest.arguments());
            }
            Assertions.assertThat(metadata.completeToolCalls()).hasSize(1);
            Assertions.assertThat((int)metadata.completeToolCalls().get(0).index()).isEqualTo(0);
            Assertions.assertThat((Object)metadata.completeToolCalls().get(0).toolExecutionRequest()).isEqualTo((Object)toolExecutionRequest);
            StreamingChatResponseHandler handler = metadata.handler();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
            this.verifyToolCallbacks(handler, inOrder, toolExecutionRequest.id(), (StreamingChatModel)model);
            ((StreamingChatResponseHandler)inOrder.verify((Object)handler)).onCompleteResponse(chatResponse);
            inOrder.verifyNoMoreInteractions();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
            Assertions.assertThat((int)metadata.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = metadata.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
        ChatRequest chatRequest2 = ChatRequest.builder().messages(new ChatMessage[]{userMessage, aiMessage, ToolExecutionResultMessage.from((ToolExecutionRequest)toolExecutionRequest, (String)"sunny")}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL}).build()).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata2 = this.chat(model, chatRequest2);
        ChatResponse chatResponse2 = chatResponseAndStreamingMetadata2.chatResponse();
        AiMessage aiMessage2 = chatResponse2.aiMessage();
        Assertions.assertThat((String)aiMessage2.text()).containsIgnoringCase((CharSequence)"sun");
        Assertions.assertThat((List)aiMessage2.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse2.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse2.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata streamingMetadata2 = chatResponseAndStreamingMetadata2.streamingMetadata();
            Assertions.assertThat((String)streamingMetadata2.concatenatedPartialResponses()).isEqualTo(aiMessage2.text());
            if (this.assertTimesOnPartialResponseWasCalled()) {
                Assertions.assertThat((int)streamingMetadata2.timesOnPartialResponseWasCalled()).isGreaterThan(1);
            }
            Assertions.assertThat(streamingMetadata2.partialToolCalls()).isEmpty();
            Assertions.assertThat(streamingMetadata2.completeToolCalls()).isEmpty();
            Assertions.assertThat((int)streamingMetadata2.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = streamingMetadata2.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
    }

    protected void verifyToolCallbacks(StreamingChatResponseHandler handler, InOrder io, String id, StreamingChatModel model) {
        this.verifyToolCallbacks(handler, io, id);
    }

    protected void verifyToolCallbacks(StreamingChatResponseHandler handler, InOrder io, String id) {
        Assertions.fail((String)"please override this method");
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingTools"})
    @EnabledIf(value="supportsTools")
    protected void should_execute_a_tool_without_arguments_then_answer(M model) {
        UserMessage userMessage = UserMessage.from((String)"What is the time now? Use the get_current_time tool.");
        ToolSpecification timeTool = ToolSpecification.builder().name("get_current_time").build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{timeTool}).build()).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata = this.chat(model, chatRequest);
        ChatResponse chatResponse = chatResponseAndStreamingMetadata.chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).hasSize(1);
        ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
        if (this.assertToolId(model)) {
            Assertions.assertThat((String)toolExecutionRequest.id()).isNotBlank();
        }
        Assertions.assertThat((String)toolExecutionRequest.name()).isEqualTo(timeTool.name());
        Assertions.assertThat((String)toolExecutionRequest.arguments()).isEqualToIgnoringWhitespace((CharSequence)"{}");
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.TOOL_EXECUTION);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata metadata = chatResponseAndStreamingMetadata.streamingMetadata();
            Assertions.assertThat((String)metadata.concatenatedPartialResponses()).isEqualTo(aiMessage.text());
            if (metadata.timesOnPartialResponseWasCalled() == 0) {
                Assertions.assertThat((String)aiMessage.text()).isNull();
            }
            if (this.supportsPartialToolStreaming((StreamingChatModel)model)) {
                Assertions.assertThat(metadata.partialToolCalls()).hasSize(1);
                PartialToolCall partialRequest = metadata.partialToolCalls().get(0);
                Assertions.assertThat((int)partialRequest.index()).isEqualTo(0);
                Assertions.assertThat((String)partialRequest.id()).isEqualTo(toolExecutionRequest.id());
                Assertions.assertThat((String)partialRequest.name()).isEqualTo(toolExecutionRequest.name());
                Assertions.assertThat((String)partialRequest.partialArguments()).isEqualTo(toolExecutionRequest.arguments());
            }
            Assertions.assertThat(metadata.completeToolCalls()).hasSize(1);
            Assertions.assertThat((int)metadata.completeToolCalls().get(0).index()).isEqualTo(0);
            Assertions.assertThat((Object)metadata.completeToolCalls().get(0).toolExecutionRequest()).isEqualTo((Object)toolExecutionRequest);
            StreamingChatResponseHandler handler = metadata.handler();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
            this.verifyToolCallbacks(handler, inOrder, (StreamingChatModel)model);
            ((StreamingChatResponseHandler)inOrder.verify((Object)handler)).onCompleteResponse(chatResponse);
            inOrder.verifyNoMoreInteractions();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
            Assertions.assertThat((int)metadata.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = metadata.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
        ChatRequest chatRequest2 = ChatRequest.builder().messages(new ChatMessage[]{userMessage, aiMessage, ToolExecutionResultMessage.from((ToolExecutionRequest)toolExecutionRequest, (String)"10:14")}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{timeTool}).build()).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata2 = this.chat(model, chatRequest2);
        ChatResponse chatResponse2 = chatResponseAndStreamingMetadata2.chatResponse();
        AiMessage aiMessage2 = chatResponse2.aiMessage();
        Assertions.assertThat((String)aiMessage2.text()).contains(new CharSequence[]{"10", "14"});
        Assertions.assertThat((List)aiMessage2.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse2.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse2.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata streamingMetadata2 = chatResponseAndStreamingMetadata2.streamingMetadata();
            Assertions.assertThat((String)streamingMetadata2.concatenatedPartialResponses()).isEqualTo(aiMessage2.text());
            if (this.assertTimesOnPartialResponseWasCalled()) {
                Assertions.assertThat((int)streamingMetadata2.timesOnPartialResponseWasCalled()).isGreaterThan(1);
            }
            Assertions.assertThat(streamingMetadata2.partialToolCalls()).isEmpty();
            Assertions.assertThat(streamingMetadata2.completeToolCalls()).isEmpty();
            Assertions.assertThat((int)streamingMetadata2.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = streamingMetadata2.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
    }

    protected void verifyToolCallbacks(StreamingChatResponseHandler handler, InOrder io, StreamingChatModel model) {
        ((StreamingChatResponseHandler)io.verify((Object)handler, Mockito.atLeast((int)0))).onPartialResponse((PartialResponse)ArgumentMatchers.any(), (PartialResponseContext)ArgumentMatchers.any());
        if (this.supportsPartialToolStreaming(model)) {
            ((StreamingChatResponseHandler)io.verify((Object)handler)).onPartialToolCall((PartialToolCall)ArgumentMatchers.any(), (PartialToolCallContext)ArgumentMatchers.any());
        }
        ((StreamingChatResponseHandler)io.verify((Object)handler)).onCompleteToolCall((CompleteToolCall)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingTools"})
    @EnabledIf(value="supportsTools")
    protected void should_execute_multiple_tools_in_parallel_then_answer(M model) {
        UserMessage userMessage = UserMessage.from((String)"What is the weather in Munich and time in France? Call tools simultaneously (in parallel)");
        ToolSpecification timeTool = ToolSpecification.builder().name("getTime").parameters(JsonObjectSchema.builder().addStringProperty("country").build()).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL, timeTool}).build()).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata = this.chat(model, chatRequest);
        ChatResponse chatResponse = chatResponseAndStreamingMetadata.chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        List toolExecutionRequests = aiMessage.toolExecutionRequests();
        Assertions.assertThat((List)toolExecutionRequests).hasSize(2);
        if (this.assertToolId(model)) {
            Assertions.assertThat((String)((ToolExecutionRequest)toolExecutionRequests.get(0)).id()).isNotBlank();
        }
        Assertions.assertThat((String)((ToolExecutionRequest)toolExecutionRequests.get(0)).name()).isEqualTo(WEATHER_TOOL.name());
        Assertions.assertThat((String)((ToolExecutionRequest)toolExecutionRequests.get(0)).arguments()).isEqualToIgnoringWhitespace((CharSequence)"{\"city\":\"Munich\"}");
        if (this.assertToolId(model)) {
            ((AbstractStringAssert)Assertions.assertThat((String)((ToolExecutionRequest)toolExecutionRequests.get(1)).id()).isNotBlank()).isNotEqualTo((Object)((ToolExecutionRequest)toolExecutionRequests.get(0)).id());
        }
        Assertions.assertThat((String)((ToolExecutionRequest)toolExecutionRequests.get(1)).name()).isEqualTo(timeTool.name());
        Assertions.assertThat((String)((ToolExecutionRequest)toolExecutionRequests.get(1)).arguments()).isEqualToIgnoringWhitespace((CharSequence)"{\"country\":\"France\"}");
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.TOOL_EXECUTION);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata metadata = chatResponseAndStreamingMetadata.streamingMetadata();
            Assertions.assertThat((String)metadata.concatenatedPartialResponses()).isEqualTo(aiMessage.text());
            if (metadata.timesOnPartialResponseWasCalled() == 0) {
                Assertions.assertThat((String)aiMessage.text()).isNull();
            }
            if (this.supportsPartialToolStreaming((StreamingChatModel)model)) {
                Assertions.assertThat(metadata.partialToolCalls()).hasSizeGreaterThanOrEqualTo(2);
                Assertions.assertThat((int)metadata.partialToolCalls().get(0).index()).isEqualTo(0);
                Assertions.assertThat((int)metadata.partialToolCalls().get(metadata.partialToolCalls().size() - 1).index()).isEqualTo(1);
                List<List<PartialToolCall>> partialToolCallPartitions = AbstractBaseChatModelIT.partitionByIndex(metadata.partialToolCalls());
                Assertions.assertThat(partialToolCallPartitions).hasSize(2);
                for (int i = 0; i < partialToolCallPartitions.size(); ++i) {
                    List<PartialToolCall> partialToolCallPartition = partialToolCallPartitions.get(i);
                    StringBuilder arguments = new StringBuilder();
                    PartialToolCall previousToolCall = null;
                    for (PartialToolCall toolCall : partialToolCallPartition) {
                        Assertions.assertThat((String)toolCall.id()).isEqualTo(((ToolExecutionRequest)toolExecutionRequests.get(i)).id());
                        Assertions.assertThat((String)toolCall.name()).isEqualTo(((ToolExecutionRequest)toolExecutionRequests.get(i)).name());
                        Assertions.assertThat((String)toolCall.partialArguments()).isNotBlank();
                        arguments.append(toolCall.partialArguments());
                        if (previousToolCall != null) {
                            Assertions.assertThat((String)toolCall.id()).isEqualTo(previousToolCall.id());
                            Assertions.assertThat((String)toolCall.name()).isEqualTo(previousToolCall.name());
                        }
                        previousToolCall = toolCall;
                    }
                    Assertions.assertThat((StringBuilder)arguments).hasToString(((ToolExecutionRequest)toolExecutionRequests.get(i)).arguments());
                }
            }
            Assertions.assertThat(metadata.completeToolCalls()).hasSize(2);
            Assertions.assertThat((int)metadata.completeToolCalls().get(0).index()).isEqualTo(0);
            Assertions.assertThat((Object)metadata.completeToolCalls().get(0).toolExecutionRequest()).isEqualTo(toolExecutionRequests.get(0));
            Assertions.assertThat((int)metadata.completeToolCalls().get(1).index()).isEqualTo(1);
            Assertions.assertThat((Object)metadata.completeToolCalls().get(1).toolExecutionRequest()).isEqualTo(toolExecutionRequests.get(1));
            StreamingChatResponseHandler handler = metadata.handler();
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{handler});
            this.verifyToolCallbacks(handler, inOrder, ((ToolExecutionRequest)toolExecutionRequests.get(0)).id(), ((ToolExecutionRequest)toolExecutionRequests.get(1)).id(), (StreamingChatModel)model);
            ((StreamingChatResponseHandler)inOrder.verify((Object)handler)).onCompleteResponse(chatResponse);
            inOrder.verifyNoMoreInteractions();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
            Assertions.assertThat((int)metadata.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = metadata.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
        ChatRequest chatRequest2 = ChatRequest.builder().messages(new ChatMessage[]{userMessage, aiMessage, ToolExecutionResultMessage.from((ToolExecutionRequest)((ToolExecutionRequest)toolExecutionRequests.get(0)), (String)"sunny"), ToolExecutionResultMessage.from((ToolExecutionRequest)((ToolExecutionRequest)toolExecutionRequests.get(1)), (String)"14:35")}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL, timeTool}).build()).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata2 = this.chat(model, chatRequest2);
        ChatResponse chatResponse2 = chatResponseAndStreamingMetadata2.chatResponse();
        AiMessage aiMessage2 = chatResponse2.aiMessage();
        ((AbstractStringAssert)Assertions.assertThat((String)aiMessage2.text()).containsIgnoringCase((CharSequence)"sun")).contains(new CharSequence[]{"14", "35"});
        Assertions.assertThat((List)aiMessage2.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse2.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse2.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata streamingMetadata2 = chatResponseAndStreamingMetadata2.streamingMetadata();
            Assertions.assertThat((String)streamingMetadata2.concatenatedPartialResponses()).isEqualTo(aiMessage2.text());
            if (this.assertTimesOnPartialResponseWasCalled()) {
                Assertions.assertThat((int)streamingMetadata2.timesOnPartialResponseWasCalled()).isGreaterThan(1);
            }
            Assertions.assertThat(streamingMetadata2.partialToolCalls()).isEmpty();
            Assertions.assertThat(streamingMetadata2.completeToolCalls()).isEmpty();
            Assertions.assertThat((int)streamingMetadata2.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = streamingMetadata2.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
    }

    protected void verifyToolCallbacks(StreamingChatResponseHandler handler, InOrder io, String id1, String id2, StreamingChatModel model) {
        this.verifyToolCallbacks(handler, io, id1, id2);
    }

    protected void verifyToolCallbacks(StreamingChatResponseHandler handler, InOrder io, String id1, String id2) {
        Assertions.fail((String)"please override this method");
    }

    protected static PartialToolCall partial(int index, String id, String name, String args) {
        return PartialToolCall.builder().index(index).id(id).name(name).partialArguments(args).build();
    }

    protected static CompleteToolCall complete(int index, String id, String name, String args) {
        ToolExecutionRequest toolExecutionRequest = ToolExecutionRequest.builder().id(id).name(name).arguments(args).build();
        return new CompleteToolCall(index, toolExecutionRequest);
    }

    private static List<List<PartialToolCall>> partitionByIndex(List<PartialToolCall> partialToolCalls) {
        ArrayList<List<PartialToolCall>> result = new ArrayList<List<PartialToolCall>>();
        ArrayList<PartialToolCall> currentPartition = new ArrayList<PartialToolCall>();
        int currentIndex = -1;
        for (PartialToolCall partialToolCall : partialToolCalls) {
            if (currentIndex == -1 || partialToolCall.index() != currentIndex) {
                if (!currentPartition.isEmpty()) {
                    result.add(currentPartition);
                    currentPartition = new ArrayList();
                }
                currentIndex = partialToolCall.index();
            }
            currentPartition.add(partialToolCall);
        }
        if (!currentPartition.isEmpty()) {
            result.add(currentPartition);
        }
        return result;
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @DisabledIf(value="supportsTools")
    protected void should_fail_if_tools_are_not_supported(M model) {
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"What is the weather in Munich?")}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL}).build()).build();
        AbstractThrowableAssert throwableAssert = Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest));
        if (this.assertExceptionType()) {
            ((AbstractThrowableAssert)throwableAssert.isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("tool").hasMessageContaining("not support");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingTools"})
    @EnabledIf(value="supportsToolChoiceRequiredWithMultipleTools")
    protected void should_force_LLM_to_execute_any_tool(M model) {
        ToolSpecification calculatorTool = ToolSpecification.builder().name("add_two_numbers").parameters(JsonObjectSchema.builder().addIntegerProperty("a").addIntegerProperty("b").build()).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"I live in Munich")}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL, calculatorTool}).toolChoice(ToolChoice.REQUIRED).build()).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).hasSize(1);
        ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
        Assertions.assertThat((String)toolExecutionRequest.name()).isEqualTo(WEATHER_TOOL.name());
        Assertions.assertThat((String)toolExecutionRequest.arguments()).isEqualToIgnoringWhitespace((CharSequence)"{\"city\":\"Munich\"}");
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.TOOL_EXECUTION);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingTools"})
    @EnabledIf(value="supportsToolChoiceRequiredWithSingleTool")
    protected void should_force_LLM_to_execute_specific_tool(M model) {
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"I live in Munich")}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL}).toolChoice(ToolChoice.REQUIRED).build()).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).hasSize(1);
        ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
        Assertions.assertThat((String)toolExecutionRequest.name()).isEqualTo(WEATHER_TOOL.name());
        Assertions.assertThat((String)toolExecutionRequest.arguments()).isEqualToIgnoringWhitespace((CharSequence)"{\"city\":\"Munich\"}");
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.TOOL_EXECUTION);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingTools"})
    @DisabledIf(value="supportsToolChoiceRequired")
    protected void should_fail_if_tool_choice_REQUIRED_is_not_supported(M model) {
        ToolChoice toolChoice = ToolChoice.REQUIRED;
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"I live in Munich")}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL}).toolChoice(toolChoice).build()).build();
        AbstractThrowableAssert throwableAssert = Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest));
        if (this.assertExceptionType()) {
            ((AbstractThrowableAssert)throwableAssert.isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("ToolChoice.REQUIRED").hasMessageContaining("not support");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingStructuredOutputs"})
    @EnabledIf(value="supportsJsonResponseFormat")
    protected void should_respect_JSON_response_format(M model) {
        ResponseFormat responseFormat = ResponseFormat.JSON;
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"What is the capital of Germany? Answer with a JSON object containing a single 'city' field")}).parameters(ChatRequestParameters.builder().responseFormat(responseFormat).build()).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).isEqualToIgnoringWhitespace((CharSequence)"{\"city\": \"Berlin\"}");
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @DisabledIf(value="supportsJsonResponseFormat")
    protected void should_fail_if_JSON_response_format_is_not_supported(M model) {
        ResponseFormat responseFormat = ResponseFormat.JSON;
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"What is the capital of Germany? Answer with a JSON object containing a single 'city' field")}).parameters(ChatRequestParameters.builder().responseFormat(responseFormat).build()).build();
        AbstractThrowableAssert throwableAssert = Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest));
        if (this.assertExceptionType()) {
            ((AbstractThrowableAssert)throwableAssert.isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("JSON response format").hasMessageContaining("not support");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingStructuredOutputs"})
    @EnabledIf(value="supportsJsonResponseFormatWithSchema")
    protected void should_respect_JSON_response_format_with_schema(M model) {
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"What is the capital of Germany?")}).parameters(ChatRequestParameters.builder().responseFormat(RESPONSE_FORMAT).build()).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).isEqualToIgnoringWhitespace((CharSequence)"{\"city\": \"Berlin\"}");
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @EnabledIf(value="supportsJsonResponseFormatWithRawSchema")
    protected void should_respect_JsonRawSchema_responseFormat(M model) {
        String rawSchema = "{\n    \"$schema\": \"http://json-schema.org/draft-07/schema#\",\n    \"type\": \"object\",\n    \"properties\": {\n        \"city\": {\n            \"type\": \"string\"\n        }\n    },\n    \"required\": [\"city\"],\n    \"additionalProperties\": false\n}";
        ResponseFormat schemaFormat = ResponseFormat.builder().type(ResponseFormatType.JSON).jsonSchema(JsonSchema.builder().name("Answer").rootElement((JsonSchemaElement)JsonRawSchema.from((String)rawSchema)).build()).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"What is the capital of Germany?")}).parameters(ChatRequestParameters.builder().responseFormat(schemaFormat).build()).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text()).isEqualToIgnoringWhitespace((CharSequence)"{\"city\": \"Berlin\"}");
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"models"})
    @DisabledIf(value="supportsJsonResponseFormatWithSchema")
    protected void should_fail_if_JSON_response_format_with_schema_is_not_supported(M model) {
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{UserMessage.from((String)"What is the capital of Germany?")}).parameters(ChatRequestParameters.builder().responseFormat(RESPONSE_FORMAT).build()).build();
        AbstractThrowableAssert throwableAssert = Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest));
        if (this.assertExceptionType()) {
            ((AbstractThrowableAssert)throwableAssert.isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("JSON response format").hasMessageContaining("not support");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingTools"})
    @EnabledIf(value="supportsToolsAndJsonResponseFormatWithSchema")
    protected void should_execute_a_tool_then_answer_respecting_JSON_response_format_with_schema(M model) {
        UserMessage userMessage = UserMessage.from((String)"What is the weather in Munich?");
        ResponseFormat responseFormat = ResponseFormat.builder().type(ResponseFormatType.JSON).jsonSchema(JsonSchema.builder().name("weather").rootElement((JsonSchemaElement)JsonObjectSchema.builder().addEnumProperty("weather", List.of("sunny", "rainy")).build()).build()).build();
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL}).responseFormat(responseFormat).build()).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata = this.chat(model, chatRequest);
        ChatResponse chatResponse = chatResponseAndStreamingMetadata.chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).hasSize(1);
        ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
        Assertions.assertThat((String)toolExecutionRequest.name()).isEqualTo(WEATHER_TOOL.name());
        Assertions.assertThat((String)toolExecutionRequest.arguments()).isEqualToIgnoringWhitespace((CharSequence)"{\"city\":\"Munich\"}");
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.TOOL_EXECUTION);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata streamingMetadata = chatResponseAndStreamingMetadata.streamingMetadata();
            Assertions.assertThat((String)streamingMetadata.concatenatedPartialResponses()).isEqualTo(aiMessage.text());
            if (streamingMetadata.timesOnPartialResponseWasCalled() == 0) {
                Assertions.assertThat((String)aiMessage.text()).isNull();
            }
            Assertions.assertThat((int)streamingMetadata.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = streamingMetadata.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
        ChatRequest chatRequest2 = ChatRequest.builder().messages(new ChatMessage[]{userMessage, aiMessage, ToolExecutionResultMessage.from((ToolExecutionRequest)toolExecutionRequest, (String)"sunny")}).parameters(ChatRequestParameters.builder().toolSpecifications(new ToolSpecification[]{WEATHER_TOOL}).responseFormat(responseFormat).build()).build();
        ChatResponseAndStreamingMetadata chatResponseAndStreamingMetadata2 = this.chat(model, chatRequest2);
        ChatResponse chatResponse2 = chatResponseAndStreamingMetadata2.chatResponse();
        AiMessage aiMessage2 = chatResponse2.aiMessage();
        Assertions.assertThat((String)aiMessage2.text()).isEqualToIgnoringWhitespace((CharSequence)"{\"weather\":\"sunny\"}");
        Assertions.assertThat((List)aiMessage2.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse2.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse2.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
        if (model instanceof StreamingChatModel) {
            StreamingMetadata streamingMetadata2 = chatResponseAndStreamingMetadata2.streamingMetadata();
            Assertions.assertThat((String)streamingMetadata2.concatenatedPartialResponses()).isEqualTo(aiMessage2.text());
            Assertions.assertThat((int)streamingMetadata2.timesOnPartialResponseWasCalled()).isGreaterThan(1);
            Assertions.assertThat((int)streamingMetadata2.timesOnCompleteResponseWasCalled()).isEqualTo(1);
            if (this.assertThreads()) {
                Set<Thread> threads = streamingMetadata2.threads();
                Assertions.assertThat(threads).hasSize(1);
                Assertions.assertThat((Object)threads.iterator().next()).isNotEqualTo((Object)Thread.currentThread());
            }
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingImageInputs"})
    @EnabledIf(value="supportsSingleImageInputAsBase64EncodedString")
    protected void should_accept_single_image_as_base64_encoded_string(M model) {
        String base64Data = Base64.getEncoder().encodeToString(Utils.readBytes((String)this.catImageUrl()));
        UserMessage userMessage = UserMessage.from((Content[])new Content[]{TextContent.from((String)"What do you see?"), ImageContent.from((String)base64Data, (String)"image/png")});
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text().toLowerCase()).containsAnyOf(new CharSequence[]{"cat", "lynx", "feline", "animal"});
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingImageInputs"})
    @EnabledIf(value="supportsMultipleImageInputsAsBase64EncodedStrings")
    protected void should_accept_multiple_images_as_base64_encoded_strings(M model) {
        Base64.Encoder encoder = Base64.getEncoder();
        UserMessage userMessage = UserMessage.from((Content[])new Content[]{TextContent.from((String)"What do you see on these images? Describe both images."), ImageContent.from((String)encoder.encodeToString(Utils.readBytes((String)this.catImageUrl())), (String)"image/png"), ImageContent.from((String)encoder.encodeToString(Utils.readBytes((String)this.diceImageUrl())), (String)"image/png")});
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        ((AbstractStringAssert)Assertions.assertThat((String)aiMessage.text().toLowerCase()).containsAnyOf(new CharSequence[]{"cat", "lynx", "feline", "animal"})).contains(new CharSequence[]{"dice"});
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingImageInputs"})
    @DisabledIf(value="supportsSingleImageInputAsBase64EncodedString")
    protected void should_fail_if_images_as_base64_encoded_strings_are_not_supported(M model) {
        String base64Data = Base64.getEncoder().encodeToString(Utils.readBytes((String)this.catImageUrl()));
        UserMessage userMessage = UserMessage.from((Content[])new Content[]{TextContent.from((String)"What do you see?"), ImageContent.from((String)base64Data, (String)"image/png")});
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).build();
        AbstractThrowableAssert throwableAssert = Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest));
        if (this.assertExceptionType()) {
            ((AbstractThrowableAssert)throwableAssert.isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("image").hasMessageContaining("not support");
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingImageInputs"})
    @EnabledIf(value="supportsSingleImageInputAsPublicURL")
    protected void should_accept_single_image_as_public_URL(M model) {
        UserMessage userMessage = UserMessage.from((Content[])new Content[]{TextContent.from((String)"What do you see?"), ImageContent.from((String)this.catImageUrl())});
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        Assertions.assertThat((String)aiMessage.text().toLowerCase()).containsAnyOf(new CharSequence[]{"cat", "lynx", "feline", "animal"});
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingImageInputs"})
    @EnabledIf(value="supportsMultipleImageInputsAsPublicURLs")
    protected void should_accept_multiple_images_as_public_URLs(M model) {
        UserMessage userMessage = UserMessage.from((Content[])new Content[]{TextContent.from((String)"What do you see on these images? Describe both images."), ImageContent.from((String)this.catImageUrl()), ImageContent.from((String)this.diceImageUrl())});
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).build();
        ChatResponse chatResponse = this.chat(model, chatRequest).chatResponse();
        AiMessage aiMessage = chatResponse.aiMessage();
        ((AbstractStringAssert)Assertions.assertThat((String)aiMessage.text().toLowerCase()).containsAnyOf(new CharSequence[]{"cat", "lynx", "feline", "animal"})).contains(new CharSequence[]{"dice"});
        Assertions.assertThat((List)aiMessage.toolExecutionRequests()).isEmpty();
        if (this.assertTokenUsage()) {
            this.assertTokenUsage(chatResponse.metadata(), model);
        }
        if (this.assertFinishReason()) {
            Assertions.assertThat((Comparable)chatResponse.metadata().finishReason()).isEqualTo((Object)FinishReason.STOP);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"modelsSupportingImageInputs"})
    @DisabledIf(value="supportsSingleImageInputAsPublicURL")
    protected void should_fail_if_images_as_public_URLs_are_not_supported(M model) {
        UserMessage userMessage = UserMessage.from((Content[])new Content[]{TextContent.from((String)"What do you see?"), ImageContent.from((String)this.catImageUrl())});
        ChatRequest chatRequest = ChatRequest.builder().messages(new ChatMessage[]{userMessage}).build();
        AbstractThrowableAssert throwableAssert = Assertions.assertThatThrownBy(() -> this.chat(model, chatRequest));
        if (this.assertExceptionType()) {
            ((AbstractThrowableAssert)throwableAssert.isExactlyInstanceOf(UnsupportedFeatureException.class)).hasMessageContaining("image").hasMessageContaining("not support");
        }
    }

    protected boolean supportsDefaultRequestParameters() {
        return true;
    }

    protected boolean supportsModelNameParameter() {
        return true;
    }

    protected boolean supportsMaxOutputTokensParameter() {
        return true;
    }

    protected boolean supportsStopSequencesParameter() {
        return true;
    }

    protected boolean supportsTools() {
        return true;
    }

    protected boolean supportsPartialToolStreaming(StreamingChatModel model) {
        return true;
    }

    protected boolean supportsToolChoiceRequired() {
        return true;
    }

    protected boolean supportsToolChoiceRequiredWithSingleTool() {
        return this.supportsToolChoiceRequired();
    }

    protected boolean supportsToolChoiceRequiredWithMultipleTools() {
        return this.supportsToolChoiceRequired();
    }

    protected boolean supportsJsonResponseFormat() {
        return true;
    }

    protected boolean supportsJsonResponseFormatWithSchema() {
        return true;
    }

    protected boolean supportsToolsAndJsonResponseFormatWithSchema() {
        return this.supportsTools() && this.supportsJsonResponseFormatWithSchema();
    }

    protected boolean supportsJsonResponseFormatWithRawSchema() {
        return true;
    }

    protected boolean supportsSingleImageInputAsBase64EncodedString() {
        return true;
    }

    protected boolean supportsMultipleImageInputsAsBase64EncodedStrings() {
        return this.supportsSingleImageInputAsBase64EncodedString();
    }

    protected boolean supportsSingleImageInputAsPublicURL() {
        return true;
    }

    protected boolean supportsMultipleImageInputsAsPublicURLs() {
        return this.supportsSingleImageInputAsPublicURL();
    }

    protected boolean assertChatResponseMetadataType() {
        return true;
    }

    protected Class<? extends ChatResponseMetadata> chatResponseMetadataType(M model) {
        return ChatResponseMetadata.class;
    }

    protected boolean assertResponseId() {
        return true;
    }

    protected boolean assertResponseModel() {
        return true;
    }

    protected boolean assertFinishReason() {
        return true;
    }

    protected boolean assertToolId(M model) {
        return true;
    }

    protected boolean assertThreads() {
        return true;
    }

    protected boolean assertExceptionType() {
        return true;
    }

    protected boolean assertTimesOnPartialResponseWasCalled() {
        return true;
    }

    protected boolean assertTokenUsage() {
        return true;
    }

    void assertTokenUsage(ChatResponseMetadata chatResponseMetadata, M model) {
        this.assertTokenUsage(chatResponseMetadata, null, model);
    }

    void assertTokenUsage(ChatResponseMetadata chatResponseMetadata, Integer maxOutputTokens, M model) {
        TokenUsage tokenUsage = chatResponseMetadata.tokenUsage();
        Assertions.assertThat((Object)tokenUsage).isExactlyInstanceOf(this.tokenUsageType(model));
        Assertions.assertThat((Integer)tokenUsage.inputTokenCount()).isPositive();
        if (maxOutputTokens != null) {
            Assertions.assertThat((Integer)tokenUsage.outputTokenCount()).isEqualTo((Object)maxOutputTokens);
        }
        Assertions.assertThat((Integer)tokenUsage.totalTokenCount()).isEqualTo(tokenUsage.inputTokenCount() + tokenUsage.outputTokenCount());
    }

    protected Class<? extends TokenUsage> tokenUsageType(M model) {
        return TokenUsage.class;
    }
}

