/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.audio;

import dev.langchain4j.data.audio.Audio;
import dev.langchain4j.model.audio.AudioTranscriptionModel;
import dev.langchain4j.model.audio.AudioTranscriptionRequest;
import dev.langchain4j.model.audio.AudioTranscriptionResponse;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class AudioTranscriptionModelTest {
    AudioTranscriptionModelTest() {
    }

    @Test
    void should_transcribe_to_text_using_default_method() {
        String expectedText = "This is the transcribed text";
        TestAudioTranscriptionModel model = new TestAudioTranscriptionModel(expectedText);
        Audio audio = Audio.builder().binaryData("test audio".getBytes()).mimeType("audio/wav").build();
        String result = model.transcribeToText(audio);
        Assertions.assertThat((String)result).isEqualTo(expectedText);
    }

    @Test
    void should_handle_null_response_text_in_default_method() {
        TestAudioTranscriptionModel model = new TestAudioTranscriptionModel(null);
        Audio audio = Audio.builder().binaryData("test audio".getBytes()).mimeType("audio/wav").build();
        String result = model.transcribeToText(audio);
        Assertions.assertThat((String)result).isNull();
    }

    @Test
    void should_handle_empty_response_text_in_default_method() {
        TestAudioTranscriptionModel model = new TestAudioTranscriptionModel("");
        Audio audio = Audio.builder().binaryData("test audio".getBytes()).mimeType("audio/wav").build();
        String result = model.transcribeToText(audio);
        Assertions.assertThat((String)result).isEqualTo("");
    }

    @Test
    void should_handle_different_audio_types_in_default_method() {
        String expectedText = "Transcribed audio";
        TestAudioTranscriptionModel model = new TestAudioTranscriptionModel(expectedText);
        Audio binaryAudio = Audio.builder().binaryData("binary audio data".getBytes()).mimeType("audio/wav").build();
        Audio base64Audio = Audio.builder().base64Data("dGVzdCBhdWRpbw==").mimeType("audio/mp3").build();
        Audio urlAudio = Audio.builder().url("https://example.com/audio.wav").mimeType("audio/wav").build();
        String result1 = model.transcribeToText(binaryAudio);
        String result2 = model.transcribeToText(base64Audio);
        String result3 = model.transcribeToText(urlAudio);
        Assertions.assertThat((String)result1).isEqualTo(expectedText);
        Assertions.assertThat((String)result2).isEqualTo(expectedText);
        Assertions.assertThat((String)result3).isEqualTo(expectedText);
    }

    @Test
    void should_create_request_with_audio_in_default_method() {
        final String expectedText = "Test transcription";
        final Audio audio = Audio.builder().binaryData("test".getBytes()).mimeType("audio/wav").build();
        AudioTranscriptionModel model = new AudioTranscriptionModel(){
            final /* synthetic */ AudioTranscriptionModelTest this$0;
            {
                this.this$0 = this$0;
            }

            public AudioTranscriptionResponse transcribe(AudioTranscriptionRequest request) {
                Assertions.assertThat((Object)request.audio()).isEqualTo((Object)audio);
                Assertions.assertThat((String)request.prompt()).isNull();
                Assertions.assertThat((String)request.language()).isNull();
                Assertions.assertThat((Double)request.temperature()).isNull();
                return new AudioTranscriptionResponse(expectedText);
            }
        };
        String result = model.transcribeToText(audio);
        Assertions.assertThat((String)result).isEqualTo(expectedText);
    }

    @Test
    void should_handle_long_transcription_text() {
        StringBuilder longText = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            longText.append("This is sentence ").append(i).append(". ");
        }
        String expectedText = longText.toString();
        TestAudioTranscriptionModel model = new TestAudioTranscriptionModel(expectedText);
        Audio audio = Audio.builder().binaryData("long audio".getBytes()).mimeType("audio/wav").build();
        String result = model.transcribeToText(audio);
        Assertions.assertThat((String)result).isEqualTo(expectedText);
        Assertions.assertThat((int)result.length()).isGreaterThan(1000);
    }

    static class TestAudioTranscriptionModel
    implements AudioTranscriptionModel {
        private final String responseText;

        TestAudioTranscriptionModel(String responseText) {
            this.responseText = responseText;
        }

        public AudioTranscriptionResponse transcribe(AudioTranscriptionRequest request) {
            return new AudioTranscriptionResponse(this.responseText);
        }
    }
}

