/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.invocation;

import dev.langchain4j.invocation.InvocationParameters;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.jupiter.api.Test;

class InvocationParametersTest {
    InvocationParametersTest() {
    }

    @Test
    void test1() {
        InvocationParameters invocationParameters = new InvocationParameters();
        invocationParameters.put("key", (Object)"value");
        String value = (String)invocationParameters.get("key");
        Assertions.assertThat((Object)value).isEqualTo((Object)"value");
    }

    @Test
    void test2() {
        InvocationParameters invocationParameters = InvocationParameters.from((String)"key", (Object)"value");
        Assertions.assertThat((Map)invocationParameters.asMap()).containsOnly(new Map.Entry[]{Map.entry("key", "value")});
    }

    @Test
    void test3() {
        InvocationParameters invocationParameters = InvocationParameters.from(Map.of("key", "value"));
        Assertions.assertThat((Map)invocationParameters.asMap()).containsOnly(new Map.Entry[]{Map.entry("key", "value")});
    }

    @Test
    void test4() {
        HashMap<String, String> seedMap = new HashMap<String, String>();
        seedMap.put("key1", "value1");
        InvocationParameters invocationParameters = InvocationParameters.from(seedMap);
        Assertions.assertThat((Map)invocationParameters.asMap()).containsOnly(new Map.Entry[]{Map.entry("key1", "value1")});
        seedMap.put("key2", "value2");
        invocationParameters.put("key3", (Object)"value3");
        Assertions.assertThat(seedMap).containsOnlyKeys((Object[])new String[]{"key1", "key2"});
        Assertions.assertThat((Map)invocationParameters.asMap()).containsOnlyKeys((Object[])new String[]{"key1", "key3"});
    }

    @Test
    void testGetNonExistentKey() {
        InvocationParameters invocationParameters = new InvocationParameters();
        invocationParameters.put("existing", (Object)"value");
        Object result = invocationParameters.get("nonExistent");
        Assertions.assertThat((Object)result).isNull();
    }

    @Test
    void testOverwriteExistingValue() {
        InvocationParameters invocationParameters = new InvocationParameters();
        invocationParameters.put("key", (Object)"originalValue");
        invocationParameters.put("key", (Object)"newValue");
        String value = (String)invocationParameters.get("key");
        Assertions.assertThat((String)value).isEqualTo("newValue");
    }

    @Test
    void testMultiplePuts() {
        InvocationParameters invocationParameters = new InvocationParameters();
        invocationParameters.put("key1", (Object)"value1");
        invocationParameters.put("key2", (Object)"value2");
        invocationParameters.put("key3", (Object)"value3");
        Assertions.assertThat((Map)invocationParameters.asMap()).containsOnly(new Map.Entry[]{Map.entry("key1", "value1"), Map.entry("key2", "value2"), Map.entry("key3", "value3")});
    }

    @Test
    void testFromWithEmptyMap() {
        InvocationParameters invocationParameters = InvocationParameters.from(new HashMap());
        Assertions.assertThat((Map)invocationParameters.asMap()).isEmpty();
    }

    @Test
    void testFromWithMultipleEntries() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key1", "value1");
        map.put("key2", 1);
        map.put("key3", true);
        InvocationParameters invocationParameters = InvocationParameters.from(map);
        Assertions.assertThat((Map)invocationParameters.asMap()).containsOnly(new Map.Entry[]{Map.entry("key1", "value1"), Map.entry("key2", 1), Map.entry("key3", true)});
    }

    @Test
    void testComplexObjectAsValue() {
        InvocationParameters invocationParameters = new InvocationParameters();
        Map<String, String> complexObject = Map.of("nested", "value");
        invocationParameters.put("complex", complexObject);
        Map retrieved = (Map)invocationParameters.get("complex");
        Assertions.assertThat((Map)retrieved).isEqualTo(complexObject);
    }

    @Test
    void testFromKeyValueWithNullValue() {
        AssertionsForClassTypes.assertThatThrownBy(() -> InvocationParameters.from((String)"key", null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testPutNullValue() {
        InvocationParameters invocationParameters = new InvocationParameters();
        AssertionsForClassTypes.assertThatThrownBy(() -> invocationParameters.put("nullKey", null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testFromWithNullMap() {
        AssertionsForClassTypes.assertThatThrownBy(() -> InvocationParameters.from((Map)null)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void testPutNullKey() {
        InvocationParameters invocationParameters = new InvocationParameters();
        AssertionsForClassTypes.assertThatThrownBy(() -> invocationParameters.put(null, (Object)"value")).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testFromKeyValueWithNullKey() {
        AssertionsForClassTypes.assertThatThrownBy(() -> InvocationParameters.from(null, (Object)"value")).isInstanceOf(NullPointerException.class);
    }

    @Test
    void testGetWithNullKey() {
        InvocationParameters invocationParameters = new InvocationParameters();
        invocationParameters.put("key", (Object)"value");
        AssertionsForClassTypes.assertThatThrownBy(() -> invocationParameters.get(null)).isInstanceOf(NullPointerException.class);
    }
}

