/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.segment;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.data.segment.TextSegment;
import dev.langchain4j.data.segment.TextSegmentTransformer;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class TextSegmentTransformerTest
implements WithAssertions {
    TextSegmentTransformerTest() {
    }

    @Test
    void transform_all() {
        LowercaseFnordTransformer transformer = new LowercaseFnordTransformer();
        TextSegment ts1 = TextSegment.from((String)"Text");
        ts1.metadata().put("abc", "123");
        TextSegment ts2 = TextSegment.from((String)"Segment");
        TextSegment ts3 = TextSegment.from((String)"Fnord will be filtered out");
        TextSegment ts4 = TextSegment.from((String)"Transformer");
        ArrayList<TextSegment> segmentList = new ArrayList<TextSegment>();
        segmentList.add(ts1);
        segmentList.add(ts2);
        segmentList.add(ts3);
        segmentList.add(ts4);
        this.assertThat(transformer.transformAll(segmentList)).containsExactly((Object[])new TextSegment[]{TextSegment.from((String)"text", (Metadata)ts1.metadata()), TextSegment.from((String)"segment"), TextSegment.from((String)"transformer")});
    }

    @Test
    void transform_all_varargs() {
        LowercaseFnordTransformer transformer = new LowercaseFnordTransformer();
        TextSegment ts1 = TextSegment.from((String)"Text");
        ts1.metadata().put("abc", "123");
        TextSegment ts2 = TextSegment.from((String)"Segment");
        TextSegment ts3 = TextSegment.from((String)"Fnord will be filtered out");
        TextSegment ts4 = TextSegment.from((String)"Transformer");
        List result = transformer.transformAll(new TextSegment[]{ts1, ts2, ts3, ts4});
        this.assertThat(result).containsExactly((Object[])new TextSegment[]{TextSegment.from((String)"text", (Metadata)ts1.metadata()), TextSegment.from((String)"segment"), TextSegment.from((String)"transformer")});
    }

    @Test
    void transform_all_varargs_empty_input_returns_empty_list() {
        LowercaseFnordTransformer transformer = new LowercaseFnordTransformer();
        List result = transformer.transformAll(new TextSegment[0]);
        ((ListAssert)this.assertThat(result).isNotNull()).isEmpty();
    }

    @Test
    void transform_all_varargs_null_input_returns_empty_list() {
        LowercaseFnordTransformer transformer = new LowercaseFnordTransformer();
        List result = transformer.transformAll(null);
        ((ListAssert)this.assertThat(result).isNotNull()).isEmpty();
    }

    public static class LowercaseFnordTransformer
    implements TextSegmentTransformer {
        public TextSegment transform(TextSegment segment) {
            String result = segment.text().toLowerCase();
            if (result.contains("fnord")) {
                return null;
            }
            return TextSegment.from((String)result, (Metadata)segment.metadata());
        }
    }
}

