/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessageType;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.UserMessage;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.OptionalAssert;
import org.assertj.core.api.WithAssertions;
import org.junit.jupiter.api.Test;

class SystemMessageTest
implements WithAssertions {
    SystemMessageTest() {
    }

    @Test
    void builders() {
        ((ObjectAssert)this.assertThat(new SystemMessage("text")).isEqualTo((Object)SystemMessage.from((String)"text"))).isEqualTo((Object)SystemMessage.systemMessage((String)"text"));
    }

    @Test
    void methods() {
        SystemMessage message = new SystemMessage("text");
        this.assertThat(message.text()).isEqualTo("text");
        this.assertThat((Comparable)message.type()).isEqualTo((Object)ChatMessageType.SYSTEM);
        this.assertThat(message).hasToString("SystemMessage { text = \"text\" }");
    }

    @Test
    void equals_hash_code() {
        SystemMessage s1 = new SystemMessage("text");
        SystemMessage s2 = new SystemMessage("text");
        SystemMessage s3 = new SystemMessage("text2");
        SystemMessage s4 = new SystemMessage("text2");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)this.assertThat(s1).isEqualTo((Object)s1)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)s2)).hasSameHashCodeAs((Object)s2)).isNotEqualTo((Object)s3)).doesNotHaveSameHashCodeAs((Object)s3);
        ((ObjectAssert)((ObjectAssert)this.assertThat(s3).isEqualTo((Object)s3)).isEqualTo((Object)s4)).hasSameHashCodeAs((Object)s4);
    }

    @Test
    void find_with_null_list() {
        this.assertThatThrownBy(() -> SystemMessage.findFirst(null)).isInstanceOf(NullPointerException.class);
        this.assertThatThrownBy(() -> SystemMessage.findLast(null)).isInstanceOf(NullPointerException.class);
        this.assertThatThrownBy(() -> SystemMessage.findAll(null)).isInstanceOf(NullPointerException.class);
    }

    @Test
    void find_with_empty_list() {
        List emptyList = Collections.emptyList();
        this.assertThat(SystemMessage.findFirst(emptyList)).isEmpty();
        this.assertThat(SystemMessage.findLast(emptyList)).isEmpty();
        this.assertThat(SystemMessage.findAll(emptyList)).isEmpty();
    }

    @Test
    void find_with_single_system_message() {
        SystemMessage systemMessage = new SystemMessage("system text");
        List<SystemMessage> messages = List.of(systemMessage);
        ((OptionalAssert)this.assertThat(SystemMessage.findFirst(messages)).isPresent()).contains((Object)systemMessage);
        ((OptionalAssert)this.assertThat(SystemMessage.findLast(messages)).isPresent()).contains((Object)systemMessage);
        ((ListAssert)this.assertThat(SystemMessage.findAll(messages)).hasSize(1)).containsExactly((Object[])new SystemMessage[]{systemMessage});
    }

    @Test
    void find_with_single_user_message() {
        UserMessage userMessage = new UserMessage("user text");
        List<UserMessage> messages = List.of(userMessage);
        this.assertThat(SystemMessage.findFirst(messages)).isEmpty();
        this.assertThat(SystemMessage.findLast(messages)).isEmpty();
        this.assertThat(SystemMessage.findAll(messages)).isEmpty();
    }

    @Test
    void find_with_mixed_messages() {
        SystemMessage system1 = new SystemMessage("system 1");
        UserMessage user1 = new UserMessage("user 1");
        AiMessage ai1 = new AiMessage("ai 1");
        SystemMessage system2 = new SystemMessage("system 2");
        UserMessage user2 = new UserMessage("user 2");
        AiMessage ai2 = new AiMessage("ai 2");
        SystemMessage system3 = new SystemMessage("system 3");
        List<SystemMessage> messages = List.of(user1, system1, ai1, system2, user2, ai2, system3);
        ((OptionalAssert)this.assertThat(SystemMessage.findFirst(messages)).isPresent()).contains((Object)system1);
        ((OptionalAssert)this.assertThat(SystemMessage.findLast(messages)).isPresent()).contains((Object)system3);
        ((ListAssert)this.assertThat(SystemMessage.findAll(messages)).hasSize(3)).containsExactly((Object[])new SystemMessage[]{system1, system2, system3});
    }
}

