/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.data.message;

import dev.langchain4j.data.audio.Audio;
import dev.langchain4j.data.message.AudioContent;
import dev.langchain4j.data.message.ContentType;
import java.net.URI;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

class AudioContentTest {
    AudioContentTest() {
    }

    @Test
    void methods() {
        Audio urlAudio = Audio.builder().url(URI.create("https://example.com/sound.mp3")).build();
        AudioContent audioContent = new AudioContent(urlAudio);
        Assertions.assertThat((Object)audioContent.audio()).isEqualTo((Object)urlAudio);
        Assertions.assertThat((Comparable)audioContent.type()).isEqualTo((Object)ContentType.AUDIO);
        Assertions.assertThat((Object)audioContent).hasToString("AudioContent { audio = Audio { url = \"https://example.com/sound.mp3\", base64Data = null, mimeType = null } }");
    }

    @Test
    void equals_hash_code() {
        AudioContent a1 = AudioContent.from((String)"https://example.com/sound.mp3");
        AudioContent a2 = AudioContent.from((String)"https://example.com/sound.mp3");
        AudioContent a3 = AudioContent.from((String)"https://example.com/sound.wav");
        AudioContent a4 = AudioContent.from((String)"https://example.com/sound.wav");
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)a1).isEqualTo((Object)a1)).isNotEqualTo(null)).isNotEqualTo(new Object())).isEqualTo((Object)a2)).hasSameHashCodeAs((Object)a2)).isNotEqualTo((Object)a3)).isNotEqualTo((Object)a4);
        ((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)a3).isEqualTo((Object)a3)).isEqualTo((Object)a4)).hasSameHashCodeAs((Object)a4);
    }

    @Test
    void builders() {
        Audio urlAudio = Audio.builder().url(URI.create("https://example.com/sound.mp3")).build();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)new AudioContent(urlAudio)).isEqualTo((Object)new AudioContent(urlAudio))).isEqualTo((Object)AudioContent.from((Audio)urlAudio))).isEqualTo((Object)AudioContent.from((Audio)urlAudio))).isEqualTo((Object)new AudioContent(urlAudio.url()))).isEqualTo((Object)new AudioContent(urlAudio.url().toString()))).isEqualTo((Object)AudioContent.from((URI)urlAudio.url()))).isEqualTo((Object)AudioContent.from((String)urlAudio.url().toString()));
        Audio base64Audio = Audio.builder().base64Data("YXVkaW8=").mimeType("mimeType").build();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)Assertions.assertThat((Object)new AudioContent(base64Audio)).isEqualTo((Object)new AudioContent(base64Audio))).isEqualTo((Object)AudioContent.from((Audio)base64Audio))).isEqualTo((Object)new AudioContent(base64Audio.base64Data(), base64Audio.mimeType()))).isEqualTo((Object)AudioContent.from((String)base64Audio.base64Data(), (String)base64Audio.mimeType()));
    }
}

