/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j;

import dev.langchain4j.JsonTestUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class JsonTestUtilsTest {
    JsonTestUtilsTest() {
    }

    @Test
    void should_jsonify() {
        Assertions.assertThat((String)JsonTestUtils.jsonify("")).isEqualTo("\"\"");
        Assertions.assertThat((String)JsonTestUtils.jsonify("a")).isEqualTo("\"a\"");
        Assertions.assertThat((String)JsonTestUtils.jsonify("a b")).isEqualTo("\"a b\"");
        Assertions.assertThat((String)JsonTestUtils.jsonify("a\nb")).isEqualTo("\"a\\nb\"");
    }

    @Test
    void should_jsonify_null() {
        Assertions.assertThat((String)JsonTestUtils.jsonify(null)).isEqualTo("null");
    }

    @Test
    void should_jsonify_special_characters() {
        Assertions.assertThat((String)JsonTestUtils.jsonify("a\"b")).isEqualTo("\"a\\\"b\"");
        Assertions.assertThat((String)JsonTestUtils.jsonify("a\\b")).isEqualTo("\"a\\\\b\"");
        Assertions.assertThat((String)JsonTestUtils.jsonify("a\tb")).isEqualTo("\"a\\tb\"");
        Assertions.assertThat((String)JsonTestUtils.jsonify("a\rb")).isEqualTo("\"a\\rb\"");
    }

    @Test
    void should_jsonify_empty_vs_whitespace() {
        Assertions.assertThat((String)JsonTestUtils.jsonify("")).isEqualTo("\"\"");
        Assertions.assertThat((String)JsonTestUtils.jsonify(" ")).isEqualTo("\" \"");
    }
}

