/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.code.judge0;

import dev.langchain4j.agent.tool.P;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.code.judge0.JavaScriptCodeFixer;
import dev.langchain4j.code.judge0.Judge0JavaScriptEngine;
import dev.langchain4j.internal.Utils;
import java.time.Duration;
import java.util.Objects;

public class Judge0JavaScriptExecutionTool {
    public static final int JAVASCRIPT = 102;
    private static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(10L);
    private final Judge0JavaScriptEngine engine;
    private final boolean fixCodeIfNeeded;

    public Judge0JavaScriptExecutionTool(String apiKey) {
        this(apiKey, true, DEFAULT_TIMEOUT);
    }

    public Judge0JavaScriptExecutionTool(String apiKey, Duration timeout) {
        this(apiKey, true, timeout);
    }

    public Judge0JavaScriptExecutionTool(String apiKey, boolean fixCodeIfNeeded) {
        this(apiKey, fixCodeIfNeeded, DEFAULT_TIMEOUT);
    }

    public Judge0JavaScriptExecutionTool(String apiKey, boolean fixCodeIfNeeded, Duration timeout) {
        if (Utils.isNullOrBlank((String)apiKey)) {
            throw new IllegalArgumentException("Please provide a valid Rapid API key");
        }
        Objects.requireNonNull(timeout, "Timeout must not be null");
        this.engine = new Judge0JavaScriptEngine(apiKey, 102, timeout);
        this.fixCodeIfNeeded = fixCodeIfNeeded;
    }

    @Tool(value={"MUST be used for accurate calculations: math, sorting, filtering, aggregating, string processing, etc"})
    public String executeJavaScriptCode(@P(value="JavaScript code to execute, result MUST be printed to console") String javaScriptCode) {
        if (Utils.isNullOrBlank((String)javaScriptCode)) {
            throw new IllegalArgumentException("JavaScript code must not be null or empty");
        }
        if (this.fixCodeIfNeeded) {
            javaScriptCode = JavaScriptCodeFixer.fixIfNoLogToConsole(javaScriptCode);
        }
        try {
            return this.engine.execute(javaScriptCode);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to execute JavaScript code: " + e.getMessage(), e);
        }
    }

    public boolean isCodeFixingEnabled() {
        return this.fixCodeIfNeeded;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String apiKey;
        private boolean fixCodeIfNeeded = true;
        private Duration timeout = DEFAULT_TIMEOUT;

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder fixCodeIfNeeded(boolean fixCodeIfNeeded) {
            this.fixCodeIfNeeded = fixCodeIfNeeded;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Judge0JavaScriptExecutionTool build() {
            return new Judge0JavaScriptExecutionTool(this.apiKey, this.fixCodeIfNeeded, this.timeout);
        }
    }
}

