/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.util;

import java.time.ZoneId;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.thingsboard.server.common.data.kv.IntervalType;
import org.thingsboard.server.dao.util.TimeUtils;

class TimeUtilsTest {
    TimeUtilsTest() {
    }

    @Test
    void testWeekEnd() {
        long ts = 1704899727000L;
        Assertions.assertThat((long)TimeUtils.calculateIntervalEnd((long)ts, (IntervalType)IntervalType.WEEK, (ZoneId)ZoneId.of("Europe/Kyiv"))).isEqualTo(1705183200000L);
        Assertions.assertThat((long)TimeUtils.calculateIntervalEnd((long)ts, (IntervalType)IntervalType.WEEK_ISO, (ZoneId)ZoneId.of("Europe/Kyiv"))).isEqualTo(1705269600000L);
        Assertions.assertThat((long)TimeUtils.calculateIntervalEnd((long)ts, (IntervalType)IntervalType.WEEK, (ZoneId)ZoneId.of("Europe/Amsterdam"))).isEqualTo(1705186800000L);
        Assertions.assertThat((long)TimeUtils.calculateIntervalEnd((long)ts, (IntervalType)IntervalType.WEEK_ISO, (ZoneId)ZoneId.of("Europe/Amsterdam"))).isEqualTo(1705273200000L);
        ts = 1704621600000L;
        Assertions.assertThat((long)TimeUtils.calculateIntervalEnd((long)ts, (IntervalType)IntervalType.WEEK, (ZoneId)ZoneId.of("Europe/Kyiv"))).isEqualTo(1705183200000L);
        Assertions.assertThat((long)TimeUtils.calculateIntervalEnd((long)ts, (IntervalType)IntervalType.WEEK_ISO, (ZoneId)ZoneId.of("Europe/Kyiv"))).isEqualTo(1704664800000L);
    }

    @Test
    void testMonthEnd() {
        long ts = 1704899727000L;
        Assertions.assertThat((long)TimeUtils.calculateIntervalEnd((long)ts, (IntervalType)IntervalType.MONTH, (ZoneId)ZoneId.of("Europe/Kyiv"))).isEqualTo(1706738400000L);
        Assertions.assertThat((long)TimeUtils.calculateIntervalEnd((long)ts, (IntervalType)IntervalType.MONTH, (ZoneId)ZoneId.of("Europe/Amsterdam"))).isEqualTo(1706742000000L);
    }

    @Test
    void testQuarterEnd() {
        long ts = 1704899727000L;
        Assertions.assertThat((long)TimeUtils.calculateIntervalEnd((long)ts, (IntervalType)IntervalType.QUARTER, (ZoneId)ZoneId.of("Europe/Kyiv"))).isEqualTo(1711918800000L);
        Assertions.assertThat((long)TimeUtils.calculateIntervalEnd((long)ts, (IntervalType)IntervalType.QUARTER, (ZoneId)ZoneId.of("Europe/Amsterdam"))).isEqualTo(1711922400000L);
        ts = 1711929600000L;
        Assertions.assertThat((long)TimeUtils.calculateIntervalEnd((long)ts, (IntervalType)IntervalType.QUARTER, (ZoneId)ZoneId.of("Europe/Kyiv"))).isEqualTo(1719781200000L);
        Assertions.assertThat((long)TimeUtils.calculateIntervalEnd((long)ts, (IntervalType)IntervalType.QUARTER, (ZoneId)ZoneId.of("America/New_York"))).isEqualTo(1711944000000L);
    }
}

