/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.timeseries;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.thingsboard.server.dao.timeseries.NoSqlTsPartitionDate;

class NoSqlTsPartitionDateTest {
    NoSqlTsPartitionDateTest() {
    }

    @ParameterizedTest
    @EnumSource(value=NoSqlTsPartitionDate.class)
    void getDurationMsTest(NoSqlTsPartitionDate tsPartitionDate) throws Exception {
        Long durationMs = switch (tsPartitionDate) {
            case NoSqlTsPartitionDate.MINUTES -> 60000L;
            case NoSqlTsPartitionDate.HOURS -> 3600000L;
            case NoSqlTsPartitionDate.DAYS -> 86400000L;
            case NoSqlTsPartitionDate.MONTHS -> 2629746000L;
            case NoSqlTsPartitionDate.YEARS -> 31556952000L;
            case NoSqlTsPartitionDate.INDEFINITE -> Long.MAX_VALUE;
            default -> null;
        };
        Assertions.assertThat((Long)durationMs).isNotNull();
        Assertions.assertThat((long)tsPartitionDate.getDurationMs()).isEqualTo((Object)durationMs);
    }
}

