/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.timeseries;

import java.text.ParseException;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;
import org.thingsboard.server.dao.cassandra.CassandraCluster;
import org.thingsboard.server.dao.nosql.CassandraBufferedRateReadExecutor;
import org.thingsboard.server.dao.nosql.CassandraBufferedRateWriteExecutor;
import org.thingsboard.server.dao.timeseries.CassandraBaseTimeseriesDao;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={CassandraBaseTimeseriesDao.class})
@TestPropertySource(properties={"database.ts.type=cassandra", "cassandra.query.ts_key_value_partitioning=YEARS", "cassandra.query.use_ts_key_value_partitioning_on_read=false", "cassandra.query.ts_key_value_partitions_max_cache_size=100000", "cassandra.query.ts_key_value_partitions_cache_stats_enabled=true", "cassandra.query.ts_key_value_partitions_cache_stats_interval=60", "cassandra.query.ts_key_value_ttl=0", "cassandra.query.set_null_values_enabled=false"})
public class CassandraBaseTimeseriesDaoPartitioningYearsAlwaysExistsTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CassandraBaseTimeseriesDaoPartitioningYearsAlwaysExistsTest.class);
    @Autowired
    CassandraBaseTimeseriesDao tsDao;
    @MockBean(answer=Answers.RETURNS_MOCKS)
    @Qualifier(value="CassandraCluster")
    CassandraCluster cassandraCluster;
    @MockBean
    CassandraBufferedRateReadExecutor cassandraBufferedRateReadExecutor;
    @MockBean
    CassandraBufferedRateWriteExecutor cassandraBufferedRateWriteExecutor;

    @Test
    public void testToPartitionsYears() throws ParseException {
        Assertions.assertThat((String)this.tsDao.getPartitioning()).isEqualTo("YEARS");
        Assertions.assertThat((long)this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-01-01T00:00:00Z").getTime())).isEqualTo(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-01-01T00:00:00Z").getTime());
        Assertions.assertThat((long)this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-05-01T00:00:00Z").getTime())).isEqualTo(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-01-01T00:00:00Z").getTime());
        Assertions.assertThat((long)this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-05-01T00:00:01Z").getTime())).isEqualTo(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-01-01T00:00:00Z").getTime());
        Assertions.assertThat((long)this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-05-31T23:59:59Z").getTime())).isEqualTo(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-01-01T00:00:00Z").getTime());
        Assertions.assertThat((long)this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2023-12-31T23:59:59Z").getTime())).isEqualTo(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2023-01-01T00:00:00Z").getTime());
    }

    @Test
    public void testCalculatePartitionsYears() throws ParseException {
        long startTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2019-01-01T00:00:00Z").getTime());
        long nextTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2021-10-12T23:59:59Z").getTime());
        long endTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2025-07-15T00:00:00Z").getTime());
        log.info("startTs {}, nextTs {}, endTs {}", new Object[]{startTs, nextTs, endTs});
        Assertions.assertThat((List)this.tsDao.calculatePartitions(0L, 0L)).isEqualTo(List.of(Long.valueOf(0L)));
        Assertions.assertThat((List)this.tsDao.calculatePartitions(0L, 1L)).isEqualTo(List.of(Long.valueOf(0L), Long.valueOf(1L)));
        Assertions.assertThat((List)this.tsDao.calculatePartitions(startTs, startTs)).isEqualTo(List.of(Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2019-01-01T00:00:00Z").getTime())));
        Assertions.assertThat((List)this.tsDao.calculatePartitions(startTs, nextTs)).isEqualTo(List.of(Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2019-01-01T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-01-01T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2021-01-01T00:00:00Z").getTime())));
        ((ListAssert)Assertions.assertThat((List)this.tsDao.calculatePartitions(startTs, endTs)).hasSize(7)).isEqualTo(List.of(Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2019-01-01T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-01-01T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2021-01-01T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-01-01T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2023-01-01T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2024-01-01T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2025-01-01T00:00:00Z").getTime())));
    }

    @Test
    public void testEstimatePartitionCount() throws ParseException {
        ((AbstractLongAssert)Assertions.assertThat((long)this.tsDao.estimatePartitionCount(0L, Long.MAX_VALUE)).as("centuries", new Object[0])).isEqualTo(292277026L);
        ((AbstractLongAssert)Assertions.assertThat((long)this.tsDao.estimatePartitionCount(0L, 0L)).as("single", new Object[0])).isEqualTo(1L);
        long startTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2019-12-12T00:00:00Z").getTime());
        long endTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2021-01-31T23:59:59Z").getTime());
        ((AbstractLongAssert)Assertions.assertThat((long)this.tsDao.estimatePartitionCount(startTs, endTs)).as("2 years + 2 spare periods", new Object[0])).isEqualTo(4L);
        ((AbstractLongAssert)Assertions.assertThat((long)this.tsDao.estimatePartitionCount(endTs, startTs)).as("wrong period estimated as 1", new Object[0])).isEqualTo(1L);
    }
}

