/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.timeseries;

import com.google.common.util.concurrent.ListenableFuture;
import java.text.ParseException;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.bean.override.mockito.MockitoSpyBean;
import org.springframework.test.context.junit4.SpringRunner;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.TsKvQuery;
import org.thingsboard.server.dao.cassandra.CassandraCluster;
import org.thingsboard.server.dao.nosql.CassandraBufferedRateReadExecutor;
import org.thingsboard.server.dao.nosql.CassandraBufferedRateWriteExecutor;
import org.thingsboard.server.dao.timeseries.CassandraBaseTimeseriesDao;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={CassandraBaseTimeseriesDao.class})
@TestPropertySource(properties={"database.ts.type=cassandra", "cassandra.query.ts_key_value_partitioning=MONTHS", "cassandra.query.use_ts_key_value_partitioning_on_read=false", "cassandra.query.ts_key_value_partitions_max_cache_size=100000", "cassandra.query.ts_key_value_partitions_cache_stats_enabled=true", "cassandra.query.ts_key_value_partitions_cache_stats_interval=60", "cassandra.query.ts_key_value_ttl=0", "cassandra.query.set_null_values_enabled=false"})
public class CassandraBaseTimeseriesDaoPartitioningMonthsAlwaysExistsTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CassandraBaseTimeseriesDaoPartitioningMonthsAlwaysExistsTest.class);
    @MockitoSpyBean
    CassandraBaseTimeseriesDao tsDao;
    @MockBean(answer=Answers.RETURNS_MOCKS)
    @Qualifier(value="CassandraCluster")
    CassandraCluster cassandraCluster;
    @MockBean
    CassandraBufferedRateReadExecutor cassandraBufferedRateReadExecutor;
    @MockBean
    CassandraBufferedRateWriteExecutor cassandraBufferedRateWriteExecutor;

    @Test
    public void testToPartitionsMonths() throws ParseException {
        Assertions.assertThat((String)this.tsDao.getPartitioning()).isEqualTo("MONTHS");
        Assertions.assertThat((long)this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-01-01T00:00:00Z").getTime())).isEqualTo(1640995200000L).isEqualTo(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-01-01T00:00:00Z").getTime());
        Assertions.assertThat((long)this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-05-01T00:00:00Z").getTime())).isEqualTo(1651363200000L).isEqualTo(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-05-01T00:00:00Z").getTime());
        Assertions.assertThat((long)this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-05-01T00:00:01Z").getTime())).isEqualTo(1651363200000L).isEqualTo(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-05-01T00:00:00Z").getTime());
        Assertions.assertThat((long)this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-05-31T23:59:59Z").getTime())).isEqualTo(1651363200000L).isEqualTo(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-05-01T00:00:00Z").getTime());
        Assertions.assertThat((long)this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2023-12-31T23:59:59Z").getTime())).isEqualTo(1701388800000L).isEqualTo(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2023-12-01T00:00:00Z").getTime());
    }

    @Test
    public void testCalculatePartitionsMonths() throws ParseException {
        long startTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2019-12-12T00:00:00Z").getTime());
        long nextTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-01-31T23:59:59Z").getTime());
        long leapTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-02-29T23:59:59Z").getTime());
        long endTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2021-01-31T23:59:59Z").getTime());
        log.info("startTs {}, nextTs {}, leapTs {}, endTs {}", new Object[]{startTs, nextTs, leapTs, endTs});
        Assertions.assertThat((List)this.tsDao.calculatePartitions(0L, 0L)).isEqualTo(List.of(Long.valueOf(0L)));
        Assertions.assertThat((List)this.tsDao.calculatePartitions(0L, 1L)).isEqualTo(List.of(Long.valueOf(0L), Long.valueOf(1L)));
        Assertions.assertThat((List)this.tsDao.calculatePartitions(startTs, startTs)).isEqualTo(List.of(Long.valueOf(1575158400000L))).isEqualTo(List.of(Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2019-12-01T00:00:00Z").getTime())));
        Assertions.assertThat((List)this.tsDao.calculatePartitions(startTs, nextTs)).isEqualTo(List.of(Long.valueOf(1575158400000L), Long.valueOf(1577836800000L))).isEqualTo(List.of(Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2019-12-01T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-01-01T00:00:00Z").getTime())));
        Assertions.assertThat((List)this.tsDao.calculatePartitions(startTs, leapTs)).isEqualTo(List.of(Long.valueOf(1575158400000L), Long.valueOf(1577836800000L), Long.valueOf(1580515200000L))).isEqualTo(List.of(Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2019-12-01T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-01-01T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-02-01T00:00:00Z").getTime())));
        ((ListAssert)Assertions.assertThat((List)this.tsDao.calculatePartitions(startTs, endTs)).hasSize(14)).isEqualTo(List.of(1575158400000L, 1577836800000L, 1580515200000L, 1583020800000L, 1585699200000L, 1588291200000L, 1590969600000L, 1593561600000L, 1596240000000L, 1598918400000L, 1601510400000L, 1604188800000L, 1606780800000L, 1609459200000L)).isEqualTo(List.of(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2019-12-01T00:00:00Z").getTime(), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-01-01T00:00:00Z").getTime(), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-02-01T00:00:00Z").getTime(), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-03-01T00:00:00Z").getTime(), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-04-01T00:00:00Z").getTime(), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-05-01T00:00:00Z").getTime(), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-06-01T00:00:00Z").getTime(), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-07-01T00:00:00Z").getTime(), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-08-01T00:00:00Z").getTime(), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-09-01T00:00:00Z").getTime(), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-10-01T00:00:00Z").getTime(), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-11-01T00:00:00Z").getTime(), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-12-01T00:00:00Z").getTime(), DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2021-01-01T00:00:00Z").getTime()));
    }

    @Test
    public void testEstimatePartitionCount() throws ParseException {
        ((AbstractLongAssert)Assertions.assertThat((long)this.tsDao.estimatePartitionCount(0L, Long.MAX_VALUE)).as("centuries", new Object[0])).isEqualTo(3507324297L);
        ((AbstractLongAssert)Assertions.assertThat((long)this.tsDao.estimatePartitionCount(0L, 0L)).as("single", new Object[0])).isEqualTo(1L);
        long startTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2019-12-12T00:00:00Z").getTime());
        long endTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2021-01-31T23:59:59Z").getTime());
        ((AbstractLongAssert)Assertions.assertThat((long)this.tsDao.estimatePartitionCount(startTs, endTs)).as("13 month + 2 spare periods", new Object[0])).isEqualTo(15L);
        ((AbstractLongAssert)Assertions.assertThat((long)this.tsDao.estimatePartitionCount(endTs, startTs)).as("wrong period estimated as 1", new Object[0])).isEqualTo(1L);
    }

    @Test
    public void testGetPartitionsFutureModeratePartitionsCount() throws ParseException {
        TenantId tenantId = TenantId.fromUUID((UUID)UUID.randomUUID());
        TsKvQuery query = (TsKvQuery)Mockito.mock(TsKvQuery.class);
        long startTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2019-12-12T00:00:00Z").getTime());
        long endTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2021-01-31T23:59:59Z").getTime());
        ((CassandraBaseTimeseriesDao)BDDMockito.willReturn((Object)Mockito.mock(ListenableFuture.class)).given((Object)this.tsDao)).getPartitionsFromDB(tenantId, query, (EntityId)tenantId, startTs, endTs);
        this.tsDao.getPartitionsFuture(tenantId, query, (EntityId)tenantId, startTs, endTs);
        ((CassandraBaseTimeseriesDao)Mockito.verify((Object)this.tsDao)).estimatePartitionCount(startTs, endTs);
        ((CassandraBaseTimeseriesDao)Mockito.verify((Object)this.tsDao)).calculatePartitions(ArgumentMatchers.eq((long)startTs), ArgumentMatchers.eq((long)endTs), ArgumentMatchers.anyInt());
        ((CassandraBaseTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.never())).getPartitionsFromDB(tenantId, query, (EntityId)tenantId, startTs, endTs);
    }

    @Test
    public void testGetPartitionsFutureHugePartitionsCountPreventOOMFallbackToDB() throws ParseException {
        TenantId tenantId = TenantId.fromUUID((UUID)UUID.randomUUID());
        TsKvQuery query = (TsKvQuery)Mockito.mock(TsKvQuery.class);
        long startTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2000-12-12T00:00:00Z").getTime());
        long endTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("3000-01-31T23:59:59Z").getTime());
        ((CassandraBaseTimeseriesDao)BDDMockito.willReturn((Object)Mockito.mock(ListenableFuture.class)).given((Object)this.tsDao)).getPartitionsFromDB(tenantId, query, (EntityId)tenantId, startTs, endTs);
        this.tsDao.getPartitionsFuture(tenantId, query, (EntityId)tenantId, startTs, endTs);
        ((CassandraBaseTimeseriesDao)Mockito.verify((Object)this.tsDao)).estimatePartitionCount(startTs, endTs);
        ((CassandraBaseTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.never())).calculatePartitions(ArgumentMatchers.eq((long)startTs), ArgumentMatchers.eq((long)endTs), ArgumentMatchers.anyInt());
        ((CassandraBaseTimeseriesDao)Mockito.verify((Object)this.tsDao)).getPartitionsFromDB(tenantId, query, (EntityId)tenantId, startTs, endTs);
    }
}

