/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.timeseries;

import java.text.ParseException;
import lombok.Generated;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;
import org.thingsboard.server.dao.cassandra.CassandraCluster;
import org.thingsboard.server.dao.nosql.CassandraBufferedRateReadExecutor;
import org.thingsboard.server.dao.nosql.CassandraBufferedRateWriteExecutor;
import org.thingsboard.server.dao.timeseries.CassandraBaseTimeseriesDao;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={CassandraBaseTimeseriesDao.class})
@TestPropertySource(properties={"database.ts.type=cassandra", "cassandra.query.ts_key_value_partitioning=INDEFINITE", "cassandra.query.use_ts_key_value_partitioning_on_read=false", "cassandra.query.ts_key_value_partitions_max_cache_size=100000", "cassandra.query.ts_key_value_partitions_cache_stats_enabled=true", "cassandra.query.ts_key_value_partitions_cache_stats_interval=60", "cassandra.query.ts_key_value_ttl=0", "cassandra.query.set_null_values_enabled=false"})
public class CassandraBaseTimeseriesDaoPartitioningIndefiniteAlwaysExistsTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CassandraBaseTimeseriesDaoPartitioningIndefiniteAlwaysExistsTest.class);
    @Autowired
    CassandraBaseTimeseriesDao tsDao;
    @MockBean(answer=Answers.RETURNS_MOCKS)
    @Qualifier(value="CassandraCluster")
    CassandraCluster cassandraCluster;
    @MockBean
    CassandraBufferedRateReadExecutor cassandraBufferedRateReadExecutor;
    @MockBean
    CassandraBufferedRateWriteExecutor cassandraBufferedRateWriteExecutor;

    @Test
    public void testToPartitionsIndefinite() throws ParseException {
        Assertions.assertThat((String)this.tsDao.getPartitioning()).isEqualTo("INDEFINITE");
        Assertions.assertThat((long)this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-01-01T00:00:00Z").getTime())).isEqualTo(0L);
    }

    @Test
    public void testCalculatePartitionsIndefinite() throws ParseException {
    }
}

