/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.timeseries;

import java.text.ParseException;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;
import org.thingsboard.server.dao.cassandra.CassandraCluster;
import org.thingsboard.server.dao.nosql.CassandraBufferedRateReadExecutor;
import org.thingsboard.server.dao.nosql.CassandraBufferedRateWriteExecutor;
import org.thingsboard.server.dao.timeseries.CassandraBaseTimeseriesDao;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={CassandraBaseTimeseriesDao.class})
@TestPropertySource(properties={"database.ts.type=cassandra", "cassandra.query.ts_key_value_partitioning=DAYS", "cassandra.query.use_ts_key_value_partitioning_on_read=false", "cassandra.query.ts_key_value_partitions_max_cache_size=100000", "cassandra.query.ts_key_value_partitions_cache_stats_enabled=true", "cassandra.query.ts_key_value_partitions_cache_stats_interval=60", "cassandra.query.ts_key_value_ttl=0", "cassandra.query.set_null_values_enabled=false"})
public class CassandraBaseTimeseriesDaoPartitioningDaysAlwaysExistsTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CassandraBaseTimeseriesDaoPartitioningDaysAlwaysExistsTest.class);
    @Autowired
    CassandraBaseTimeseriesDao tsDao;
    @MockBean(answer=Answers.RETURNS_MOCKS)
    @Qualifier(value="CassandraCluster")
    CassandraCluster cassandraCluster;
    @MockBean
    CassandraBufferedRateReadExecutor cassandraBufferedRateReadExecutor;
    @MockBean
    CassandraBufferedRateWriteExecutor cassandraBufferedRateWriteExecutor;

    @Test
    public void testToPartitionsDays() throws ParseException {
        Assertions.assertThat((String)this.tsDao.getPartitioning()).isEqualTo("DAYS");
        Assertions.assertThat((long)this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-01-01T00:00:00Z").getTime())).isEqualTo(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-01-01T00:00:00Z").getTime());
        Assertions.assertThat((long)this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-05-02T00:00:00Z").getTime())).isEqualTo(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-05-02T00:00:00Z").getTime());
        Assertions.assertThat((long)this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-05-03T00:00:01Z").getTime())).isEqualTo(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-05-03T00:00:00Z").getTime());
        Assertions.assertThat((long)this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-05-31T23:59:59Z").getTime())).isEqualTo(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-05-31T00:00:00Z").getTime());
        Assertions.assertThat((long)this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2023-12-31T23:59:59Z").getTime())).isEqualTo(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2023-12-31T00:00:00Z").getTime());
    }

    @Test
    public void testCalculatePartitionsDays() throws ParseException {
        long startTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-10-10T00:00:00Z").getTime());
        long nextTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-10-12T23:59:59Z").getTime());
        long endTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-10-15T00:00:00Z").getTime());
        log.info("startTs {}, nextTs {}, endTs {}", new Object[]{startTs, nextTs, endTs});
        Assertions.assertThat((List)this.tsDao.calculatePartitions(0L, 0L)).isEqualTo(List.of(Long.valueOf(0L)));
        Assertions.assertThat((List)this.tsDao.calculatePartitions(0L, 1L)).isEqualTo(List.of(Long.valueOf(0L), Long.valueOf(1L)));
        Assertions.assertThat((List)this.tsDao.calculatePartitions(startTs, startTs)).isEqualTo(List.of(Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-10-10T00:00:00Z").getTime())));
        Assertions.assertThat((List)this.tsDao.calculatePartitions(startTs, nextTs)).isEqualTo(List.of(Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-10-10T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-10-11T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-10-12T00:00:00Z").getTime())));
        ((ListAssert)Assertions.assertThat((List)this.tsDao.calculatePartitions(startTs, endTs)).hasSize(6)).isEqualTo(List.of(Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-10-10T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-10-11T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-10-12T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-10-13T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-10-14T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2022-10-15T00:00:00Z").getTime())));
        long leapStartTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-02-27T00:00:00Z").getTime());
        long leapEndTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-03-01T00:00:00Z").getTime());
        Assertions.assertThat((List)this.tsDao.calculatePartitions(leapStartTs, leapEndTs)).isEqualTo(List.of(Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-02-27T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-02-28T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-02-29T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-03-01T00:00:00Z").getTime())));
        long newYearStartTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-12-30T00:00:00Z").getTime());
        long newYearEndTs = this.tsDao.toPartitionTs(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2021-01-01T00:00:00Z").getTime());
        Assertions.assertThat((List)this.tsDao.calculatePartitions(newYearStartTs, newYearEndTs)).isEqualTo(List.of(Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-12-30T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2020-12-31T00:00:00Z").getTime()), Long.valueOf(DateFormatUtils.ISO_8601_EXTENDED_DATETIME_TIME_ZONE_FORMAT.parse("2021-01-01T00:00:00Z").getTime())));
    }
}

