/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sqlts.dictionary;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.dao.dictionary.KeyDictionaryDao;
import org.thingsboard.server.dao.model.sqlts.dictionary.KeyDictionaryCompositeKey;
import org.thingsboard.server.dao.model.sqlts.dictionary.KeyDictionaryEntry;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;
import org.thingsboard.server.dao.sqlts.dictionary.KeyDictionaryRepository;

@DaoSqlTest
public class KeyDictionaryDaoTest
extends AbstractServiceTest {
    @Autowired
    private KeyDictionaryDao keyDictionaryDao;
    @Autowired
    private KeyDictionaryRepository keyDictionaryRepository;
    private static final String KEY = "testKeyDictionaryDaoTestKey";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetOrSaveKeyId_concurrent() throws Exception {
        int i;
        int threads = 8;
        ExecutorService executor = Executors.newFixedThreadPool(threads);
        CountDownLatch allReady = new CountDownLatch(threads);
        CountDownLatch start = new CountDownLatch(1);
        CountDownLatch allDone = new CountDownLatch(threads);
        Integer[] keyIds = new Integer[threads];
        try {
            i = 0;
            while (i < threads) {
                int idx = i++;
                executor.submit(() -> {
                    allReady.countDown();
                    try {
                        Integer id;
                        start.await();
                        keyIds[idx] = id = this.keyDictionaryDao.getOrSaveKeyId(KEY);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    finally {
                        allDone.countDown();
                    }
                });
            }
            allReady.await(5L, TimeUnit.SECONDS);
            start.countDown();
            allDone.await(10L, TimeUnit.SECONDS);
        }
        finally {
            executor.shutdownNow();
        }
        for (i = 0; i < threads; ++i) {
            ((AbstractIntegerAssert)((AbstractIntegerAssert)Assertions.assertThat((Integer)keyIds[i]).as("keyId[%s]", new Object[]{i})).isNotNull()).isGreaterThan(0);
        }
        int first = keyIds[0];
        Assertions.assertThat((int)first).isGreaterThan(0);
        ((AbstractLongAssert)Assertions.assertThat((long)Arrays.stream(keyIds).distinct().count()).as("all threads should get the same keyId", new Object[0])).isEqualTo(1L);
        KeyDictionaryCompositeKey id = new KeyDictionaryCompositeKey(KEY);
        Optional entry = this.keyDictionaryRepository.findById((Object)id);
        Assertions.assertThat((boolean)entry.isPresent()).isTrue();
        Assertions.assertThat((Integer)((KeyDictionaryEntry)entry.get()).getKeyId()).isEqualTo(first);
        this.keyDictionaryRepository.deleteById((Object)id);
    }
}

