/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sqlts;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.kv.BasicTsKvEntry;
import org.thingsboard.server.common.data.kv.KvEntry;
import org.thingsboard.server.common.data.kv.StringDataEntry;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.DaoSqlTest;
import org.thingsboard.server.dao.timeseries.TimeseriesLatestDao;

@DaoSqlTest
public class SqlTimeseriesLatestDaoTest
extends AbstractServiceTest {
    @Autowired
    private TimeseriesLatestDao timeseriesLatestDao;

    @Test
    public void saveLatestTest() throws Exception {
        DeviceId deviceId = new DeviceId(UUID.randomUUID());
        TsKvEntry entry = this.createEntry("key", 1000L);
        Long version = (Long)this.timeseriesLatestDao.saveLatest(this.tenantId, (EntityId)deviceId, entry).get();
        Assertions.assertNotNull((Object)version);
        Assertions.assertTrue((version > 0L ? 1 : 0) != 0);
        TsKvEntry foundEntry = (TsKvEntry)this.timeseriesLatestDao.findLatest(this.tenantId, (EntityId)deviceId, "key").get();
        Assertions.assertNotNull((Object)foundEntry);
        this.equalsIgnoreVersion(entry, foundEntry);
        Assertions.assertEquals((Long)version, (Long)foundEntry.getVersion());
        TsKvEntry updatedEntry = this.createEntry("key", 2000L);
        Long updatedVersion = (Long)this.timeseriesLatestDao.saveLatest(this.tenantId, (EntityId)deviceId, updatedEntry).get();
        Assertions.assertNotNull((Object)updatedVersion);
        Assertions.assertTrue((updatedVersion > version ? 1 : 0) != 0);
        foundEntry = (TsKvEntry)this.timeseriesLatestDao.findLatest(this.tenantId, (EntityId)deviceId, "key").get();
        Assertions.assertNotNull((Object)foundEntry);
        this.equalsIgnoreVersion(updatedEntry, foundEntry);
        Assertions.assertEquals((Long)updatedVersion, (Long)foundEntry.getVersion());
        TsKvEntry oldEntry = this.createEntry("key", 1L);
        Long oldVersion = (Long)this.timeseriesLatestDao.saveLatest(this.tenantId, (EntityId)deviceId, oldEntry).get();
        Assertions.assertNull((Object)oldVersion);
        foundEntry = (TsKvEntry)this.timeseriesLatestDao.findLatest(this.tenantId, (EntityId)deviceId, "key").get();
        Assertions.assertNotNull((Object)foundEntry);
        this.equalsIgnoreVersion(updatedEntry, foundEntry);
        Assertions.assertEquals((Long)updatedVersion, (Long)foundEntry.getVersion());
    }

    @Test
    public void updateWithOldTsTest() throws Exception {
        int i;
        DeviceId deviceId = new DeviceId(UUID.randomUUID());
        int n = 50;
        for (int i2 = 0; i2 < n; ++i2) {
            this.timeseriesLatestDao.saveLatest(this.tenantId, (EntityId)deviceId, this.createEntry("key_" + i2, System.currentTimeMillis()));
        }
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(n);
        for (i = 0; i < n; ++i) {
            long ts = i % 2 == 0 ? System.currentTimeMillis() : 1000L;
            futures.add(this.timeseriesLatestDao.saveLatest(this.tenantId, (EntityId)deviceId, this.createEntry("key_" + i, ts)));
        }
        for (i = 0; i < futures.size(); ++i) {
            Long version = (Long)((ListenableFuture)futures.get(i)).get();
            if (i % 2 == 0) {
                Assertions.assertNotNull((Object)version);
                Assertions.assertTrue((version > 0L ? 1 : 0) != 0);
                continue;
            }
            Assertions.assertNull((Object)version);
        }
    }

    private TsKvEntry createEntry(String key, long ts) {
        return new BasicTsKvEntry(ts, (KvEntry)new StringDataEntry(key, RandomStringUtils.random((int)10)));
    }

    private void equalsIgnoreVersion(TsKvEntry expected, TsKvEntry actual) {
        Assert.assertEquals((Object)expected.getKey(), (Object)actual.getKey());
        Assert.assertEquals((Object)expected.getValue(), (Object)actual.getValue());
        Assert.assertEquals((long)expected.getTs(), (long)actual.getTs());
    }
}

