/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sqlts;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Optional;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.kv.Aggregation;
import org.thingsboard.server.common.data.kv.BaseReadTsKvQuery;
import org.thingsboard.server.common.data.kv.ReadTsKvQuery;
import org.thingsboard.server.common.data.kv.ReadTsKvQueryResult;
import org.thingsboard.server.common.data.kv.TsKvEntry;
import org.thingsboard.server.dao.sqlts.AbstractChunkedAggregationTimeseriesDao;

public class AbstractChunkedAggregationTimeseriesDaoTest {
    final int LIMIT = 1;
    final String TEMP = "temp";
    final String DESC = "DESC";
    private AbstractChunkedAggregationTimeseriesDao tsDao;

    @Before
    public void setUp() throws Exception {
        this.tsDao = (AbstractChunkedAggregationTimeseriesDao)Mockito.spy(AbstractChunkedAggregationTimeseriesDao.class);
        Optional<TsKvEntry> optionalListenableFuture = Optional.of((TsKvEntry)Mockito.mock(TsKvEntry.class));
        ((AbstractChunkedAggregationTimeseriesDao)BDDMockito.willReturn((Object)Futures.immediateFuture(optionalListenableFuture)).given((Object)this.tsDao)).findAndAggregateAsync((EntityId)ArgumentMatchers.any(), ArgumentMatchers.anyString(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (Aggregation)ArgumentMatchers.any());
        ((AbstractChunkedAggregationTimeseriesDao)BDDMockito.willReturn((Object)Futures.immediateFuture((Object)((ReadTsKvQueryResult)Mockito.mock(ReadTsKvQueryResult.class)))).given((Object)this.tsDao)).getReadTsKvQueryResultFuture((ReadTsKvQuery)ArgumentMatchers.any(), (ListenableFuture)ArgumentMatchers.any());
        ((AbstractChunkedAggregationTimeseriesDao)BDDMockito.willReturn((Object)Mockito.mock(ReadTsKvQueryResult.class)).given((Object)this.tsDao)).findAllAsyncWithLimit((EntityId)ArgumentMatchers.any(), (ReadTsKvQuery)ArgumentMatchers.any());
    }

    @Test
    public void givenIntervalNotMultiplePeriod_whenAggregateCount_thenLastIntervalShorterThanOthersAndEqualsEndTs() {
        BaseReadTsKvQuery query = new BaseReadTsKvQuery("temp", 1L, 3000L, 2000L, 1, Aggregation.COUNT, "DESC");
        BaseReadTsKvQuery subQueryFirst = new BaseReadTsKvQuery("temp", 1L, 2001L, 1001L, 1, Aggregation.COUNT, "DESC");
        BaseReadTsKvQuery subQuerySecond = new BaseReadTsKvQuery("temp", 2001L, 3000L, 2501L, 1, Aggregation.COUNT, "DESC");
        this.tsDao.findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)2))).findAndAggregateAsync((EntityId)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (Aggregation)ArgumentMatchers.any());
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAndAggregateAsync((EntityId)TenantId.SYS_TENANT_ID, subQueryFirst.getKey(), 1L, 2001L, this.getTsForReadTsKvQuery(1L, 2001L), Aggregation.COUNT);
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAndAggregateAsync((EntityId)TenantId.SYS_TENANT_ID, subQuerySecond.getKey(), 2001L, 3000L, this.getTsForReadTsKvQuery(2001L, 3000L), Aggregation.COUNT);
    }

    @Test
    public void givenIntervalNotMultiplePeriod_whenAggregateCount_thenIntervalEqualsPeriod() {
        BaseReadTsKvQuery query = new BaseReadTsKvQuery("temp", 1L, 3000L, 3000L, 1, Aggregation.COUNT, "DESC");
        BaseReadTsKvQuery subQueryFirst = new BaseReadTsKvQuery("temp", 1L, 3001L, 1501L, 1, Aggregation.COUNT, "DESC");
        ((AbstractChunkedAggregationTimeseriesDao)BDDMockito.willCallRealMethod().given((Object)this.tsDao)).findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        Assertions.assertThat((Future)this.tsDao.findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query)).isNotNull();
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAndAggregateAsync((EntityId)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (Aggregation)ArgumentMatchers.any());
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAndAggregateAsync((EntityId)TenantId.SYS_TENANT_ID, subQueryFirst.getKey(), 1L, 3000L, this.getTsForReadTsKvQuery(1L, 3000L), Aggregation.COUNT);
    }

    @Test
    public void givenIntervalNotMultiplePeriod_whenAggregateCount_thenIntervalEqualsPeriodMinusOne() {
        BaseReadTsKvQuery query = new BaseReadTsKvQuery("temp", 1L, 3000L, 2999L, 1, Aggregation.COUNT, "DESC");
        BaseReadTsKvQuery subQueryFirst = new BaseReadTsKvQuery("temp", 1L, 3000L, 1500L, 1, Aggregation.COUNT, "DESC");
        ((AbstractChunkedAggregationTimeseriesDao)BDDMockito.willCallRealMethod().given((Object)this.tsDao)).findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        this.tsDao.findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAndAggregateAsync((EntityId)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (Aggregation)ArgumentMatchers.any());
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAndAggregateAsync((EntityId)TenantId.SYS_TENANT_ID, subQueryFirst.getKey(), 1L, 3000L, this.getTsForReadTsKvQuery(1L, 3000L), Aggregation.COUNT);
    }

    @Test
    public void givenIntervalNotMultiplePeriod_whenAggregateCount_thenIntervalEqualsPeriodPlusOne() {
        BaseReadTsKvQuery query = new BaseReadTsKvQuery("temp", 1L, 3000L, 3001L, 1, Aggregation.COUNT, "DESC");
        BaseReadTsKvQuery subQueryFirst = new BaseReadTsKvQuery("temp", 1L, 3001L, 1501L, 1, Aggregation.COUNT, "DESC");
        ((AbstractChunkedAggregationTimeseriesDao)BDDMockito.willCallRealMethod().given((Object)this.tsDao)).findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        this.tsDao.findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAndAggregateAsync((EntityId)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (Aggregation)ArgumentMatchers.any());
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAndAggregateAsync((EntityId)TenantId.SYS_TENANT_ID, subQueryFirst.getKey(), 1L, 3000L, this.getTsForReadTsKvQuery(1L, 3000L), Aggregation.COUNT);
    }

    @Test
    public void givenIntervalNotMultiplePeriod_whenAggregateCount_thenIntervalEqualsOneMillisecondAndStartTsIsZero() {
        BaseReadTsKvQuery query = new BaseReadTsKvQuery("temp", 0L, 0L, 1L, 1, Aggregation.COUNT, "DESC");
        BaseReadTsKvQuery subQueryFirst = new BaseReadTsKvQuery("temp", 0L, 1L, 0L, 1, Aggregation.COUNT, "DESC");
        ((AbstractChunkedAggregationTimeseriesDao)BDDMockito.willCallRealMethod().given((Object)this.tsDao)).findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        this.tsDao.findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAndAggregateAsync((EntityId)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (Aggregation)ArgumentMatchers.any());
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAndAggregateAsync((EntityId)TenantId.SYS_TENANT_ID, subQueryFirst.getKey(), 0L, 1L, this.getTsForReadTsKvQuery(0L, 1L), Aggregation.COUNT);
    }

    @Test
    public void givenIntervalNotMultiplePeriod_whenAggregateCount_thenIntervalEqualsOneMillisecondAndStartTsIsOne() {
        BaseReadTsKvQuery query = new BaseReadTsKvQuery("temp", 1L, 1L, 1L, 1, Aggregation.COUNT, "DESC");
        BaseReadTsKvQuery subQuery = new BaseReadTsKvQuery("temp", 1L, 2L, 1L, 1, Aggregation.COUNT, "DESC");
        ((AbstractChunkedAggregationTimeseriesDao)BDDMockito.willCallRealMethod().given((Object)this.tsDao)).findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        this.tsDao.findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAndAggregateAsync((EntityId)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (Aggregation)ArgumentMatchers.any());
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAndAggregateAsync((EntityId)TenantId.SYS_TENANT_ID, subQuery.getKey(), 1L, 2L, this.getTsForReadTsKvQuery(1L, 2L), Aggregation.COUNT);
    }

    @Test
    public void givenIntervalNotMultiplePeriod_whenAggregateCount_thenIntervalEqualsOneMillisecondAndStartTsIsIntegerMax() {
        BaseReadTsKvQuery query = new BaseReadTsKvQuery("temp", Integer.MAX_VALUE, Integer.MAX_VALUE, 1L, 1, Aggregation.COUNT, "DESC");
        BaseReadTsKvQuery subQueryFirst = new BaseReadTsKvQuery("temp", Integer.MAX_VALUE, 0x80000000L, Integer.MAX_VALUE, 1, Aggregation.COUNT, "DESC");
        ((AbstractChunkedAggregationTimeseriesDao)BDDMockito.willCallRealMethod().given((Object)this.tsDao)).findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        this.tsDao.findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAndAggregateAsync((EntityId)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (Aggregation)ArgumentMatchers.any());
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAndAggregateAsync((EntityId)TenantId.SYS_TENANT_ID, subQueryFirst.getKey(), Integer.MAX_VALUE, 0x80000000L, this.getTsForReadTsKvQuery(Integer.MAX_VALUE, 0x80000000L), Aggregation.COUNT);
    }

    @Test
    public void givenIntervalNotMultiplePeriod_whenAggregateCount_thenIntervalEqualsBigNumber() {
        BaseReadTsKvQuery query = new BaseReadTsKvQuery("temp", 1L, 3000L, Integer.MAX_VALUE, 1, Aggregation.COUNT, "DESC");
        BaseReadTsKvQuery subQueryFirst = new BaseReadTsKvQuery("temp", 1L, 3001L, 1501L, 1, Aggregation.COUNT, "DESC");
        ((AbstractChunkedAggregationTimeseriesDao)BDDMockito.willCallRealMethod().given((Object)this.tsDao)).findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        this.tsDao.findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAndAggregateAsync((EntityId)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (Aggregation)ArgumentMatchers.any());
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAndAggregateAsync((EntityId)TenantId.SYS_TENANT_ID, subQueryFirst.getKey(), 1L, 3000L, this.getTsForReadTsKvQuery(1L, 3000L), Aggregation.COUNT);
    }

    @Test
    public void givenIntervalNotMultiplePeriod_whenAggregateCount_thenCountIntervalEqualsPeriodSize() {
        BaseReadTsKvQuery query = new BaseReadTsKvQuery("temp", 1L, 3000L, 3L, 1, Aggregation.COUNT, "DESC");
        ((AbstractChunkedAggregationTimeseriesDao)BDDMockito.willCallRealMethod().given((Object)this.tsDao)).findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        this.tsDao.findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1000))).findAndAggregateAsync((EntityId)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (Aggregation)ArgumentMatchers.any());
        for (long i = 1L; i <= 3000L; i += 3L) {
            ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAndAggregateAsync((EntityId)TenantId.SYS_TENANT_ID, "temp", i, Math.min(i + 3L, 3000L), this.getTsForReadTsKvQuery(i, i + 3L), Aggregation.COUNT);
        }
    }

    @Test
    public void givenZeroInterval_whenAggregateCount_thenFindAllWithoutAggregation() {
        this.givenInterval_whenAggregateCount_thenFindAllWithoutAggregation(0);
    }

    @Test
    public void givenNegativeInterval_whenAggregateCount_thenFindAllWithoutAggregation() {
        this.givenInterval_whenAggregateCount_thenFindAllWithoutAggregation(-1);
    }

    public void givenInterval_whenAggregateCount_thenFindAllWithoutAggregation(int interval) {
        BaseReadTsKvQuery query = new BaseReadTsKvQuery("temp", 1L, 3000L, (long)interval, 1, Aggregation.COUNT, "DESC");
        ((AbstractChunkedAggregationTimeseriesDao)BDDMockito.willCallRealMethod().given((Object)this.tsDao)).findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        this.tsDao.findAllAsync(TenantId.SYS_TENANT_ID, (EntityId)TenantId.SYS_TENANT_ID, (ReadTsKvQuery)query);
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)1))).findAllAsyncWithLimit((EntityId)ArgumentMatchers.any(), (ReadTsKvQuery)ArgumentMatchers.any());
        ((AbstractChunkedAggregationTimeseriesDao)Mockito.verify((Object)this.tsDao, (VerificationMode)Mockito.times((int)0))).findAndAggregateAsync((EntityId)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (Aggregation)ArgumentMatchers.any());
    }

    long getTsForReadTsKvQuery(long startTs, long endTs) {
        return startTs + (endTs - startTs) / 2L;
    }
}

