/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.widget;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.SortOrder;
import org.thingsboard.server.common.data.widget.WidgetType;
import org.thingsboard.server.common.data.widget.WidgetTypeDetails;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.common.data.widget.WidgetsBundleFilter;
import org.thingsboard.server.common.data.widget.WidgetsBundleWidget;
import org.thingsboard.server.dao.AbstractJpaDaoTest;
import org.thingsboard.server.dao.widget.WidgetTypeDao;
import org.thingsboard.server.dao.widget.WidgetsBundleDao;

public class JpaWidgetsBundleDaoTest
extends AbstractJpaDaoTest {
    final Map<String, String[]> SHOULD_FIND_SEARCH_TO_TAGS_MAP = Map.of("A", new String[]{"a", "b", "c"}, "test A test", new String[]{"a", "b", "c"}, "test x y test", new String[]{"x y", "b", "c"}, "x y test", new String[]{"x y", "b", "c"}, "x y", new String[]{"x y", "b", "c"}, "test x y", new String[]{"x y", "b", "c"});
    final Map<String, String[]> SHOULDNT_FIND_SEARCH_TO_TAGS_MAP = Map.of("testA test", new String[]{"a", "b", "c"}, "testx y test", new String[]{"x y", "b", "c"}, "testx ytest", new String[]{"x y", "b", "c"}, "x ytest", new String[]{"x y", "b", "c"}, "testx y", new String[]{"x y", "b", "c"}, "x", new String[]{"x y", "b", "c"});
    List<WidgetsBundle> widgetsBundles;
    List<WidgetType> widgetTypeList;
    @Autowired
    private WidgetsBundleDao widgetsBundleDao;
    @Autowired
    private WidgetTypeDao widgetTypeDao;

    @Before
    public void setUp() {
        this.widgetTypeList = new ArrayList<WidgetType>();
    }

    @After
    public void tearDown() {
        for (WidgetsBundle widgetsBundle : this.widgetsBundles) {
            this.widgetsBundleDao.removeById(widgetsBundle.getTenantId(), widgetsBundle.getUuidId());
        }
        for (WidgetType widgetType : this.widgetTypeList) {
            this.widgetTypeDao.removeById(TenantId.SYS_TENANT_ID, widgetType.getUuidId());
        }
    }

    @Test
    public void testFindAll() {
        this.createSystemWidgetBundles(7, "WB_");
        this.widgetsBundles = this.widgetsBundleDao.find(TenantId.SYS_TENANT_ID);
        Assert.assertEquals((long)7L, (long)this.widgetsBundles.size());
    }

    @Test
    public void testFindWidgetsBundleByTenantIdAndAlias() {
        this.createSystemWidgetBundles(1, "WB_");
        WidgetsBundle widgetsBundle = this.widgetsBundleDao.findWidgetsBundleByTenantIdAndAlias(TenantId.SYS_TENANT_ID.getId(), "WB_0");
        this.widgetsBundles = List.of(widgetsBundle);
        Assert.assertEquals((Object)"WB_0", (Object)widgetsBundle.getAlias());
    }

    @Test
    public void testFindSystemWidgetsBundles() {
        this.createSystemWidgetBundles(30, "WB_");
        this.widgetsBundles = this.widgetsBundleDao.find(TenantId.SYS_TENANT_ID);
        Assert.assertEquals((long)30L, (long)this.widgetsBundles.size());
        PageLink pageLink = new PageLink(10, 0, "WB");
        PageData widgetsBundles1 = this.widgetsBundleDao.findSystemWidgetsBundles(WidgetsBundleFilter.fromTenantId((TenantId)TenantId.SYS_TENANT_ID), pageLink);
        Assert.assertEquals((long)10L, (long)widgetsBundles1.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData widgetsBundles2 = this.widgetsBundleDao.findSystemWidgetsBundles(WidgetsBundleFilter.fromTenantId((TenantId)TenantId.SYS_TENANT_ID), pageLink);
        Assert.assertEquals((long)10L, (long)widgetsBundles2.getData().size());
    }

    @Test
    public void testFindSystemWidgetsBundlesFullSearch() {
        this.createSystemWidgetBundles(30, "WB_");
        this.widgetsBundles = this.widgetsBundleDao.find(TenantId.SYS_TENANT_ID).stream().sorted(Comparator.comparing(WidgetsBundle::getTitle)).collect(Collectors.toList());
        Assert.assertEquals((long)30L, (long)this.widgetsBundles.size());
        WidgetType widgetType1 = this.createAndSaveWidgetType(TenantId.SYS_TENANT_ID, 1, "Test widget type 1", "This is the widget type 1", new String[]{"tag1", "Tag2", "TEST_TAG"});
        WidgetType widgetType2 = this.createAndSaveWidgetType(TenantId.SYS_TENANT_ID, 2, "Test widget type 2", "This is the widget type 2", new String[]{"tag3", "Tag5", "TEST_Tag2"});
        WidgetsBundle widgetsBundle1 = this.widgetsBundles.get(10);
        this.widgetTypeDao.saveWidgetsBundleWidget(new WidgetsBundleWidget(widgetsBundle1.getId(), widgetType1.getId(), 0));
        WidgetsBundle widgetsBundle2 = this.widgetsBundles.get(15);
        this.widgetTypeDao.saveWidgetsBundleWidget(new WidgetsBundleWidget(widgetsBundle2.getId(), widgetType2.getId(), 0));
        WidgetsBundle widgetsBundle3 = this.widgetsBundles.get(28);
        this.widgetTypeDao.saveWidgetsBundleWidget(new WidgetsBundleWidget(widgetsBundle3.getId(), widgetType1.getId(), 0));
        this.widgetTypeDao.saveWidgetsBundleWidget(new WidgetsBundleWidget(widgetsBundle3.getId(), widgetType2.getId(), 1));
        PageLink pageLink = new PageLink(10, 0, "widget type 1", new SortOrder("title"));
        PageData widgetsBundles1 = this.widgetsBundleDao.findSystemWidgetsBundles(WidgetsBundleFilter.fullSearchFromTenantId((TenantId)TenantId.SYS_TENANT_ID), pageLink);
        Assert.assertEquals((long)2L, (long)widgetsBundles1.getData().size());
        Assert.assertEquals((Object)widgetsBundle1, widgetsBundles1.getData().get(0));
        Assert.assertEquals((Object)widgetsBundle3, widgetsBundles1.getData().get(1));
        pageLink = new PageLink(10, 0, "Test widget type 2", new SortOrder("title"));
        PageData widgetsBundles2 = this.widgetsBundleDao.findSystemWidgetsBundles(WidgetsBundleFilter.fullSearchFromTenantId((TenantId)TenantId.SYS_TENANT_ID), pageLink);
        Assert.assertEquals((long)2L, (long)widgetsBundles2.getData().size());
        Assert.assertEquals((Object)widgetsBundle2, widgetsBundles2.getData().get(0));
        Assert.assertEquals((Object)widgetsBundle3, widgetsBundles2.getData().get(1));
        pageLink = new PageLink(10, 0, "ppp Fd v TAG1 tt", new SortOrder("title"));
        PageData widgetsBundles3 = this.widgetsBundleDao.findSystemWidgetsBundles(WidgetsBundleFilter.fullSearchFromTenantId((TenantId)TenantId.SYS_TENANT_ID), pageLink);
        Assert.assertEquals((long)2L, (long)widgetsBundles3.getData().size());
        Assert.assertEquals((Object)widgetsBundle1, widgetsBundles3.getData().get(0));
        Assert.assertEquals((Object)widgetsBundle3, widgetsBundles3.getData().get(1));
    }

    @Test
    public void testTagsSearchInFindBySystemWidgetTypes() {
        PageData widgetTypes;
        WidgetType widgetType;
        WidgetsBundle systemWidgetBundle;
        String[] tags;
        String searchText;
        for (Map.Entry<String, String[]> entry : this.SHOULD_FIND_SEARCH_TO_TAGS_MAP.entrySet()) {
            searchText = entry.getKey();
            tags = entry.getValue();
            systemWidgetBundle = this.createSystemWidgetBundle("Test Widget Bundle Alias", "Test Widget Bundle Title");
            widgetType = this.createAndSaveWidgetType(TenantId.SYS_TENANT_ID, 0, "Test Widget Type Name", "Test Widget Type Description", tags);
            this.widgetTypeDao.saveWidgetsBundleWidget(new WidgetsBundleWidget(systemWidgetBundle.getId(), widgetType.getId(), 0));
            widgetTypes = this.widgetsBundleDao.findSystemWidgetsBundles(WidgetsBundleFilter.fullSearchFromTenantId((TenantId)TenantId.SYS_TENANT_ID), new PageLink(10, 0, searchText));
            Assertions.assertThat((List)widgetTypes.getData()).hasSize(1);
            Assertions.assertThat((Object)((WidgetsBundle)widgetTypes.getData().get(0)).getId()).isEqualTo((Object)systemWidgetBundle.getId());
            this.widgetTypeDao.removeWidgetTypeFromWidgetsBundle(systemWidgetBundle.getUuidId(), widgetType.getUuidId());
            this.widgetTypeDao.removeById(TenantId.SYS_TENANT_ID, widgetType.getUuidId());
            this.widgetsBundleDao.removeById(TenantId.SYS_TENANT_ID, systemWidgetBundle.getUuidId());
        }
        for (Map.Entry<String, String[]> entry : this.SHOULDNT_FIND_SEARCH_TO_TAGS_MAP.entrySet()) {
            searchText = entry.getKey();
            tags = entry.getValue();
            systemWidgetBundle = this.createSystemWidgetBundle("Test Widget Bundle Alias", "Test Widget Bundle Title");
            widgetType = this.createAndSaveWidgetType(TenantId.SYS_TENANT_ID, 0, "Test Widget Type Name", "Test Widget Type Description", tags);
            this.widgetTypeDao.saveWidgetsBundleWidget(new WidgetsBundleWidget(systemWidgetBundle.getId(), widgetType.getId(), 0));
            widgetTypes = this.widgetsBundleDao.findSystemWidgetsBundles(WidgetsBundleFilter.fullSearchFromTenantId((TenantId)TenantId.SYS_TENANT_ID), new PageLink(10, 0, searchText));
            Assertions.assertThat((List)widgetTypes.getData()).hasSize(0);
            this.widgetTypeDao.removeWidgetTypeFromWidgetsBundle(systemWidgetBundle.getUuidId(), widgetType.getUuidId());
            this.widgetTypeDao.removeById(TenantId.SYS_TENANT_ID, widgetType.getUuidId());
            this.widgetsBundleDao.removeById(TenantId.SYS_TENANT_ID, systemWidgetBundle.getUuidId());
        }
        this.widgetsBundles = new ArrayList<WidgetsBundle>();
        this.widgetTypeList = new ArrayList<WidgetType>();
    }

    @Test
    public void testFindWidgetsBundlesByTenantId() {
        UUID tenantId1 = Uuids.timeBased();
        UUID tenantId2 = Uuids.timeBased();
        for (int i = 0; i < 10; ++i) {
            this.createWidgetBundles(3, tenantId1, "WB1_" + i + "_");
            this.createWidgetBundles(5, tenantId2, "WB2_" + i + "_");
            this.createSystemWidgetBundles(10, "WB_SYS_" + i + "_");
        }
        this.widgetsBundles = this.widgetsBundleDao.find(TenantId.SYS_TENANT_ID);
        Assert.assertEquals((long)180L, (long)this.widgetsBundleDao.find(TenantId.SYS_TENANT_ID).size());
        PageLink pageLink1 = new PageLink(40, 0, "WB");
        PageData widgetsBundles1 = this.widgetsBundleDao.findTenantWidgetsBundlesByTenantId(tenantId1, pageLink1);
        Assert.assertEquals((long)30L, (long)widgetsBundles1.getData().size());
        PageLink pageLink2 = new PageLink(40, 0, "WB");
        PageData widgetsBundles2 = this.widgetsBundleDao.findTenantWidgetsBundlesByTenantId(tenantId2, pageLink2);
        Assert.assertEquals((long)40L, (long)widgetsBundles2.getData().size());
        pageLink2 = pageLink2.nextPageLink();
        PageData widgetsBundles3 = this.widgetsBundleDao.findTenantWidgetsBundlesByTenantId(tenantId2, pageLink2);
        Assert.assertEquals((long)10L, (long)widgetsBundles3.getData().size());
    }

    @Test
    public void testFindAllWidgetsBundlesByTenantId() {
        UUID tenantId1 = Uuids.timeBased();
        UUID tenantId2 = Uuids.timeBased();
        for (int i = 0; i < 10; ++i) {
            this.createWidgetBundles(5, tenantId1, "WB1_" + i + "_");
            this.createWidgetBundles(3, tenantId2, "WB2_" + i + "_");
            this.createSystemWidgetBundles(2, "WB_SYS_" + i + "_");
        }
        this.widgetsBundles = this.widgetsBundleDao.find(TenantId.SYS_TENANT_ID);
        Assert.assertEquals((long)100L, (long)this.widgetsBundleDao.find(TenantId.SYS_TENANT_ID).size());
        PageLink pageLink = new PageLink(30, 0, "WB");
        PageData widgetsBundles1 = this.widgetsBundleDao.findAllTenantWidgetsBundlesByTenantId(WidgetsBundleFilter.fromTenantId((TenantId)TenantId.fromUUID((UUID)tenantId1)), pageLink);
        Assert.assertEquals((long)30L, (long)widgetsBundles1.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData widgetsBundles2 = this.widgetsBundleDao.findAllTenantWidgetsBundlesByTenantId(WidgetsBundleFilter.fromTenantId((TenantId)TenantId.fromUUID((UUID)tenantId1)), pageLink);
        Assert.assertEquals((long)30L, (long)widgetsBundles2.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData widgetsBundles3 = this.widgetsBundleDao.findAllTenantWidgetsBundlesByTenantId(WidgetsBundleFilter.fromTenantId((TenantId)TenantId.fromUUID((UUID)tenantId1)), pageLink);
        Assert.assertEquals((long)10L, (long)widgetsBundles3.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData widgetsBundles4 = this.widgetsBundleDao.findAllTenantWidgetsBundlesByTenantId(WidgetsBundleFilter.fromTenantId((TenantId)TenantId.fromUUID((UUID)tenantId1)), pageLink);
        Assert.assertEquals((long)0L, (long)widgetsBundles4.getData().size());
    }

    @Test
    public void testFindAllWidgetsBundlesByTenantIdFullSearch() {
        UUID tenantId1 = Uuids.timeBased();
        UUID tenantId2 = Uuids.timeBased();
        for (int i = 0; i < 10; ++i) {
            this.createWidgetBundles(5, tenantId1, "WB1_" + i + "_");
            this.createWidgetBundles(3, tenantId2, "WB2_" + i + "_");
            this.createSystemWidgetBundles(2, "WB_SYS_" + i + "_");
        }
        this.widgetsBundles = this.widgetsBundleDao.find(TenantId.SYS_TENANT_ID).stream().sorted(Comparator.comparing(WidgetsBundle::getTitle)).collect(Collectors.toList());
        Assert.assertEquals((long)100L, (long)this.widgetsBundles.size());
        WidgetType widgetType1 = this.createAndSaveWidgetType(new TenantId(tenantId1), 1, "Test widget type 1", "This is the widget type 1", new String[]{"tag1", "Tag2", "TEST_TAG"});
        WidgetType widgetType2 = this.createAndSaveWidgetType(new TenantId(tenantId2), 2, "Test widget type 2", "This is the widget type 2", new String[]{"tag3", "Tag5", "TEST_Tag2"});
        WidgetsBundle widgetsBundle1 = (WidgetsBundle)this.widgetsBundles.stream().filter(widgetsBundle -> widgetsBundle.getTenantId().getId().equals(tenantId1)).collect(Collectors.toList()).get(10);
        this.widgetTypeDao.saveWidgetsBundleWidget(new WidgetsBundleWidget(widgetsBundle1.getId(), widgetType1.getId(), 0));
        WidgetsBundle widgetsBundle2 = (WidgetsBundle)this.widgetsBundles.stream().filter(widgetsBundle -> widgetsBundle.getTenantId().getId().equals(tenantId2)).collect(Collectors.toList()).get(15);
        this.widgetTypeDao.saveWidgetsBundleWidget(new WidgetsBundleWidget(widgetsBundle2.getId(), widgetType2.getId(), 0));
        WidgetsBundle widgetsBundle3 = (WidgetsBundle)this.widgetsBundles.stream().filter(widgetsBundle -> widgetsBundle.getTenantId().getId().equals(tenantId2)).collect(Collectors.toList()).get(28);
        this.widgetTypeDao.saveWidgetsBundleWidget(new WidgetsBundleWidget(widgetsBundle3.getId(), widgetType1.getId(), 0));
        this.widgetTypeDao.saveWidgetsBundleWidget(new WidgetsBundleWidget(widgetsBundle3.getId(), widgetType2.getId(), 1));
        PageLink pageLink = new PageLink(10, 0, "widget type 1", new SortOrder("title"));
        PageData widgetsBundles1 = this.widgetsBundleDao.findAllTenantWidgetsBundlesByTenantId(WidgetsBundleFilter.fullSearchFromTenantId((TenantId)TenantId.fromUUID((UUID)tenantId1)), pageLink);
        Assert.assertEquals((long)1L, (long)widgetsBundles1.getData().size());
        Assert.assertEquals((Object)widgetsBundle1, widgetsBundles1.getData().get(0));
        pageLink = new PageLink(10, 0, "Test widget type 2", new SortOrder("title"));
        PageData widgetsBundles2 = this.widgetsBundleDao.findAllTenantWidgetsBundlesByTenantId(WidgetsBundleFilter.fullSearchFromTenantId((TenantId)TenantId.fromUUID((UUID)tenantId1)), pageLink);
        Assert.assertEquals((long)0L, (long)widgetsBundles2.getData().size());
        PageData widgetsBundles3 = this.widgetsBundleDao.findAllTenantWidgetsBundlesByTenantId(WidgetsBundleFilter.fullSearchFromTenantId((TenantId)TenantId.fromUUID((UUID)tenantId2)), pageLink);
        Assert.assertEquals((long)2L, (long)widgetsBundles3.getData().size());
        Assert.assertEquals((Object)widgetsBundle2, widgetsBundles3.getData().get(0));
        Assert.assertEquals((Object)widgetsBundle3, widgetsBundles3.getData().get(1));
        pageLink = new PageLink(10, 0, "ttt Tag2 ffff hhhh", new SortOrder("title"));
        PageData widgetsBundles4 = this.widgetsBundleDao.findAllTenantWidgetsBundlesByTenantId(WidgetsBundleFilter.fullSearchFromTenantId((TenantId)TenantId.fromUUID((UUID)tenantId1)), pageLink);
        Assert.assertEquals((long)1L, (long)widgetsBundles4.getData().size());
        Assert.assertEquals((Object)widgetsBundle1, widgetsBundles4.getData().get(0));
        PageData widgetsBundles5 = this.widgetsBundleDao.findAllTenantWidgetsBundlesByTenantId(WidgetsBundleFilter.fullSearchFromTenantId((TenantId)TenantId.fromUUID((UUID)tenantId2)), pageLink);
        Assert.assertEquals((long)1L, (long)widgetsBundles5.getData().size());
        Assert.assertEquals((Object)widgetsBundle3, widgetsBundles5.getData().get(0));
    }

    @Test
    public void testFindAllWidgetsBundlesByTenantIdFullSearchScadaFirst() {
        WidgetsBundle widgetsBundle;
        int i;
        WidgetsBundle widgetsBundle2;
        int i2;
        UUID tenantId1 = Uuids.timeBased();
        UUID tenantId2 = Uuids.timeBased();
        for (int i3 = 0; i3 < 10; ++i3) {
            this.createWidgetBundles(5, tenantId1, "WB1_" + i3 + "_");
            this.createWidgetBundles(2, tenantId1, "WB1_SCADA_" + i3 + "_", true);
            this.createWidgetBundles(3, tenantId2, "WB2_" + i3 + "_");
            this.createWidgetBundles(3, tenantId2, "WB2_SCADA_" + i3 + "_", true);
            this.createSystemWidgetBundles(2, "WB_SYS_" + i3 + "_");
            this.createSystemWidgetBundles(1, "WB_SYS_SCADA_" + i3 + "_", true);
        }
        this.widgetsBundles = this.widgetsBundleDao.find(TenantId.SYS_TENANT_ID).stream().sorted(Comparator.comparing(WidgetsBundle::getTitle)).collect(Collectors.toList());
        Assert.assertEquals((long)160L, (long)this.widgetsBundles.size());
        PageLink pageLink = new PageLink(50, 0, "WB", new SortOrder("title"));
        PageData widgetsBundles1 = this.widgetsBundleDao.findAllTenantWidgetsBundlesByTenantId(WidgetsBundleFilter.builder().tenantId(TenantId.fromUUID((UUID)tenantId1)).fullSearch(true).scadaFirst(true).build(), pageLink);
        for (i2 = 0; i2 < 30; ++i2) {
            widgetsBundle2 = (WidgetsBundle)widgetsBundles1.getData().get(i2);
            Assert.assertTrue((boolean)widgetsBundle2.isScada());
        }
        for (i2 = 30; i2 < 50; ++i2) {
            widgetsBundle2 = (WidgetsBundle)widgetsBundles1.getData().get(i2);
            Assert.assertFalse((boolean)widgetsBundle2.isScada());
        }
        pageLink = new PageLink(50, 0, "WB", new SortOrder("title"));
        PageData widgetsBundles2 = this.widgetsBundleDao.findAllTenantWidgetsBundlesByTenantId(WidgetsBundleFilter.builder().tenantId(TenantId.fromUUID((UUID)tenantId2)).fullSearch(true).scadaFirst(true).build(), pageLink);
        for (i = 0; i < 40; ++i) {
            widgetsBundle = (WidgetsBundle)widgetsBundles2.getData().get(i);
            Assert.assertTrue((boolean)widgetsBundle.isScada());
        }
        for (i = 40; i < 50; ++i) {
            widgetsBundle = (WidgetsBundle)widgetsBundles2.getData().get(i);
            Assert.assertFalse((boolean)widgetsBundle.isScada());
        }
    }

    @Test
    public void testTagsSearchInFindAllWidgetsBundlesByTenantId() {
        PageData widgetTypes;
        WidgetType widgetType;
        WidgetsBundle systemWidgetBundle;
        String[] tags;
        String searchText;
        for (Map.Entry<String, String[]> entry : this.SHOULD_FIND_SEARCH_TO_TAGS_MAP.entrySet()) {
            searchText = entry.getKey();
            tags = entry.getValue();
            systemWidgetBundle = this.createSystemWidgetBundle("Test Widget Bundle Alias", "Test Widget Bundle Title");
            widgetType = this.createAndSaveWidgetType(TenantId.SYS_TENANT_ID, 0, "Test Widget Type Name", "Test Widget Type Description", tags);
            this.widgetTypeDao.saveWidgetsBundleWidget(new WidgetsBundleWidget(systemWidgetBundle.getId(), widgetType.getId(), 0));
            widgetTypes = this.widgetsBundleDao.findAllTenantWidgetsBundlesByTenantId(WidgetsBundleFilter.fullSearchFromTenantId((TenantId)TenantId.SYS_TENANT_ID), new PageLink(10, 0, searchText));
            Assertions.assertThat((List)widgetTypes.getData()).hasSize(1);
            Assertions.assertThat((Object)((WidgetsBundle)widgetTypes.getData().get(0)).getId()).isEqualTo((Object)systemWidgetBundle.getId());
            this.widgetTypeDao.removeWidgetTypeFromWidgetsBundle(systemWidgetBundle.getUuidId(), widgetType.getUuidId());
            this.widgetTypeDao.removeById(TenantId.SYS_TENANT_ID, widgetType.getUuidId());
            this.widgetsBundleDao.removeById(TenantId.SYS_TENANT_ID, systemWidgetBundle.getUuidId());
        }
        for (Map.Entry<String, String[]> entry : this.SHOULDNT_FIND_SEARCH_TO_TAGS_MAP.entrySet()) {
            searchText = entry.getKey();
            tags = entry.getValue();
            systemWidgetBundle = this.createSystemWidgetBundle("Test Widget Bundle Alias", "Test Widget Bundle Title");
            widgetType = this.createAndSaveWidgetType(TenantId.SYS_TENANT_ID, 0, "Test Widget Type Name", "Test Widget Type Description", tags);
            this.widgetTypeDao.saveWidgetsBundleWidget(new WidgetsBundleWidget(systemWidgetBundle.getId(), widgetType.getId(), 0));
            widgetTypes = this.widgetsBundleDao.findAllTenantWidgetsBundlesByTenantId(WidgetsBundleFilter.fullSearchFromTenantId((TenantId)TenantId.SYS_TENANT_ID), new PageLink(10, 0, searchText));
            Assertions.assertThat((List)widgetTypes.getData()).hasSize(0);
            this.widgetTypeDao.removeWidgetTypeFromWidgetsBundle(systemWidgetBundle.getUuidId(), widgetType.getUuidId());
            this.widgetTypeDao.removeById(TenantId.SYS_TENANT_ID, widgetType.getUuidId());
            this.widgetsBundleDao.removeById(TenantId.SYS_TENANT_ID, systemWidgetBundle.getUuidId());
        }
        this.widgetsBundles = new ArrayList<WidgetsBundle>();
        this.widgetTypeList = new ArrayList<WidgetType>();
    }

    @Test
    public void testOrderInFindAllWidgetsBundlesByTenantIdFullSearch() {
        UUID tenantId1 = Uuids.timeBased();
        for (int i = 0; i < 10; ++i) {
            this.createWidgetsBundle(TenantId.fromUUID((UUID)tenantId1), "WB1_" + i, "WB1_" + (10 - i), i % 2 == 1 ? null : Integer.valueOf((int)(Math.random() * 1000.0)));
            this.createWidgetsBundle(TenantId.SYS_TENANT_ID, "WB_SYS_" + i, "WB_SYS_" + (10 - i), i % 2 == 0 ? null : Integer.valueOf((int)(Math.random() * 1000.0)));
        }
        this.widgetsBundles = this.widgetsBundleDao.find(TenantId.SYS_TENANT_ID).stream().sorted((o1, o2) -> {
            int result = 0;
            if (o1.getOrder() != null && o2.getOrder() != null) {
                result = o1.getOrder() - o2.getOrder();
            } else if (o1.getOrder() == null && o2.getOrder() != null) {
                result = 1;
            } else if (o1.getOrder() != null) {
                result = -1;
            }
            if (result == 0) {
                result = o1.getTitle().compareTo(o2.getTitle());
            }
            return result;
        }).collect(Collectors.toList());
        Assert.assertEquals((long)20L, (long)this.widgetsBundles.size());
        PageLink pageLink = new PageLink(100, 0, "", new SortOrder("title"));
        PageData widgetsBundlesData = this.widgetsBundleDao.findAllTenantWidgetsBundlesByTenantId(WidgetsBundleFilter.fullSearchFromTenantId((TenantId)TenantId.fromUUID((UUID)tenantId1)), pageLink);
        Assert.assertEquals((long)20L, (long)widgetsBundlesData.getData().size());
        Assert.assertEquals(this.widgetsBundles, (Object)widgetsBundlesData.getData());
    }

    @Test
    public void testSearchTextNotFound() {
        UUID tenantId = Uuids.timeBased();
        this.createWidgetBundles(5, tenantId, "ABC_");
        this.createSystemWidgetBundles(5, "SYS_");
        this.widgetsBundles = this.widgetsBundleDao.find(TenantId.SYS_TENANT_ID);
        Assert.assertEquals((long)10L, (long)this.widgetsBundleDao.find(TenantId.SYS_TENANT_ID).size());
        PageLink textPageLink = new PageLink(30, 0, "TEXT_NOT_FOUND");
        PageData widgetsBundles4 = this.widgetsBundleDao.findAllTenantWidgetsBundlesByTenantId(WidgetsBundleFilter.fromTenantId((TenantId)TenantId.fromUUID((UUID)tenantId)), textPageLink);
        Assert.assertEquals((long)0L, (long)widgetsBundles4.getData().size());
    }

    private void createWidgetBundles(int count, UUID tenantId, String prefix) {
        this.createWidgetBundles(count, tenantId, prefix, false);
    }

    private void createWidgetBundles(int count, UUID tenantId, String prefix, boolean scada) {
        for (int i = 0; i < count; ++i) {
            this.createWidgetsBundle(TenantId.fromUUID((UUID)tenantId), prefix + i, prefix + i, null, scada);
        }
    }

    private void createSystemWidgetBundles(int count, String prefix) {
        this.createSystemWidgetBundles(count, prefix, false);
    }

    private void createSystemWidgetBundles(int count, String prefix, boolean scada) {
        for (int i = 0; i < count; ++i) {
            this.createWidgetsBundle(TenantId.SYS_TENANT_ID, prefix + i, prefix + i, null, scada);
        }
    }

    private WidgetsBundle createSystemWidgetBundle(String alias, String title) {
        return this.createWidgetsBundle(TenantId.SYS_TENANT_ID, alias, title, null);
    }

    private WidgetsBundle createWidgetsBundle(TenantId tenantId, String alias, String title, Integer order) {
        return this.createWidgetsBundle(tenantId, alias, title, order, false);
    }

    private WidgetsBundle createWidgetsBundle(TenantId tenantId, String alias, String title, Integer order, boolean scada) {
        WidgetsBundle widgetsBundle = new WidgetsBundle();
        widgetsBundle.setAlias(alias);
        widgetsBundle.setTitle(title);
        widgetsBundle.setTenantId(tenantId);
        widgetsBundle.setId((UUIDBased)new WidgetsBundleId(Uuids.timeBased()));
        widgetsBundle.setOrder(order);
        widgetsBundle.setScada(scada);
        return this.widgetsBundleDao.save(TenantId.SYS_TENANT_ID, widgetsBundle);
    }

    WidgetType createAndSaveWidgetType(TenantId tenantId, int number, String name, String description, String[] tags) {
        WidgetTypeDetails widgetType = new WidgetTypeDetails();
        widgetType.setTenantId(tenantId);
        widgetType.setName(name);
        widgetType.setDescription(description);
        widgetType.setTags(tags);
        widgetType.setFqn("FQN_" + number);
        WidgetTypeDetails saved = this.widgetTypeDao.save(TenantId.SYS_TENANT_ID, widgetType);
        this.widgetTypeList.add((WidgetType)saved);
        return saved;
    }
}

