/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.widget;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.id.WidgetsBundleId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.page.SortOrder;
import org.thingsboard.server.common.data.widget.BaseWidgetType;
import org.thingsboard.server.common.data.widget.DeprecatedFilter;
import org.thingsboard.server.common.data.widget.WidgetBundleInfo;
import org.thingsboard.server.common.data.widget.WidgetType;
import org.thingsboard.server.common.data.widget.WidgetTypeDetails;
import org.thingsboard.server.common.data.widget.WidgetTypeFilter;
import org.thingsboard.server.common.data.widget.WidgetTypeInfo;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.common.data.widget.WidgetsBundleWidget;
import org.thingsboard.server.dao.AbstractJpaDaoTest;
import org.thingsboard.server.dao.widget.WidgetTypeDao;
import org.thingsboard.server.dao.widget.WidgetsBundleDao;

public class JpaWidgetTypeDaoTest
extends AbstractJpaDaoTest {
    final Map<String, String[]> SHOULD_FIND_SEARCH_TO_TAGS_MAP = Map.of("A", new String[]{"a", "b", "c"}, "test A test", new String[]{"a", "b", "c"}, "test x y test", new String[]{"x y", "b", "c"}, "x y test", new String[]{"x y", "b", "c"}, "x y", new String[]{"x y", "b", "c"}, "test x y", new String[]{"x y", "b", "c"});
    final Map<String, String[]> SHOULDNT_FIND_SEARCH_TO_TAGS_MAP = Map.of("testA test", new String[]{"a", "b", "c"}, "testx y test", new String[]{"x y", "b", "c"}, "testx ytest", new String[]{"x y", "b", "c"}, "x ytest", new String[]{"x y", "b", "c"}, "testx y", new String[]{"x y", "b", "c"}, "x", new String[]{"x y", "b", "c"});
    final String BUNDLE_ALIAS = "BUNDLE_ALIAS";
    final int WIDGET_TYPE_COUNT = 3;
    List<WidgetTypeInfo> widgetTypeList;
    WidgetsBundle widgetsBundle;
    @Autowired
    private WidgetTypeDao widgetTypeDao;
    @Autowired
    private WidgetsBundleDao widgetsBundleDao;

    @Before
    public void setUp() throws InterruptedException {
        this.widgetTypeList = new ArrayList<WidgetTypeInfo>();
        WidgetsBundle widgetsBundle = new WidgetsBundle();
        widgetsBundle.setAlias("BUNDLE_ALIAS");
        widgetsBundle.setTitle("BUNDLE_ALIAS");
        widgetsBundle.setId((UUIDBased)new WidgetsBundleId(Uuids.timeBased()));
        widgetsBundle.setTenantId(TenantId.SYS_TENANT_ID);
        this.widgetsBundle = this.widgetsBundleDao.save(TenantId.SYS_TENANT_ID, widgetsBundle);
        for (int i = 0; i < 3; ++i) {
            Thread.sleep(2L);
            WidgetTypeInfo widgetType = this.createAndSaveWidgetType(TenantId.SYS_TENANT_ID, i);
            this.widgetTypeList.add(widgetType);
            this.widgetTypeDao.saveWidgetsBundleWidget(new WidgetsBundleWidget(this.widgetsBundle.getId(), widgetType.getId(), i));
        }
        this.widgetTypeList.sort(Comparator.comparing(BaseWidgetType::getName));
    }

    WidgetTypeInfo createAndSaveWidgetType(TenantId tenantId, int number) {
        WidgetTypeDetails widgetType = new WidgetTypeDetails();
        widgetType.setTenantId(tenantId);
        widgetType.setName("WIDGET_TYPE_" + number);
        widgetType.setDescription("WIDGET_TYPE_DESCRIPTION" + number);
        widgetType.setFqn("FQN_" + number);
        widgetType.setImage("/image/system/logo.png");
        ObjectNode descriptor = JacksonUtil.newObjectNode();
        descriptor.put("type", number % 2 == 0 ? "latest" : "static");
        widgetType.setDescriptor((JsonNode)descriptor);
        String[] tags = new String[]{"Tag1_" + number, "Tag2_" + number, "TEST_" + number};
        widgetType.setTags(tags);
        WidgetTypeDetails saved = this.widgetTypeDao.save(TenantId.SYS_TENANT_ID, widgetType);
        ArrayList<WidgetBundleInfo> bundles = new ArrayList<WidgetBundleInfo>();
        bundles.add(new WidgetBundleInfo(this.widgetsBundle.getUuidId(), this.widgetsBundle.getName()));
        return new WidgetTypeInfo(saved, bundles);
    }

    WidgetTypeDetails createAndSaveWidgetType(TenantId tenantId, int number, String[] tags) {
        WidgetTypeDetails widgetType = new WidgetTypeDetails();
        widgetType.setTenantId(tenantId);
        widgetType.setName("WIDGET_TYPE_" + number);
        widgetType.setDescription("WIDGET_TYPE_DESCRIPTION" + number);
        widgetType.setFqn("FQN_" + number);
        widgetType.setImage("/image/tenant/logo.png");
        ObjectNode descriptor = JacksonUtil.newObjectNode();
        descriptor.put("type", number % 2 == 0 ? "latest" : "static");
        widgetType.setDescriptor((JsonNode)descriptor);
        widgetType.setTags(tags);
        return this.widgetTypeDao.save(TenantId.SYS_TENANT_ID, widgetType);
    }

    @After
    public void tearDown() {
        this.widgetsBundleDao.removeById(TenantId.SYS_TENANT_ID, this.widgetsBundle.getUuidId());
        for (WidgetTypeInfo widgetType : this.widgetTypeList) {
            this.widgetTypeDao.removeById(TenantId.SYS_TENANT_ID, widgetType.getUuidId());
        }
    }

    @Test
    public void testFindByWidgetsBundleId() {
        List widgetTypes = this.widgetTypeDao.findWidgetTypesByWidgetsBundleId(TenantId.SYS_TENANT_ID.getId(), this.widgetsBundle.getUuidId());
        Assert.assertEquals((long)3L, (long)widgetTypes.size());
    }

    @Test
    public void testFindSystemWidgetTypes() {
        PageData widgetTypes = this.widgetTypeDao.findSystemWidgetTypes(WidgetTypeFilter.builder().tenantId(TenantId.SYS_TENANT_ID).fullSearch(true).deprecatedFilter(DeprecatedFilter.ALL).widgetTypes(Collections.singletonList("static")).build(), new PageLink(1024, 0, "TYPE_DESCRIPTION", new SortOrder("createdTime")));
        Assert.assertEquals((long)1L, (long)widgetTypes.getData().size());
        Assert.assertEquals((Object)this.widgetTypeList.get(1), widgetTypes.getData().get(0));
        widgetTypes = this.widgetTypeDao.findSystemWidgetTypes(WidgetTypeFilter.builder().tenantId(TenantId.SYS_TENANT_ID).fullSearch(true).deprecatedFilter(DeprecatedFilter.ALL).widgetTypes(Collections.emptyList()).build(), new PageLink(1024, 0, "hfgfd tag2_2 ghg", new SortOrder("createdTime")));
        Assert.assertEquals((long)1L, (long)widgetTypes.getData().size());
        Assert.assertEquals((Object)this.widgetTypeList.get(2), widgetTypes.getData().get(0));
    }

    @Test
    public void testFindSystemWidgetTypesForSameName() throws InterruptedException {
        ArrayList<Object> sameNameList = new ArrayList<Object>();
        for (int i = 0; i < 20; ++i) {
            Thread.sleep(2L);
            WidgetTypeDetails widgetType = this.saveWidgetType(TenantId.SYS_TENANT_ID, "widgetName");
            sameNameList.add(widgetType);
            this.widgetTypeList.add(new WidgetTypeInfo(widgetType));
        }
        sameNameList.sort(Comparator.comparing(BaseWidgetType::getName).thenComparing(baseWidgetType -> baseWidgetType.getId().getId()));
        List expected = sameNameList.stream().map(WidgetTypeInfo::new).collect(Collectors.toList());
        PageData widgetTypesFirstPage = this.widgetTypeDao.findSystemWidgetTypes(WidgetTypeFilter.builder().tenantId(TenantId.SYS_TENANT_ID).fullSearch(true).deprecatedFilter(DeprecatedFilter.ALL).widgetTypes(Collections.singletonList("static")).build(), new PageLink(10, 0, null, new SortOrder("name")));
        Assert.assertEquals((long)10L, (long)widgetTypesFirstPage.getData().size());
        Assertions.assertThat((List)widgetTypesFirstPage.getData()).containsExactlyElementsOf(expected.subList(0, 10));
        PageData widgetTypesSecondPage = this.widgetTypeDao.findSystemWidgetTypes(WidgetTypeFilter.builder().tenantId(TenantId.SYS_TENANT_ID).fullSearch(true).deprecatedFilter(DeprecatedFilter.ALL).widgetTypes(Collections.singletonList("static")).build(), new PageLink(10, 1, null, new SortOrder("name")));
        Assert.assertEquals((long)10L, (long)widgetTypesSecondPage.getData().size());
        Assertions.assertThat((List)widgetTypesSecondPage.getData()).containsExactlyElementsOf(expected.subList(10, 20));
    }

    @Test
    public void testTagsSearchInFindBySystemWidgetTypes() {
        PageData widgetTypes;
        WidgetTypeDetails savedWidgetType;
        String[] tags;
        String searchText;
        for (Map.Entry<String, String[]> entry : this.SHOULD_FIND_SEARCH_TO_TAGS_MAP.entrySet()) {
            searchText = entry.getKey();
            tags = entry.getValue();
            savedWidgetType = this.createAndSaveWidgetType(TenantId.SYS_TENANT_ID, 4, tags);
            widgetTypes = this.widgetTypeDao.findSystemWidgetTypes(WidgetTypeFilter.builder().tenantId(TenantId.SYS_TENANT_ID).fullSearch(true).deprecatedFilter(DeprecatedFilter.ALL).widgetTypes(null).build(), new PageLink(10, 0, searchText));
            Assertions.assertThat((List)widgetTypes.getData()).hasSize(1);
            Assertions.assertThat((Object)((WidgetTypeInfo)widgetTypes.getData().get(0)).getId()).isEqualTo((Object)savedWidgetType.getId());
            this.widgetTypeDao.removeById(TenantId.SYS_TENANT_ID, savedWidgetType.getUuidId());
        }
        for (Map.Entry<String, String[]> entry : this.SHOULDNT_FIND_SEARCH_TO_TAGS_MAP.entrySet()) {
            searchText = entry.getKey();
            tags = entry.getValue();
            savedWidgetType = this.createAndSaveWidgetType(TenantId.SYS_TENANT_ID, 4, tags);
            widgetTypes = this.widgetTypeDao.findSystemWidgetTypes(WidgetTypeFilter.builder().tenantId(TenantId.SYS_TENANT_ID).fullSearch(true).deprecatedFilter(DeprecatedFilter.ALL).widgetTypes(null).build(), new PageLink(10, 0, searchText));
            Assertions.assertThat((List)widgetTypes.getData()).hasSize(0);
            this.widgetTypeDao.removeById(TenantId.SYS_TENANT_ID, savedWidgetType.getUuidId());
        }
    }

    @Test
    public void testFindTenantWidgetTypesByTenantId() {
        UUID tenantId = Uuids.timeBased();
        for (int i = 0; i < 3; ++i) {
            WidgetTypeInfo widgetType = this.createAndSaveWidgetType(TenantId.fromUUID((UUID)tenantId), i);
            this.widgetTypeList.add(widgetType);
        }
        PageData widgetTypes = this.widgetTypeDao.findTenantWidgetTypesByTenantId(WidgetTypeFilter.builder().tenantId(TenantId.fromUUID((UUID)tenantId)).fullSearch(true).deprecatedFilter(DeprecatedFilter.ALL).widgetTypes(null).build(), new PageLink(10, 0, "", new SortOrder("createdTime")));
        Assert.assertEquals((long)3L, (long)widgetTypes.getData().size());
        Assert.assertEquals((Object)new WidgetTypeInfo(this.widgetTypeList.get(3)), widgetTypes.getData().get(0));
        Assert.assertEquals((Object)new WidgetTypeInfo(this.widgetTypeList.get(4)), widgetTypes.getData().get(1));
        Assert.assertEquals((Object)new WidgetTypeInfo(this.widgetTypeList.get(5)), widgetTypes.getData().get(2));
    }

    @Test
    public void testTagsSearchInFindTenantWidgetTypesByTenantId() {
        PageData widgetTypes;
        WidgetTypeDetails savedWidgetType;
        String[] tags;
        String searchText;
        for (Map.Entry<String, String[]> entry : this.SHOULD_FIND_SEARCH_TO_TAGS_MAP.entrySet()) {
            searchText = entry.getKey();
            tags = entry.getValue();
            savedWidgetType = this.createAndSaveWidgetType(TenantId.SYS_TENANT_ID, 4, tags);
            widgetTypes = this.widgetTypeDao.findTenantWidgetTypesByTenantId(WidgetTypeFilter.builder().tenantId(TenantId.SYS_TENANT_ID).fullSearch(true).deprecatedFilter(DeprecatedFilter.ALL).widgetTypes(null).build(), new PageLink(10, 0, searchText));
            Assertions.assertThat((List)widgetTypes.getData()).hasSize(1);
            Assertions.assertThat((Object)((WidgetTypeInfo)widgetTypes.getData().get(0)).getId()).isEqualTo((Object)savedWidgetType.getId());
            this.widgetTypeDao.removeById(TenantId.SYS_TENANT_ID, savedWidgetType.getUuidId());
        }
        for (Map.Entry<String, String[]> entry : this.SHOULDNT_FIND_SEARCH_TO_TAGS_MAP.entrySet()) {
            searchText = entry.getKey();
            tags = entry.getValue();
            savedWidgetType = this.createAndSaveWidgetType(TenantId.SYS_TENANT_ID, 4, tags);
            widgetTypes = this.widgetTypeDao.findTenantWidgetTypesByTenantId(WidgetTypeFilter.builder().tenantId(TenantId.SYS_TENANT_ID).fullSearch(true).deprecatedFilter(DeprecatedFilter.ALL).widgetTypes(null).build(), new PageLink(10, 0, searchText));
            Assertions.assertThat((List)widgetTypes.getData()).hasSize(0);
            this.widgetTypeDao.removeById(TenantId.SYS_TENANT_ID, savedWidgetType.getUuidId());
        }
    }

    @Test
    public void testTagsSearchInFindAllTenantWidgetTypesByTenantId() {
        PageData widgetTypes;
        WidgetTypeDetails savedWidgetType;
        String[] tags;
        String searchText;
        for (Map.Entry<String, String[]> entry : this.SHOULD_FIND_SEARCH_TO_TAGS_MAP.entrySet()) {
            searchText = entry.getKey();
            tags = entry.getValue();
            savedWidgetType = this.createAndSaveWidgetType(TenantId.SYS_TENANT_ID, 4, tags);
            widgetTypes = this.widgetTypeDao.findAllTenantWidgetTypesByTenantId(WidgetTypeFilter.builder().tenantId(TenantId.SYS_TENANT_ID).fullSearch(true).deprecatedFilter(DeprecatedFilter.ALL).widgetTypes(null).build(), new PageLink(10, 0, searchText));
            Assertions.assertThat((List)widgetTypes.getData()).hasSize(1);
            Assertions.assertThat((Object)((WidgetTypeInfo)widgetTypes.getData().get(0)).getId()).isEqualTo((Object)savedWidgetType.getId());
            this.widgetTypeDao.removeById(TenantId.SYS_TENANT_ID, savedWidgetType.getUuidId());
        }
        for (Map.Entry<String, String[]> entry : this.SHOULDNT_FIND_SEARCH_TO_TAGS_MAP.entrySet()) {
            searchText = entry.getKey();
            tags = entry.getValue();
            savedWidgetType = this.createAndSaveWidgetType(TenantId.SYS_TENANT_ID, 4, tags);
            widgetTypes = this.widgetTypeDao.findAllTenantWidgetTypesByTenantId(WidgetTypeFilter.builder().tenantId(TenantId.SYS_TENANT_ID).fullSearch(true).deprecatedFilter(DeprecatedFilter.ALL).widgetTypes(null).build(), new PageLink(10, 0, searchText));
            Assertions.assertThat((List)widgetTypes.getData()).hasSize(0);
            this.widgetTypeDao.removeById(TenantId.SYS_TENANT_ID, savedWidgetType.getUuidId());
        }
    }

    @Test
    public void testFindByWidgetTypeInfosByBundleId() {
        PageData widgetTypes = this.widgetTypeDao.findWidgetTypesInfosByWidgetsBundleId(TenantId.SYS_TENANT_ID.getId(), this.widgetsBundle.getUuidId(), true, DeprecatedFilter.ALL, Collections.singletonList("latest"), new PageLink(1024, 0, "TYPE_DESCRIPTION", new SortOrder("createdTime")));
        Assert.assertEquals((long)2L, (long)widgetTypes.getData().size());
        Assert.assertEquals((Object)this.widgetTypeList.get(0), widgetTypes.getData().get(0));
        Assert.assertEquals((Object)this.widgetTypeList.get(2), widgetTypes.getData().get(1));
        widgetTypes = this.widgetTypeDao.findWidgetTypesInfosByWidgetsBundleId(TenantId.SYS_TENANT_ID.getId(), this.widgetsBundle.getUuidId(), true, DeprecatedFilter.ALL, Collections.emptyList(), new PageLink(1024, 0, "hfgfd TEST_0 ghg", new SortOrder("createdTime")));
        Assert.assertEquals((long)1L, (long)widgetTypes.getData().size());
        Assert.assertEquals((Object)this.widgetTypeList.get(0), widgetTypes.getData().get(0));
    }

    @Test
    public void testTagsSearchInFindByWidgetTypeInfosByBundleId() {
        PageData widgetTypes;
        WidgetTypeDetails savedWidgetType;
        String[] tags;
        String searchText;
        for (Map.Entry<String, String[]> entry : this.SHOULD_FIND_SEARCH_TO_TAGS_MAP.entrySet()) {
            searchText = entry.getKey();
            tags = entry.getValue();
            savedWidgetType = this.createAndSaveWidgetType(TenantId.SYS_TENANT_ID, 4, tags);
            this.widgetTypeDao.saveWidgetsBundleWidget(new WidgetsBundleWidget(this.widgetsBundle.getId(), savedWidgetType.getId(), 4));
            widgetTypes = this.widgetTypeDao.findWidgetTypesInfosByWidgetsBundleId(TenantId.SYS_TENANT_ID.getId(), this.widgetsBundle.getUuidId(), true, DeprecatedFilter.ALL, null, new PageLink(10, 0, searchText));
            Assertions.assertThat((List)widgetTypes.getData()).hasSize(1);
            Assertions.assertThat((Object)((WidgetTypeInfo)widgetTypes.getData().get(0)).getId()).isEqualTo((Object)savedWidgetType.getId());
            this.widgetTypeDao.removeById(TenantId.SYS_TENANT_ID, savedWidgetType.getUuidId());
        }
        for (Map.Entry<String, String[]> entry : this.SHOULDNT_FIND_SEARCH_TO_TAGS_MAP.entrySet()) {
            searchText = entry.getKey();
            tags = entry.getValue();
            savedWidgetType = this.createAndSaveWidgetType(TenantId.SYS_TENANT_ID, 4, tags);
            this.widgetTypeDao.saveWidgetsBundleWidget(new WidgetsBundleWidget(this.widgetsBundle.getId(), savedWidgetType.getId(), 4));
            widgetTypes = this.widgetTypeDao.findWidgetTypesInfosByWidgetsBundleId(TenantId.SYS_TENANT_ID.getId(), this.widgetsBundle.getUuidId(), true, DeprecatedFilter.ALL, null, new PageLink(10, 0, searchText));
            Assertions.assertThat((List)widgetTypes.getData()).hasSize(0);
            this.widgetTypeDao.removeById(TenantId.SYS_TENANT_ID, savedWidgetType.getUuidId());
        }
    }

    @Test
    public void testFindByTenantIdAndFqn() {
        WidgetTypeInfo result = this.widgetTypeList.get(0);
        Assert.assertNotNull((Object)result);
        WidgetType widgetType = this.widgetTypeDao.findByTenantIdAndFqn(TenantId.SYS_TENANT_ID.getId(), "FQN_0");
        Assert.assertEquals((Object)result.getId(), (Object)widgetType.getId());
    }

    @Test
    public void testFindByTenantAndImageLink() {
        List result = this.widgetTypeDao.findByImageLink("/image/system/logo.png", 5);
        Assert.assertEquals((long)3L, (long)result.size());
        result = this.widgetTypeDao.findByImageLink("/image/system/logo2.png", 5);
        Assert.assertEquals((long)0L, (long)result.size());
    }

    @Test
    public void testFindByImageLink() {
        TenantId tenantId = TenantId.fromUUID((UUID)UUID.randomUUID());
        WidgetTypeDetails details = this.createAndSaveWidgetType(tenantId, 0, new String[]{"a"});
        details.setDescriptor((JsonNode)JacksonUtil.newObjectNode().put("bg", "/image/tenant/widget.png"));
        this.widgetTypeDao.save(tenantId, details);
        List result = this.widgetTypeDao.findByTenantAndImageLink(tenantId, "/image/tenant/widget.png", 3);
        Assert.assertEquals((long)1L, (long)result.size());
        result = this.widgetTypeDao.findByTenantAndImageLink(tenantId, "/image/tenant/widget2.png", 3);
        Assert.assertEquals((long)0L, (long)result.size());
        this.widgetTypeDao.removeById(tenantId, details.getUuidId());
    }

    @Test
    public void testFindWidgetTypesWithBundles() {
        PageData widgetTypes = this.widgetTypeDao.findWidgetTypesInfosByWidgetsBundleId(TenantId.SYS_TENANT_ID.getId(), this.widgetsBundle.getUuidId(), true, DeprecatedFilter.ALL, Collections.singletonList("latest"), new PageLink(1024, 0, "TYPE_DESCRIPTION", new SortOrder("createdTime")));
        Assert.assertEquals((long)2L, (long)widgetTypes.getData().size());
        for (WidgetTypeInfo widgetType : widgetTypes.getData()) {
            Assert.assertFalse((String)"Bundles should not be empty", (boolean)widgetType.getBundles().isEmpty());
            Assert.assertEquals((Object)"BUNDLE_ALIAS", (Object)((WidgetBundleInfo)widgetType.getBundles().get(0)).getName());
        }
    }

    @Test
    public void testAddWidgetTypeToNewBundleAndVerifyBundles() {
        String newBundleTitle = "New Bundle Title";
        WidgetsBundle newWidgetsBundle = new WidgetsBundle();
        newWidgetsBundle.setAlias("NewBundle");
        newWidgetsBundle.setTitle(newBundleTitle);
        newWidgetsBundle.setId((UUIDBased)new WidgetsBundleId(UUID.randomUUID()));
        newWidgetsBundle.setTenantId(TenantId.SYS_TENANT_ID);
        newWidgetsBundle = this.widgetsBundleDao.save(TenantId.SYS_TENANT_ID, newWidgetsBundle);
        for (int i = 0; i < this.widgetTypeList.size(); ++i) {
            WidgetTypeInfo widgetType = this.widgetTypeList.get(i);
            this.widgetTypeDao.saveWidgetsBundleWidget(new WidgetsBundleWidget(newWidgetsBundle.getId(), widgetType.getId(), i));
        }
        PageData widgetTypes = this.widgetTypeDao.findWidgetTypesInfosByWidgetsBundleId(TenantId.SYS_TENANT_ID.getId(), newWidgetsBundle.getUuidId(), true, DeprecatedFilter.ALL, Collections.singletonList("latest"), new PageLink(1024, 0, "TYPE_DESCRIPTION", new SortOrder("createdTime")));
        Assert.assertEquals((long)2L, (long)widgetTypes.getData().size());
        WidgetTypeInfo widgetTypeInfo1 = (WidgetTypeInfo)widgetTypes.getData().get(0);
        WidgetTypeInfo widgetTypeInfo2 = (WidgetTypeInfo)widgetTypes.getData().get(1);
        Assert.assertEquals((long)2L, (long)widgetTypeInfo1.getBundles().size());
        Assert.assertTrue((String)"Bundles should contain 'BUNDLE_ALIAS'", (boolean)widgetTypeInfo1.getBundles().stream().anyMatch(bundle -> "BUNDLE_ALIAS".equals(bundle.getName())));
        Assert.assertTrue((String)"Bundles should contain 'New Bundle Title'", (boolean)widgetTypeInfo1.getBundles().stream().anyMatch(bundle -> newBundleTitle.equals(bundle.getName())));
        Assert.assertEquals((long)2L, (long)widgetTypeInfo2.getBundles().size());
        Assert.assertTrue((String)"Bundles should contain 'BUNDLE_ALIAS'", (boolean)widgetTypeInfo2.getBundles().stream().anyMatch(bundle -> "BUNDLE_ALIAS".equals(bundle.getName())));
        Assert.assertTrue((String)"Bundles should contain 'New Bundle Title'", (boolean)widgetTypeInfo2.getBundles().stream().anyMatch(bundle -> newBundleTitle.equals(bundle.getName())));
        this.widgetsBundleDao.removeById(newWidgetsBundle.getTenantId(), newWidgetsBundle.getUuidId());
        widgetTypes = this.widgetTypeDao.findWidgetTypesInfosByWidgetsBundleId(TenantId.SYS_TENANT_ID.getId(), newWidgetsBundle.getUuidId(), true, DeprecatedFilter.ALL, Collections.singletonList("latest"), new PageLink(1024, 0, "TYPE_DESCRIPTION", new SortOrder("createdTime")));
        widgetTypes.getData().forEach(widgetTypeInfo -> Assert.assertEquals((long)1L, (long)widgetTypeInfo.getBundles().size()));
    }

    private WidgetTypeDetails saveWidgetType(TenantId tenantId, String name) {
        WidgetTypeDetails widgetType = new WidgetTypeDetails();
        widgetType.setTenantId(tenantId);
        widgetType.setDescription("WIDGET_TYPE_DESCRIPTION" + StringUtils.randomAlphabetic((int)7));
        widgetType.setName(name);
        ObjectNode descriptor = JacksonUtil.newObjectNode();
        descriptor.put("type", "static");
        widgetType.setDescriptor((JsonNode)descriptor);
        return this.widgetTypeDao.save(TenantId.SYS_TENANT_ID, widgetType);
    }
}

