/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.user;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.data.Index;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.testcontainers.shaded.org.apache.commons.lang3.RandomStringUtils;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.common.data.settings.UserSettings;
import org.thingsboard.server.common.data.settings.UserSettingsCompositeKey;
import org.thingsboard.server.common.data.settings.UserSettingsType;
import org.thingsboard.server.dao.AbstractJpaDaoTest;
import org.thingsboard.server.dao.model.ModelConstants;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.user.UserDao;
import org.thingsboard.server.dao.user.UserSettingsDao;

public class JpaUserSettingsDaoTest
extends AbstractJpaDaoTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JpaUserSettingsDaoTest.class);
    private UUID tenantId;
    private User user;
    @Autowired
    private UserSettingsDao userSettingsDao;
    @Autowired
    private UserDao userDao;

    @Before
    public void setUp() {
        this.tenantId = Uuids.timeBased();
        this.user = this.saveUser(this.tenantId, Uuids.timeBased());
    }

    @After
    public void tearDown() {
        this.userDao.removeById(this.user.getTenantId(), this.user.getUuidId());
    }

    @Test
    public void testFindSettingsByUserId() {
        UserSettings userSettings = this.createUserSettings(this.user.getId());
        UserSettings retrievedUserSettings = this.userSettingsDao.findById(AbstractServiceTest.SYSTEM_TENANT_ID, new UserSettingsCompositeKey(this.user.getId().getId(), UserSettingsType.GENERAL.name()));
        Assert.assertEquals((Object)retrievedUserSettings.getSettings(), (Object)userSettings.getSettings());
        this.userSettingsDao.removeById(AbstractServiceTest.SYSTEM_TENANT_ID, new UserSettingsCompositeKey(this.user.getId().getId(), UserSettingsType.GENERAL.name()));
        UserSettings retrievedUserSettings2 = this.userSettingsDao.findById(AbstractServiceTest.SYSTEM_TENANT_ID, new UserSettingsCompositeKey(this.user.getId().getId(), UserSettingsType.GENERAL.name()));
        Assert.assertNull((Object)retrievedUserSettings2);
    }

    @Test
    public void testFindByTypeAndJsonPath() {
        UserSettings userSettings = this.createUserSettings(this.user.getId());
        log.warn("userSettings {}", (Object)userSettings);
        userSettings.setSettings(JacksonUtil.toJsonNode((String)"{\"text\":\"bla1\",\"sessions\":{\"tenantFcmToken\":{\"fcmTokenTimestamp\":0}}}"));
        this.userSettingsDao.save(AbstractServiceTest.SYSTEM_TENANT_ID, userSettings);
        ((ListAssert)((ListAssert)Assertions.assertThat((List)this.userSettingsDao.findByTypeAndPath(AbstractServiceTest.SYSTEM_TENANT_ID, UserSettingsType.GENERAL, new String[]{"text"})).isNotEmpty()).hasSize(1)).contains((Object)userSettings, Index.atIndex((int)0));
        ((ListAssert)((ListAssert)Assertions.assertThat((List)this.userSettingsDao.findByTypeAndPath(AbstractServiceTest.SYSTEM_TENANT_ID, UserSettingsType.GENERAL, new String[]{"sessions", "tenantFcmToken"})).isNotEmpty()).hasSize(1)).contains((Object)userSettings, Index.atIndex((int)0));
        Assertions.assertThat((List)this.userSettingsDao.findByTypeAndPath(this.user.getTenantId(), UserSettingsType.GENERAL, new String[]{"mistery"})).isEmpty();
        Assertions.assertThat((List)this.userSettingsDao.findByTypeAndPath(this.user.getTenantId(), UserSettingsType.GENERAL, new String[]{"text", "text"})).isEmpty();
        Assertions.assertThat((List)this.userSettingsDao.findByTypeAndPath(this.user.getTenantId(), UserSettingsType.GENERAL, new String[]{"text", "lvl2"})).isEmpty();
        Assertions.assertThat((List)this.userSettingsDao.findByTypeAndPath(this.user.getTenantId(), UserSettingsType.MOBILE, new String[]{"text"})).isEmpty();
        Assertions.assertThat((List)this.userSettingsDao.findByTypeAndPath(this.user.getTenantId(), UserSettingsType.MOBILE, new String[]{"sessions", "1"})).isEmpty();
        Assertions.assertThat((List)this.userSettingsDao.findByTypeAndPath(this.user.getTenantId(), UserSettingsType.MOBILE, new String[]{"text", "text"})).isEmpty();
        Assertions.assertThat((List)this.userSettingsDao.findByTypeAndPath(this.user.getTenantId(), UserSettingsType.MOBILE, new String[]{""})).isEmpty();
        Assertions.assertThat((List)this.userSettingsDao.findByTypeAndPath(this.user.getTenantId(), UserSettingsType.MOBILE, null)).isEmpty();
        Assertions.assertThat((List)this.userSettingsDao.findByTypeAndPath(this.user.getTenantId(), UserSettingsType.MOBILE, new String[0])).isEmpty();
    }

    private UserSettings createUserSettings(UserId userId) {
        UserSettings userSettings = new UserSettings();
        userSettings.setType(UserSettingsType.GENERAL);
        userSettings.setSettings((JsonNode)JacksonUtil.newObjectNode().put("text", RandomStringUtils.randomAlphanumeric((int)10)));
        userSettings.setUserId(userId);
        return this.userSettingsDao.save(AbstractServiceTest.SYSTEM_TENANT_ID, userSettings);
    }

    private User saveUser(UUID tenantId, UUID customerId) {
        User user = new User();
        UUID id = Uuids.timeBased();
        user.setId((UUIDBased)new UserId(id));
        user.setTenantId(TenantId.fromUUID((UUID)tenantId));
        user.setCustomerId(new CustomerId(customerId));
        if (customerId == ModelConstants.NULL_UUID) {
            user.setAuthority(Authority.TENANT_ADMIN);
        } else {
            user.setAuthority(Authority.CUSTOMER_USER);
        }
        String idString = id.toString();
        String email = idString.substring(0, idString.indexOf(45)) + "@thingsboard.org";
        user.setEmail(email);
        return this.userDao.save(AbstractServiceTest.SYSTEM_TENANT_ID, user);
    }
}

