/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.user;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.User;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.security.Authority;
import org.thingsboard.server.dao.AbstractJpaDaoTest;
import org.thingsboard.server.dao.model.ModelConstants;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.user.UserDao;

public class JpaUserDaoTest
extends AbstractJpaDaoTest {
    final int COUNT_CREATED_USER = 1;
    final int COUNT_SYSADMIN_USER = 90;
    UUID tenantId;
    UUID customerId;
    @Autowired
    private UserDao userDao;

    @Before
    public void setUp() {
        this.tenantId = Uuids.timeBased();
        this.customerId = Uuids.timeBased();
        this.create30TenantAdminsAnd60CustomerUsers(this.tenantId, this.customerId);
    }

    @After
    public void tearDown() {
        this.delete30TenantAdminsAnd60CustomerUsers(this.tenantId, this.customerId);
    }

    @Test
    public void testFindAll() {
        List users = this.userDao.find(AbstractServiceTest.SYSTEM_TENANT_ID);
        Assert.assertEquals((long)users.size(), (long)91L);
    }

    @Test
    public void testFindByEmail() throws JsonProcessingException {
        User user = new User();
        user.setId((UUIDBased)new UserId(UUID.randomUUID()));
        user.setTenantId(TenantId.fromUUID((UUID)UUID.randomUUID()));
        user.setCustomerId(new CustomerId(UUID.randomUUID()));
        user.setEmail("user@thingsboard.org");
        user.setFirstName("Jackson");
        user.setLastName("Roberts");
        String additionalInfo = "{\"key\":\"value-100\"}";
        JsonNode jsonNode = JacksonUtil.toJsonNode((String)additionalInfo);
        user.setAdditionalInfo(jsonNode);
        this.userDao.save(AbstractServiceTest.SYSTEM_TENANT_ID, user);
        Assert.assertEquals((long)92L, (long)this.userDao.find(AbstractServiceTest.SYSTEM_TENANT_ID).size());
        User savedUser = this.userDao.findByEmail(AbstractServiceTest.SYSTEM_TENANT_ID, "user@thingsboard.org");
        Assert.assertNotNull((Object)savedUser);
        Assert.assertEquals((Object)additionalInfo, (Object)savedUser.getAdditionalInfo().toString());
    }

    @Test
    public void testFindTenantAdmins() {
        PageLink pageLink = new PageLink(20);
        PageData tenantAdmins1 = this.userDao.findTenantAdmins(this.tenantId, pageLink);
        Assert.assertEquals((long)20L, (long)tenantAdmins1.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData tenantAdmins2 = this.userDao.findTenantAdmins(this.tenantId, pageLink);
        Assert.assertEquals((long)10L, (long)tenantAdmins2.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData tenantAdmins3 = this.userDao.findTenantAdmins(this.tenantId, pageLink);
        Assert.assertEquals((long)0L, (long)tenantAdmins3.getData().size());
    }

    @Test
    public void testFindCustomerUsers() {
        PageLink pageLink = new PageLink(40);
        PageData customerUsers1 = this.userDao.findCustomerUsers(this.tenantId, this.customerId, pageLink);
        Assert.assertEquals((long)40L, (long)customerUsers1.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData customerUsers2 = this.userDao.findCustomerUsers(this.tenantId, this.customerId, pageLink);
        Assert.assertEquals((long)20L, (long)customerUsers2.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData customerUsers3 = this.userDao.findCustomerUsers(this.tenantId, this.customerId, pageLink);
        Assert.assertEquals((long)0L, (long)customerUsers3.getData().size());
    }

    private void create30TenantAdminsAnd60CustomerUsers(UUID tenantId, UUID customerId) {
        for (int i = 0; i < 30; ++i) {
            this.saveUser(tenantId, ModelConstants.NULL_UUID);
            this.saveUser(tenantId, customerId);
            this.saveUser(tenantId, customerId);
        }
    }

    private void saveUser(UUID tenantId, UUID customerId) {
        User user = new User();
        UUID id = Uuids.timeBased();
        user.setId((UUIDBased)new UserId(id));
        user.setTenantId(TenantId.fromUUID((UUID)tenantId));
        user.setCustomerId(new CustomerId(customerId));
        if (customerId == ModelConstants.NULL_UUID) {
            user.setAuthority(Authority.TENANT_ADMIN);
        } else {
            user.setAuthority(Authority.CUSTOMER_USER);
        }
        String idString = id.toString();
        String email = idString.substring(0, idString.indexOf(45)) + "@thingsboard.org";
        user.setEmail(email);
        this.userDao.save(AbstractServiceTest.SYSTEM_TENANT_ID, user);
    }

    private void delete30TenantAdminsAnd60CustomerUsers(UUID tenantId, UUID customerId) {
        List data = this.userDao.findCustomerUsers(tenantId, customerId, new PageLink(60)).getData();
        data.addAll(this.userDao.findTenantAdmins(tenantId, new PageLink(30)).getData());
        for (User user : data) {
            this.userDao.removeById(user.getTenantId(), user.getUuidId());
        }
    }
}

