/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.user;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.security.UserCredentials;
import org.thingsboard.server.dao.AbstractJpaDaoTest;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.user.UserCredentialsDao;

public class JpaUserCredentialsDaoTest
extends AbstractJpaDaoTest {
    public static final String ACTIVATE_TOKEN = "ACTIVATE_TOKEN_0";
    public static final String RESET_TOKEN = "RESET_TOKEN_0";
    public static final int COUNT_USER_CREDENTIALS = 2;
    List<UserCredentials> userCredentialsList;
    UserCredentials neededUserCredentials;
    @Autowired
    private UserCredentialsDao userCredentialsDao;

    @Before
    public void setUp() {
        this.userCredentialsList = new ArrayList<UserCredentials>();
        for (int i = 0; i < 2; ++i) {
            this.userCredentialsList.add(this.createUserCredentials(i));
        }
        this.neededUserCredentials = this.userCredentialsList.get(0);
        Assert.assertNotNull((Object)this.neededUserCredentials);
    }

    UserCredentials createUserCredentials(int number) {
        UserCredentials userCredentials = new UserCredentials();
        userCredentials.setEnabled(true);
        userCredentials.setUserId(new UserId(UUID.randomUUID()));
        userCredentials.setPassword("password");
        userCredentials.setActivateToken("ACTIVATE_TOKEN_" + number);
        userCredentials.setActivateTokenExpTime(Long.valueOf(123L));
        userCredentials.setResetToken("RESET_TOKEN_" + number);
        userCredentials.setResetTokenExpTime(Long.valueOf(321L));
        return this.userCredentialsDao.save(AbstractServiceTest.SYSTEM_TENANT_ID, userCredentials);
    }

    @After
    public void after() {
        for (UserCredentials userCredentials : this.userCredentialsList) {
            this.userCredentialsDao.removeById(TenantId.SYS_TENANT_ID, userCredentials.getUuidId());
        }
    }

    @Test
    public void testFindAll() {
        List userCredentials = this.userCredentialsDao.find(AbstractServiceTest.SYSTEM_TENANT_ID);
        Assert.assertEquals((long)3L, (long)userCredentials.size());
    }

    @Test
    public void testFindByUserId() {
        UserCredentials foundedUserCredentials = this.userCredentialsDao.findByUserId(AbstractServiceTest.SYSTEM_TENANT_ID, this.neededUserCredentials.getUserId().getId());
        Assert.assertNotNull((Object)foundedUserCredentials);
        Assert.assertEquals((Object)this.neededUserCredentials, (Object)foundedUserCredentials);
    }

    @Test
    public void testFindByActivateToken() {
        UserCredentials foundedUserCredentials = this.userCredentialsDao.findByActivateToken(AbstractServiceTest.SYSTEM_TENANT_ID, ACTIVATE_TOKEN);
        Assert.assertNotNull((Object)foundedUserCredentials);
        Assert.assertEquals((Object)this.neededUserCredentials.getId(), (Object)foundedUserCredentials.getId());
    }

    @Test
    public void testFindByResetToken() {
        UserCredentials foundedUserCredentials = this.userCredentialsDao.findByResetToken(AbstractServiceTest.SYSTEM_TENANT_ID, RESET_TOKEN);
        Assert.assertNotNull((Object)foundedUserCredentials);
        Assert.assertEquals((Object)this.neededUserCredentials.getId(), (Object)foundedUserCredentials.getId());
    }
}

