/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.tenant;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.AbstractJpaDaoTest;
import org.thingsboard.server.dao.service.AbstractServiceTest;
import org.thingsboard.server.dao.service.TenantProfileServiceTest;
import org.thingsboard.server.dao.tenant.TenantDao;
import org.thingsboard.server.dao.tenant.TenantProfileDao;

public class JpaTenantDaoTest
extends AbstractJpaDaoTest {
    @Autowired
    private TenantDao tenantDao;
    @Autowired
    private TenantProfileDao tenantProfileDao;
    List<Tenant> createdTenants = new ArrayList<Tenant>();
    TenantProfile tenantProfile;

    @Before
    public void setUp() throws Exception {
        this.tenantProfile = this.tenantProfileDao.save(TenantId.SYS_TENANT_ID, TenantProfileServiceTest.createTenantProfile("default tenant profile"));
        ((ObjectAssert)Assertions.assertThat((Object)this.tenantProfile).as("tenant profile", new Object[0])).isNotNull();
    }

    @After
    public void tearDown() throws Exception {
        this.createdTenants.forEach(tenant -> this.tenantDao.removeById(TenantId.SYS_TENANT_ID, tenant.getUuidId()));
        this.tenantProfileDao.removeById(TenantId.SYS_TENANT_ID, this.tenantProfile.getUuidId());
    }

    @Test
    public void testFindTenants() {
        this.createTenants();
        Assert.assertEquals((long)30L, (long)this.tenantDao.find(AbstractServiceTest.SYSTEM_TENANT_ID).size());
        PageLink pageLink = new PageLink(20, 0, "title");
        PageData tenants1 = this.tenantDao.findTenants(AbstractServiceTest.SYSTEM_TENANT_ID, pageLink);
        Assert.assertEquals((long)20L, (long)tenants1.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData tenants2 = this.tenantDao.findTenants(AbstractServiceTest.SYSTEM_TENANT_ID, pageLink);
        Assert.assertEquals((long)10L, (long)tenants2.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData tenants3 = this.tenantDao.findTenants(AbstractServiceTest.SYSTEM_TENANT_ID, pageLink);
        Assert.assertEquals((long)0L, (long)tenants3.getData().size());
    }

    private void createTenants() {
        for (int i = 0; i < 30; ++i) {
            this.createTenant("TITLE", i);
        }
    }

    void createTenant(String title, int index) {
        Tenant tenant = new Tenant();
        tenant.setId((UUIDBased)TenantId.fromUUID((UUID)Uuids.timeBased()));
        tenant.setTitle(title + "_" + index);
        tenant.setTenantProfileId(this.tenantProfile.getId());
        this.createdTenants.add(this.tenantDao.save(TenantId.SYS_TENANT_ID, tenant));
    }

    @Test
    public void testIsExistsTenantById() {
        UUID uuid = Uuids.timeBased();
        TenantId tenantId = new TenantId(uuid);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.tenantDao.existsById(tenantId, uuid)).as("Is tenant exists before save", new Object[0])).isFalse();
        Tenant tenant = new Tenant();
        tenant.setId((UUIDBased)tenantId);
        tenant.setTitle("Tenant " + String.valueOf(uuid));
        tenant.setTenantProfileId(this.tenantProfile.getId());
        this.createdTenants.add(this.tenantDao.save(TenantId.SYS_TENANT_ID, tenant));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)this.tenantDao.existsById(tenantId, uuid)).as("Is tenant exists after save", new Object[0])).isTrue();
    }
}

