/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.rule;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.id.RuleChainId;
import org.thingsboard.server.common.data.id.RuleNodeId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.common.data.rule.RuleChain;
import org.thingsboard.server.common.data.rule.RuleNode;
import org.thingsboard.server.dao.AbstractJpaDaoTest;
import org.thingsboard.server.dao.rule.RuleChainDao;
import org.thingsboard.server.dao.rule.RuleNodeDao;

public class JpaRuleNodeDaoTest
extends AbstractJpaDaoTest {
    public static final int COUNT = 40;
    public static final String PREFIX_FOR_RULE_NODE_NAME = "SEARCH_TEXT_";
    List<UUID> ruleNodeIds;
    TenantId tenantId1;
    TenantId tenantId2;
    RuleChainId ruleChainId1;
    RuleChainId ruleChainId2;
    @Autowired
    private RuleChainDao ruleChainDao;
    @Autowired
    private RuleNodeDao ruleNodeDao;
    ListeningExecutorService executor;

    @Before
    public void setUp() {
        this.tenantId1 = TenantId.fromUUID((UUID)Uuids.timeBased());
        this.ruleChainId1 = new RuleChainId(UUID.randomUUID());
        this.tenantId2 = TenantId.fromUUID((UUID)Uuids.timeBased());
        this.ruleChainId2 = new RuleChainId(UUID.randomUUID());
        this.ruleNodeIds = this.createRuleNodes(this.tenantId1, this.tenantId2, this.ruleChainId1, this.ruleChainId2, 40);
    }

    @After
    public void tearDown() throws Exception {
        this.ruleNodeDao.removeAllByIds(this.ruleNodeIds);
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Test
    public void testSaveRuleName0x00_thenSomeDatabaseException() {
        RuleNode ruleNode = this.getRuleNode(this.ruleChainId1, "T", "\u0000");
        Assertions.assertThatThrownBy(() -> this.ruleNodeIds.add(((RuleNode)this.ruleNodeDao.save(this.tenantId1, (Object)ruleNode)).getUuidId()));
    }

    @Test
    public void testFindRuleNodesByTenantIdAndType() {
        List ruleNodes1 = this.ruleNodeDao.findRuleNodesByTenantIdAndType(this.tenantId1, "A", PREFIX_FOR_RULE_NODE_NAME);
        Assert.assertEquals((long)20L, (long)ruleNodes1.size());
        List ruleNodes2 = this.ruleNodeDao.findRuleNodesByTenantIdAndType(this.tenantId2, "B", PREFIX_FOR_RULE_NODE_NAME);
        Assert.assertEquals((long)20L, (long)ruleNodes2.size());
        ruleNodes1 = this.ruleNodeDao.findRuleNodesByTenantIdAndType(this.tenantId1, "A", null);
        Assert.assertEquals((long)20L, (long)ruleNodes1.size());
        ruleNodes2 = this.ruleNodeDao.findRuleNodesByTenantIdAndType(this.tenantId2, "B", null);
        Assert.assertEquals((long)20L, (long)ruleNodes2.size());
    }

    @Test
    public void testFindRuleNodesByType() {
        PageData ruleNodes = this.ruleNodeDao.findAllRuleNodesByType("A", new PageLink(10, 0, PREFIX_FOR_RULE_NODE_NAME));
        Assert.assertEquals((long)20L, (long)ruleNodes.getTotalElements());
        Assert.assertEquals((long)2L, (long)ruleNodes.getTotalPages());
        Assert.assertEquals((long)10L, (long)ruleNodes.getData().size());
        ruleNodes = this.ruleNodeDao.findAllRuleNodesByType("A", new PageLink(10, 0));
        Assert.assertEquals((long)20L, (long)ruleNodes.getTotalElements());
        Assert.assertEquals((long)2L, (long)ruleNodes.getTotalPages());
        Assert.assertEquals((long)10L, (long)ruleNodes.getData().size());
    }

    @Test
    public void testFindRuleNodesByTypeAndVersionLessThan() {
        PageData ruleNodes = this.ruleNodeDao.findAllRuleNodesByTypeAndVersionLessThan("A", 1, new PageLink(10, 0, PREFIX_FOR_RULE_NODE_NAME));
        Assert.assertEquals((long)20L, (long)ruleNodes.getTotalElements());
        Assert.assertEquals((long)2L, (long)ruleNodes.getTotalPages());
        Assert.assertEquals((long)10L, (long)ruleNodes.getData().size());
        ruleNodes = this.ruleNodeDao.findAllRuleNodesByTypeAndVersionLessThan("A", 1, new PageLink(10, 0));
        Assert.assertEquals((long)20L, (long)ruleNodes.getTotalElements());
        Assert.assertEquals((long)2L, (long)ruleNodes.getTotalPages());
        Assert.assertEquals((long)10L, (long)ruleNodes.getData().size());
    }

    @Test
    public void testFindRuleNodeIdsByTypeAndVersionLessThan() {
        PageData ruleNodeIds = this.ruleNodeDao.findAllRuleNodeIdsByTypeAndVersionLessThan("A", 1, new PageLink(10, 0, PREFIX_FOR_RULE_NODE_NAME));
        Assert.assertEquals((long)0L, (long)ruleNodeIds.getTotalElements());
        Assert.assertEquals((long)0L, (long)ruleNodeIds.getTotalPages());
        Assert.assertEquals((long)10L, (long)ruleNodeIds.getData().size());
        ruleNodeIds = this.ruleNodeDao.findAllRuleNodeIdsByTypeAndVersionLessThan("A", 1, new PageLink(10, 0));
        Assert.assertEquals((long)0L, (long)ruleNodeIds.getTotalElements());
        Assert.assertEquals((long)0L, (long)ruleNodeIds.getTotalPages());
        Assert.assertEquals((long)10L, (long)ruleNodeIds.getData().size());
    }

    @Test
    public void testFindAllRuleNodeByIds() {
        List fromUUIDs = this.ruleNodeIds.stream().map(RuleNodeId::new).collect(Collectors.toList());
        List ruleNodes = this.ruleNodeDao.findAllRuleNodeByIds(fromUUIDs);
        Assert.assertEquals((long)40L, (long)ruleNodes.size());
    }

    private List<UUID> createRuleNodes(TenantId tenantId1, TenantId tenantId2, RuleChainId ruleChainId1, RuleChainId ruleChainId2, int count) {
        return this.createRuleNodes(tenantId1, tenantId2, ruleChainId1, ruleChainId2, "A", "B", count);
    }

    private List<UUID> createRuleNodes(TenantId tenantId1, TenantId tenantId2, RuleChainId ruleChainId1, RuleChainId ruleChainId2, String typeA, String typeB, int count) {
        RuleChain chain1 = new RuleChain(ruleChainId1);
        chain1.setTenantId(tenantId1);
        chain1.setName(ruleChainId1.toString());
        this.ruleChainDao.save(tenantId1, (Object)chain1);
        RuleChain chain2 = new RuleChain(ruleChainId2);
        chain2.setTenantId(tenantId2);
        chain2.setName(ruleChainId2.toString());
        this.ruleChainDao.save(tenantId2, (Object)chain2);
        ArrayList<UUID> savedRuleNodeIds = new ArrayList<UUID>();
        for (int i = 0; i < count / 2; ++i) {
            savedRuleNodeIds.add(((RuleNode)this.ruleNodeDao.save(tenantId1, (Object)this.getRuleNode(ruleChainId1, typeA, Integer.toString(i)))).getUuidId());
            savedRuleNodeIds.add(((RuleNode)this.ruleNodeDao.save(tenantId2, (Object)this.getRuleNode(ruleChainId2, typeB, Integer.toString(i + count / 2)))).getUuidId());
        }
        return savedRuleNodeIds;
    }

    private RuleNode getRuleNode(RuleChainId ruleChainId, String type, String nameSuffix) {
        return this.getRuleNode(ruleChainId, Uuids.timeBased(), type, nameSuffix);
    }

    private RuleNode getRuleNode(RuleChainId ruleChainId, UUID ruleNodeId, String type, String nameSuffix) {
        RuleNode ruleNode = new RuleNode();
        ruleNode.setId((UUIDBased)new RuleNodeId(ruleNodeId));
        ruleNode.setRuleChainId(ruleChainId);
        ruleNode.setName(nameSuffix);
        ruleNode.setType(type);
        ruleNode.setConfiguration((JsonNode)JacksonUtil.newObjectNode().put("searchHint", PREFIX_FOR_RULE_NODE_NAME + nameSuffix));
        ruleNode.setConfigurationVersion(0);
        return ruleNode;
    }
}

