/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.rpc;

import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.rpc.Rpc;
import org.thingsboard.server.common.data.rpc.RpcStatus;
import org.thingsboard.server.dao.AbstractJpaDaoTest;
import org.thingsboard.server.dao.sql.rpc.JpaRpcDao;

public class JpaRpcDaoTest
extends AbstractJpaDaoTest {
    @Autowired
    JpaRpcDao rpcDao;

    @Test
    public void deleteOutdated() {
        Rpc rpc = new Rpc();
        rpc.setTenantId(TenantId.SYS_TENANT_ID);
        rpc.setDeviceId(new DeviceId(UUID.randomUUID()));
        rpc.setStatus(RpcStatus.QUEUED);
        rpc.setRequest(JacksonUtil.toJsonNode((String)"{}"));
        this.rpcDao.saveAndFlush(rpc.getTenantId(), (Object)rpc);
        rpc.setId(null);
        this.rpcDao.saveAndFlush(rpc.getTenantId(), (Object)rpc);
        TenantId tenantId = TenantId.fromUUID((UUID)UUID.fromString("3d193a7a-774b-4c05-84d5-f7fdcf7a37cf"));
        rpc.setId(null);
        rpc.setTenantId(tenantId);
        rpc.setDeviceId(new DeviceId(UUID.randomUUID()));
        this.rpcDao.saveAndFlush(rpc.getTenantId(), (Object)rpc);
        Assertions.assertThat((int)this.rpcDao.deleteOutdatedRpcByTenantId(TenantId.SYS_TENANT_ID, Long.valueOf(0L))).isEqualTo(0);
        Assertions.assertThat((int)this.rpcDao.deleteOutdatedRpcByTenantId(TenantId.SYS_TENANT_ID, Long.valueOf(Long.MAX_VALUE))).isEqualTo(2);
        Assertions.assertThat((int)this.rpcDao.deleteOutdatedRpcByTenantId(tenantId, Long.valueOf(System.currentTimeMillis() + 1L))).isEqualTo(1);
    }
}

