/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.query;

import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.test.context.junit4.SpringRunner;
import org.thingsboard.server.common.data.EntityType;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.permission.QueryContext;
import org.thingsboard.server.dao.sql.query.DefaultQueryLogComponent;
import org.thingsboard.server.dao.sql.query.SqlQueryContext;

@RunWith(value=SpringRunner.class)
@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(classes={DefaultQueryLogComponent.class})
@EnableConfigurationProperties
@TestPropertySource(properties={"sql.log_queries=true", "sql.log_queries_threshold:2999"})
public class DefaultQueryLogComponentTest {
    private TenantId tenantId;
    private SqlQueryContext ctx;
    @SpyBean
    private DefaultQueryLogComponent queryLog;

    @Before
    public void setUp() {
        this.tenantId = new TenantId(UUID.fromString("97275c1c-9cf2-4d25-a68d-933031158f84"));
        this.ctx = new SqlQueryContext(new QueryContext(this.tenantId, null, EntityType.ALARM));
    }

    @Test
    public void logQuery() {
        ((DefaultQueryLogComponent)BDDMockito.willReturn((Object)"").given((Object)this.queryLog)).substituteParametersInSqlString("", (SqlParameterSource)this.ctx);
        this.queryLog.logQuery(this.ctx, "", 3000L);
        ((DefaultQueryLogComponent)Mockito.verify((Object)this.queryLog, (VerificationMode)Mockito.times((int)1))).substituteParametersInSqlString("", (SqlParameterSource)this.ctx);
    }

    @Test
    public void substituteParametersInSqlString_StringType() {
        String sql = "Select * from Table Where name = :name AND id = :id";
        String sqlToUse = "Select * from Table Where name = 'Mery''s' AND id = 'ID_1'";
        this.ctx.addStringParameter("name", "Mery's");
        this.ctx.addStringParameter("id", "ID_1");
        String sqlToUseResult = this.queryLog.substituteParametersInSqlString(sql, (SqlParameterSource)this.ctx);
        Assert.assertEquals((Object)sqlToUse, (Object)sqlToUseResult);
    }

    @Test
    public void substituteParametersInSqlString_DoubleLongType() {
        double sum = 2.1E-7;
        long price = 100000L;
        String sql = "Select * from Table Where sum = :sum AND price = :price";
        String sqlToUse = "Select * from Table Where sum = 2.1E-7 AND price = 100000";
        this.ctx.addDoubleParameter("sum", sum);
        this.ctx.addLongParameter("price", price);
        String sqlToUseResult = this.queryLog.substituteParametersInSqlString(sql, (SqlParameterSource)this.ctx);
        Assert.assertEquals((Object)sqlToUse, (Object)sqlToUseResult);
    }

    @Test
    public void substituteParametersInSqlString_BooleanType() {
        String sql = "Select * from Table Where check = :check AND mark = :mark";
        String sqlToUse = "Select * from Table Where check = true AND mark = false";
        this.ctx.addBooleanParameter("check", true);
        this.ctx.addBooleanParameter("mark", false);
        String sqlToUseResult = this.queryLog.substituteParametersInSqlString(sql, (SqlParameterSource)this.ctx);
        Assert.assertEquals((Object)sqlToUse, (Object)sqlToUseResult);
    }

    @Test
    public void substituteParametersInSqlString_UuidType() {
        UUID guid = UUID.randomUUID();
        String sql = "Select * from Table Where guid = :guid";
        String sqlToUse = "Select * from Table Where guid = '" + String.valueOf(guid) + "'";
        this.ctx.addUuidParameter("guid", guid);
        String sqlToUseResult = this.queryLog.substituteParametersInSqlString(sql, (SqlParameterSource)this.ctx);
        Assert.assertEquals((Object)sqlToUse, (Object)sqlToUseResult);
    }

    @Test
    public void substituteParametersInSqlString_StringListType() {
        List<String> ids = List.of("ID_1'", "ID_2", "ID_3", "ID_4");
        String sql = "Select * from Table Where id IN (:ids)";
        String sqlToUse = "Select * from Table Where id IN ('ID_1''', 'ID_2', 'ID_3', 'ID_4')";
        this.ctx.addStringListParameter("ids", ids);
        String sqlToUseResult = this.queryLog.substituteParametersInSqlString(sql, (SqlParameterSource)this.ctx);
        Assert.assertEquals((Object)sqlToUse, (Object)sqlToUseResult);
    }

    @Test
    public void substituteParametersInSqlString_UuidListType() {
        List<UUID> guids = List.of(UUID.fromString("634a8d03-6871-4e01-94d0-876bf3e67dff"), UUID.fromString("3adbb5b8-4dc6-4faf-80dc-681a7b518b5e"), UUID.fromString("63a50f0c-2058-4d1d-8f15-812eb7f84412"));
        String sql = "Select * from Table Where guid IN (:guids)";
        String sqlToUse = "Select * from Table Where guid IN ('634a8d03-6871-4e01-94d0-876bf3e67dff', '3adbb5b8-4dc6-4faf-80dc-681a7b518b5e', '63a50f0c-2058-4d1d-8f15-812eb7f84412')";
        this.ctx.addUuidListParameter("guids", guids);
        String sqlToUseResult = this.queryLog.substituteParametersInSqlString(sql, (SqlParameterSource)this.ctx);
        Assert.assertEquals((Object)sqlToUse, (Object)sqlToUseResult);
    }
}

