/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.query;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.test.context.junit4.SpringRunner;
import org.springframework.transaction.support.TransactionTemplate;
import org.thingsboard.server.dao.sql.query.DefaultEntityQueryRepository;
import org.thingsboard.server.dao.sql.query.DefaultQueryLogComponent;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={DefaultEntityQueryRepository.class})
public class DefaultEntityQueryRepositoryTest {
    @MockBean
    NamedParameterJdbcTemplate jdbcTemplate;
    @MockBean
    TransactionTemplate transactionTemplate;
    @MockBean
    DefaultQueryLogComponent queryLog;
    @Autowired
    DefaultEntityQueryRepository repo;

    @Test
    public void givenDefaultMaxLevel_whenStaticConstant_thenEqualsTo() {
        MatcherAssert.assertThat((Object)this.repo.getMaxLevelAllowed(), (Matcher)Matchers.equalTo((Object)50));
    }

    @Test
    public void givenMaxLevelZeroOrNegative_whenGetMaxLevel_thenReturnDefaultMaxLevel() {
        MatcherAssert.assertThat((Object)this.repo.getMaxLevel(0), (Matcher)Matchers.equalTo((Object)this.repo.getMaxLevelAllowed()));
        MatcherAssert.assertThat((Object)this.repo.getMaxLevel(-1), (Matcher)Matchers.equalTo((Object)this.repo.getMaxLevelAllowed()));
        MatcherAssert.assertThat((Object)this.repo.getMaxLevel(-2), (Matcher)Matchers.equalTo((Object)this.repo.getMaxLevelAllowed()));
        MatcherAssert.assertThat((Object)this.repo.getMaxLevel(Integer.MIN_VALUE), (Matcher)Matchers.equalTo((Object)this.repo.getMaxLevelAllowed()));
    }

    @Test
    public void givenMaxLevelPositive_whenGetMaxLevel_thenValueTheSame() {
        MatcherAssert.assertThat((Object)this.repo.getMaxLevel(1), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)this.repo.getMaxLevel(2), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)this.repo.getMaxLevel(this.repo.getMaxLevelAllowed()), (Matcher)Matchers.equalTo((Object)this.repo.getMaxLevelAllowed()));
        MatcherAssert.assertThat((Object)this.repo.getMaxLevel(this.repo.getMaxLevelAllowed() + 1), (Matcher)Matchers.equalTo((Object)this.repo.getMaxLevelAllowed()));
        MatcherAssert.assertThat((Object)this.repo.getMaxLevel(Integer.MAX_VALUE), (Matcher)Matchers.equalTo((Object)this.repo.getMaxLevelAllowed()));
    }
}

