/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.event;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.event.Event;
import org.thingsboard.server.common.data.event.EventType;
import org.thingsboard.server.common.data.event.StatisticsEvent;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.dao.AbstractJpaDaoTest;
import org.thingsboard.server.dao.event.EventDao;
import org.thingsboard.server.dao.model.sql.RuleNodeDebugEventEntity;
import org.thingsboard.server.dao.sql.event.RuleNodeDebugEventRepository;

public class JpaBaseEventDaoTest
extends AbstractJpaDaoTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JpaBaseEventDaoTest.class);
    @Autowired
    private EventDao eventDao;
    @Autowired
    private RuleNodeDebugEventRepository ruleNodeDebugEventRepository;
    UUID tenantId = Uuids.timeBased();

    @Test
    public void findEvent() throws InterruptedException, ExecutionException, TimeoutException {
        UUID entityId = Uuids.timeBased();
        Event event1 = this.getStatsEvent(Uuids.timeBased(), this.tenantId, entityId);
        this.eventDao.saveAsync(event1).get(1L, TimeUnit.MINUTES);
        Thread.sleep(2L);
        Event event2 = this.getStatsEvent(Uuids.timeBased(), this.tenantId, entityId);
        this.eventDao.saveAsync(event2).get(1L, TimeUnit.MINUTES);
        List foundEvents = this.eventDao.findLatestEvents(this.tenantId, entityId, EventType.STATS, 1);
        Assert.assertNotNull((String)"Events expected to be not null", (Object)foundEvents);
        Assert.assertEquals((long)1L, (long)foundEvents.size());
        Assert.assertEquals((Object)event2, foundEvents.get(0));
    }

    @Test
    public void findEventsByEntityIdAndPageLink() throws Exception {
        UUID entityId1 = Uuids.timeBased();
        UUID entityId2 = Uuids.timeBased();
        long startTime = System.currentTimeMillis();
        Event event1 = this.getStatsEvent(Uuids.timeBased(), this.tenantId, entityId1);
        this.eventDao.saveAsync(event1).get(1L, TimeUnit.MINUTES);
        Thread.sleep(2L);
        Event event2 = this.getStatsEvent(Uuids.timeBased(), this.tenantId, entityId2);
        this.eventDao.saveAsync(event2).get(1L, TimeUnit.MINUTES);
        long endTime = System.currentTimeMillis();
        PageData events1 = this.eventDao.findEvents(this.tenantId, entityId1, EventType.STATS, new TimePageLink(30));
        Assert.assertEquals((long)1L, (long)events1.getData().size());
        PageData events2 = this.eventDao.findEvents(this.tenantId, entityId2, EventType.STATS, new TimePageLink(30));
        Assert.assertEquals((long)1L, (long)events2.getData().size());
        PageData events3 = this.eventDao.findEvents(this.tenantId, Uuids.timeBased(), EventType.STATS, new TimePageLink(30));
        Assert.assertEquals((long)0L, (long)events3.getData().size());
        TimePageLink pageLink2 = new TimePageLink(30, 0, "", null, Long.valueOf(startTime), null);
        PageData events12 = this.eventDao.findEvents(this.tenantId, entityId1, EventType.STATS, pageLink2);
        Assert.assertEquals((long)1L, (long)events12.getData().size());
        Assert.assertEquals((Object)event1, events12.getData().get(0));
        TimePageLink pageLink3 = new TimePageLink(30, 0, "", null, Long.valueOf(startTime), Long.valueOf(endTime));
        PageData events13 = this.eventDao.findEvents(this.tenantId, entityId1, EventType.STATS, pageLink3);
        Assert.assertEquals((long)1L, (long)events13.getData().size());
        Assert.assertEquals((Object)event1, events13.getData().get(0));
        TimePageLink pageLink4 = new TimePageLink(5, 0, "", null, Long.valueOf(startTime), Long.valueOf(endTime));
        PageData events14 = this.eventDao.findEvents(this.tenantId, entityId1, EventType.STATS, pageLink4);
        Assert.assertEquals((long)1L, (long)events14.getData().size());
        Assert.assertEquals((Object)event1, events14.getData().get(0));
        pageLink4 = pageLink4.nextPageLink();
        PageData events6 = this.eventDao.findEvents(this.tenantId, entityId1, EventType.STATS, pageLink4);
        Assert.assertEquals((long)0L, (long)events6.getData().size());
    }

    @Test
    public void findLatestDebugRuleNodeInEvent() throws Exception {
        UUID entityId = Uuids.timeBased();
        RuleNodeDebugEventEntity event = this.getDebugInEventEntity(Uuids.timeBased(), this.tenantId, entityId);
        this.eventDao.saveAsync((Event)event.toData()).get(1L, TimeUnit.MINUTES);
        Thread.sleep(2L);
        RuleNodeDebugEventEntity event2 = this.getDebugInEventEntity(Uuids.timeBased(), this.tenantId, entityId);
        this.eventDao.saveAsync((Event)event2.toData()).get(1L, TimeUnit.MINUTES);
        RuleNodeDebugEventEntity foundEvent = (RuleNodeDebugEventEntity)this.ruleNodeDebugEventRepository.findLatestDebugRuleNodeInEvent(this.tenantId, entityId).get();
        Assert.assertNotNull((String)"Events expected to be not null", (Object)foundEvent);
        Assert.assertEquals((Object)event2.getEventType(), (Object)foundEvent.getEventType());
        Assert.assertEquals((Object)event2.getId(), (Object)foundEvent.getId());
    }

    private Event getStatsEvent(UUID eventId, UUID tenantId, UUID entityId) {
        StatisticsEvent.StatisticsEventBuilder event = StatisticsEvent.builder();
        event.id(eventId);
        event.ts(System.currentTimeMillis());
        event.tenantId(new TenantId(tenantId));
        event.entityId(entityId);
        event.serviceId("server A");
        event.messagesProcessed(1L);
        event.errorsOccurred(0L);
        return event.build();
    }

    private RuleNodeDebugEventEntity getDebugInEventEntity(UUID eventId, UUID tenantId, UUID entityId) {
        RuleNodeDebugEventEntity event = new RuleNodeDebugEventEntity();
        event.setId(eventId);
        event.setEventType("IN");
        event.setEntityId(entityId);
        event.setTenantId(tenantId);
        return event;
    }
}

