/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.device;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.ThingsBoardThreadFactory;
import org.thingsboard.server.common.data.Device;
import org.thingsboard.server.common.data.DeviceProfile;
import org.thingsboard.server.common.data.DeviceProfileType;
import org.thingsboard.server.common.data.DeviceTransportType;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.AbstractJpaDaoTest;
import org.thingsboard.server.dao.device.DeviceDao;
import org.thingsboard.server.dao.device.DeviceProfileDao;

public class JpaDeviceDaoTest
extends AbstractJpaDaoTest {
    public static final int COUNT_DEVICES = 40;
    public static final String PREFIX_FOR_DEVICE_NAME = "SEARCH_TEXT_";
    List<UUID> deviceIds;
    UUID tenantId1;
    UUID tenantId2;
    UUID customerId1;
    UUID customerId2;
    @Autowired
    private DeviceDao deviceDao;
    @Autowired
    private DeviceProfileDao deviceProfileDao;
    private DeviceProfile savedDeviceProfile;
    ListeningExecutorService executor;

    @Before
    public void setUp() {
        this.createDeviceProfile();
        this.tenantId1 = Uuids.timeBased();
        this.customerId1 = Uuids.timeBased();
        this.tenantId2 = Uuids.timeBased();
        this.customerId2 = Uuids.timeBased();
        this.deviceIds = this.createDevices(this.tenantId1, this.tenantId2, this.customerId1, this.customerId2, 40);
    }

    private void createDeviceProfile() {
        DeviceProfile deviceProfile = new DeviceProfile();
        deviceProfile.setName("TEST");
        deviceProfile.setTenantId(TenantId.SYS_TENANT_ID);
        deviceProfile.setType(DeviceProfileType.DEFAULT);
        deviceProfile.setTransportType(DeviceTransportType.DEFAULT);
        deviceProfile.setDescription("Test");
        this.savedDeviceProfile = this.deviceProfileDao.save(TenantId.SYS_TENANT_ID, deviceProfile);
    }

    @After
    public void tearDown() throws Exception {
        this.deviceDao.removeAllByIds(this.deviceIds);
        this.deviceProfileDao.removeById(TenantId.SYS_TENANT_ID, this.savedDeviceProfile.getUuidId());
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Test
    public void testSaveDeviceName0x00_thenSomeDatabaseException() {
        Device device = this.getDevice(this.tenantId1, this.customerId1, "\u0000");
        Assertions.assertThatThrownBy(() -> this.deviceIds.add(this.saveDevice(this.tenantId1, device).getUuidId()));
    }

    @Test
    public void testSaveDevice_versionIncrement() {
        Device device = this.getDevice(this.tenantId1, this.customerId1, "1ewfewf2");
        device = this.saveDevice(this.tenantId1, device);
        this.deviceIds.add(device.getUuidId());
        Assertions.assertThat((Long)device.getVersion()).isEqualTo(1L);
        device.setName(device.getName() + "x");
        device = this.saveDevice(this.tenantId1, device);
        Assertions.assertThat((Long)device.getVersion()).isEqualTo(2L);
        device.setName(device.getName() + "x");
        device = this.saveDevice(this.tenantId1, device);
        Assertions.assertThat((Long)device.getVersion()).isEqualTo(3L);
    }

    @Test
    public void testSaveDevice_versionIncrement_noChanges() {
        Device device = this.getDevice(this.tenantId1, this.customerId1, "1ewfewf2");
        device = this.saveDevice(this.tenantId1, device);
        this.deviceIds.add(device.getUuidId());
        Assertions.assertThat((Long)device.getVersion()).isEqualTo(1L);
        device = this.saveDevice(this.tenantId1, device);
        Assertions.assertThat((Long)device.getVersion()).isEqualTo(2L);
        device = this.saveDevice(this.tenantId1, device);
        Assertions.assertThat((Long)device.getVersion()).isEqualTo(3L);
    }

    @Test
    public void testFindDevicesByTenantId() {
        PageLink pageLink = new PageLink(15, 0, PREFIX_FOR_DEVICE_NAME);
        PageData devices1 = this.deviceDao.findDevicesByTenantId(this.tenantId1, pageLink);
        Assert.assertEquals((long)15L, (long)devices1.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData devices2 = this.deviceDao.findDevicesByTenantId(this.tenantId1, pageLink);
        Assert.assertEquals((long)5L, (long)devices2.getData().size());
    }

    @Test
    public void testFindAsync() throws ExecutionException, InterruptedException, TimeoutException {
        UUID tenantId = Uuids.timeBased();
        UUID customerId = Uuids.timeBased();
        Device device = this.getDevice(tenantId, customerId, 40);
        this.deviceIds.add(this.saveDevice(tenantId, device).getUuidId());
        UUID uuid = device.getId().getId();
        Device entity = (Device)this.deviceDao.findById(TenantId.fromUUID((UUID)tenantId), uuid);
        Assert.assertNotNull((Object)entity);
        Assert.assertEquals((Object)uuid, (Object)entity.getId().getId());
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(10, (ThreadFactory)ThingsBoardThreadFactory.forName((String)(this.getClass().getSimpleName() + "-test-scope"))));
        ListenableFuture future = this.executor.submit(() -> (Device)this.deviceDao.findById(TenantId.fromUUID((UUID)tenantId), uuid));
        Device asyncDevice = (Device)future.get(30L, TimeUnit.SECONDS);
        Assert.assertNotNull((String)"Async device expected to be not null", (Object)asyncDevice);
    }

    @Test
    public void testFindDevicesByTenantIdAndIdsAsync() throws ExecutionException, InterruptedException, TimeoutException {
        ListenableFuture devicesFuture = this.deviceDao.findDevicesByTenantIdAndIdsAsync(this.tenantId1, this.deviceIds);
        List devices = (List)devicesFuture.get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)20L, (long)devices.size());
    }

    @Test
    public void testFindDevicesByTenantIdAndCustomerIdAndIdsAsync() throws ExecutionException, InterruptedException, TimeoutException {
        ListenableFuture devicesFuture = this.deviceDao.findDevicesByTenantIdCustomerIdAndIdsAsync(this.tenantId1, this.customerId1, this.deviceIds);
        List devices = (List)devicesFuture.get(30L, TimeUnit.SECONDS);
        Assert.assertEquals((long)20L, (long)devices.size());
    }

    private List<UUID> createDevices(UUID tenantId1, UUID tenantId2, UUID customerId1, UUID customerId2, int count) {
        ArrayList<UUID> savedDevicesUUID = new ArrayList<UUID>();
        for (int i = 0; i < count / 2; ++i) {
            savedDevicesUUID.add(this.saveDevice(tenantId1, this.getDevice(tenantId1, customerId1, i)).getUuidId());
            savedDevicesUUID.add(this.saveDevice(tenantId2, this.getDevice(tenantId2, customerId2, i + count / 2)).getUuidId());
        }
        return savedDevicesUUID;
    }

    private Device getDevice(UUID tenantId, UUID customerID, Object nameSuffix) {
        return this.getDevice(tenantId, customerID, Uuids.timeBased(), nameSuffix);
    }

    private Device getDevice(UUID tenantId, UUID customerID, UUID deviceId, Object nameSuffix) {
        Device device = new Device();
        device.setId((UUIDBased)new DeviceId(deviceId));
        device.setTenantId(TenantId.fromUUID((UUID)tenantId));
        device.setCustomerId(new CustomerId(customerID));
        device.setName(PREFIX_FOR_DEVICE_NAME + String.valueOf(nameSuffix));
        device.setDeviceProfileId(this.savedDeviceProfile.getId());
        return device;
    }

    private Device saveDevice(UUID tenantId, Device device) {
        return this.deviceDao.save(TenantId.fromUUID((UUID)tenantId), device);
    }
}

