/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.device;

import java.util.List;
import java.util.UUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.security.DeviceCredentials;
import org.thingsboard.server.common.data.security.DeviceCredentialsType;
import org.thingsboard.server.dao.AbstractJpaDaoTest;
import org.thingsboard.server.dao.device.DeviceCredentialsDao;
import org.thingsboard.server.dao.service.AbstractServiceTest;

public class JpaDeviceCredentialsDaoTest
extends AbstractJpaDaoTest {
    @Autowired
    DeviceCredentialsDao deviceCredentialsDao;
    List<DeviceCredentials> deviceCredentialsList;
    DeviceCredentials neededDeviceCredentials;

    @Before
    public void setUp() {
        this.deviceCredentialsList = List.of(this.createAndSaveDeviceCredentials(), this.createAndSaveDeviceCredentials());
        this.neededDeviceCredentials = this.deviceCredentialsList.get(0);
        Assert.assertNotNull((Object)this.neededDeviceCredentials);
    }

    DeviceCredentials createAndSaveDeviceCredentials() {
        DeviceCredentials deviceCredentials = new DeviceCredentials();
        deviceCredentials.setCredentialsType(DeviceCredentialsType.ACCESS_TOKEN);
        deviceCredentials.setCredentialsId(UUID.randomUUID().toString());
        deviceCredentials.setCredentialsValue("CHECK123");
        deviceCredentials.setDeviceId(new DeviceId(UUID.randomUUID()));
        return this.deviceCredentialsDao.save(TenantId.SYS_TENANT_ID, deviceCredentials);
    }

    @After
    public void deleteDeviceCredentials() {
        for (DeviceCredentials credentials : this.deviceCredentialsList) {
            this.deviceCredentialsDao.removeById(TenantId.SYS_TENANT_ID, credentials.getUuidId());
        }
    }

    @Test
    public void testFindByDeviceId() {
        DeviceCredentials foundedDeviceCredentials = this.deviceCredentialsDao.findByDeviceId(AbstractServiceTest.SYSTEM_TENANT_ID, this.neededDeviceCredentials.getDeviceId().getId());
        Assert.assertNotNull((Object)foundedDeviceCredentials);
        Assert.assertEquals((Object)this.neededDeviceCredentials.getId(), (Object)foundedDeviceCredentials.getId());
        Assert.assertEquals((Object)this.neededDeviceCredentials.getCredentialsId(), (Object)foundedDeviceCredentials.getCredentialsId());
    }

    @Test
    public void findByCredentialsId() {
        DeviceCredentials foundedDeviceCredentials = this.deviceCredentialsDao.findByCredentialsId(AbstractServiceTest.SYSTEM_TENANT_ID, this.neededDeviceCredentials.getCredentialsId());
        Assert.assertNotNull((Object)foundedDeviceCredentials);
        Assert.assertEquals((Object)this.neededDeviceCredentials.getId(), (Object)foundedDeviceCredentials.getId());
    }
}

