/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.dashboard;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.DashboardInfo;
import org.thingsboard.server.common.data.id.DashboardId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.AbstractJpaDaoTest;
import org.thingsboard.server.dao.dashboard.DashboardInfoDao;
import org.thingsboard.server.dao.service.AbstractServiceTest;

public class JpaDashboardInfoDaoTest
extends AbstractJpaDaoTest {
    @Autowired
    private DashboardInfoDao dashboardInfoDao;

    @Test
    public void testFindDashboardsByTenantId() {
        UUID tenantId1 = Uuids.timeBased();
        UUID tenantId2 = Uuids.timeBased();
        for (int i = 0; i < 20; ++i) {
            this.createDashboard(tenantId1, i);
            this.createDashboard(tenantId2, i * 2);
        }
        PageLink pageLink = new PageLink(15, 0, "DASHBOARD");
        PageData dashboardInfos1 = this.dashboardInfoDao.findDashboardsByTenantId(tenantId1, pageLink);
        Assert.assertEquals((long)15L, (long)dashboardInfos1.getData().size());
        PageData dashboardInfos2 = this.dashboardInfoDao.findDashboardsByTenantId(tenantId1, pageLink.nextPageLink());
        Assert.assertEquals((long)5L, (long)dashboardInfos2.getData().size());
    }

    private void createDashboard(UUID tenantId, int index) {
        DashboardInfo dashboardInfo = new DashboardInfo();
        dashboardInfo.setId((UUIDBased)new DashboardId(Uuids.timeBased()));
        dashboardInfo.setTenantId(TenantId.fromUUID((UUID)tenantId));
        dashboardInfo.setTitle("DASHBOARD_" + index);
        this.dashboardInfoDao.save(AbstractServiceTest.SYSTEM_TENANT_ID, (Object)dashboardInfo);
    }
}

