/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.customer;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.util.Optional;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.Customer;
import org.thingsboard.server.common.data.StringUtils;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.AbstractJpaDaoTest;
import org.thingsboard.server.dao.customer.CustomerDao;
import org.thingsboard.server.dao.customer.CustomerServiceImpl;

public class JpaCustomerDaoTest
extends AbstractJpaDaoTest {
    @Autowired
    private CustomerDao customerDao;

    @Test
    public void testFindByTenantId() {
        UUID tenantId1 = Uuids.timeBased();
        UUID tenantId2 = Uuids.timeBased();
        for (int i = 0; i < 20; ++i) {
            this.createCustomer(tenantId1, i);
            this.createCustomer(tenantId2, i * 2);
        }
        PageLink pageLink = new PageLink(15, 0, "CUSTOMER");
        PageData customers1 = this.customerDao.findCustomersByTenantId(tenantId1, pageLink);
        Assert.assertEquals((long)15L, (long)customers1.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData customers2 = this.customerDao.findCustomersByTenantId(tenantId1, pageLink);
        Assert.assertEquals((long)5L, (long)customers2.getData().size());
    }

    @Test
    public void testFindCustomersByTenantIdAndTitle() {
        UUID tenantId = Uuids.timeBased();
        for (int i = 0; i < 10; ++i) {
            this.createCustomer(tenantId, i);
        }
        Optional customerOpt = this.customerDao.findCustomerByTenantIdAndTitle(tenantId, "CUSTOMER_5");
        Assert.assertTrue((boolean)customerOpt.isPresent());
        Assert.assertEquals((Object)"CUSTOMER_5", (Object)((Customer)customerOpt.get()).getTitle());
    }

    @Test
    public void testFindPublicCustomerByTenantId() {
        UUID tenantId = Uuids.timeBased();
        Optional customerOpt = this.customerDao.findPublicCustomerByTenantId(tenantId);
        Assert.assertTrue((boolean)customerOpt.isEmpty());
        String publicCustomerTitle = StringUtils.randomAlphanumeric((int)10);
        this.createPublicCustomer(tenantId, publicCustomerTitle);
        customerOpt = this.customerDao.findPublicCustomerByTenantId(tenantId);
        Assert.assertTrue((boolean)customerOpt.isPresent());
        Customer customer = (Customer)customerOpt.get();
        Assert.assertTrue((boolean)customer.isPublic());
        Assert.assertEquals((Object)publicCustomerTitle, (Object)customer.getTitle());
    }

    private void createCustomer(UUID tenantId, int index) {
        Customer customer = new Customer();
        customer.setId((UUIDBased)new CustomerId(Uuids.timeBased()));
        customer.setTenantId(TenantId.fromUUID((UUID)tenantId));
        customer.setTitle("CUSTOMER_" + index);
        this.customerDao.save(TenantId.fromUUID((UUID)tenantId), customer);
    }

    private void createPublicCustomer(UUID tenantId, String publicCustomerTitle) {
        Customer customer = new Customer();
        customer.setId((UUIDBased)new CustomerId(Uuids.timeBased()));
        customer.setTenantId(TenantId.fromUUID((UUID)tenantId));
        customer.setTitle(publicCustomerTitle);
        customer.setAdditionalInfo(CustomerServiceImpl.PUBLIC_CUSTOMER_ADDITIONAL_INFO_JSON);
        this.customerDao.save(TenantId.fromUUID((UUID)tenantId), customer);
    }
}

