/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.audit;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.audit.ActionType;
import org.thingsboard.server.common.data.audit.AuditLog;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.page.TimePageLink;
import org.thingsboard.server.dao.AbstractJpaDaoTest;
import org.thingsboard.server.dao.audit.AuditLogDao;

public class JpaAuditLogDaoTest
extends AbstractJpaDaoTest {
    List<AuditLog> auditLogList = new ArrayList<AuditLog>();
    UUID tenantId;
    CustomerId customerId1;
    CustomerId customerId2;
    UserId userId1;
    UserId userId2;
    EntityId entityId1;
    EntityId entityId2;
    AuditLog neededFoundedAuditLog;
    @Autowired
    private AuditLogDao auditLogDao;

    @Before
    public void setUp() {
        this.setUpIds();
        for (int i = 0; i < 60; ++i) {
            ActionType actionType = i % 2 == 0 ? ActionType.ADDED : ActionType.DELETED;
            CustomerId customerId = i % 4 == 0 ? this.customerId1 : this.customerId2;
            UserId userId = i % 6 == 0 ? this.userId1 : this.userId2;
            EntityId entityId = i % 10 == 0 ? this.entityId1 : this.entityId2;
            this.auditLogList.add(this.createAuditLog(i, actionType, customerId, userId, entityId));
        }
        Assert.assertEquals((long)this.auditLogList.size(), (long)this.auditLogDao.find(TenantId.fromUUID((UUID)this.tenantId)).size());
        this.neededFoundedAuditLog = this.auditLogList.get(0);
        Assert.assertNotNull((Object)this.neededFoundedAuditLog);
    }

    private void setUpIds() {
        this.tenantId = Uuids.timeBased();
        this.customerId1 = new CustomerId(Uuids.timeBased());
        this.customerId2 = new CustomerId(Uuids.timeBased());
        this.userId1 = new UserId(Uuids.timeBased());
        this.userId2 = new UserId(Uuids.timeBased());
        this.entityId1 = new DeviceId(Uuids.timeBased());
        this.entityId2 = new DeviceId(Uuids.timeBased());
    }

    @After
    public void tearDown() {
        for (AuditLog auditLog : this.auditLogList) {
            this.auditLogDao.removeById(TenantId.fromUUID((UUID)this.tenantId), auditLog.getUuidId());
        }
        this.auditLogList.clear();
    }

    @Test
    public void testFindById() {
        AuditLog foundedAuditLogById = (AuditLog)this.auditLogDao.findById(TenantId.fromUUID((UUID)this.tenantId), this.neededFoundedAuditLog.getUuidId());
        this.checkFoundedAuditLog(foundedAuditLogById);
    }

    @Test
    public void testFindByIdAsync() throws ExecutionException, InterruptedException, TimeoutException {
        AuditLog foundedAuditLogById = (AuditLog)this.auditLogDao.findByIdAsync(TenantId.fromUUID((UUID)this.tenantId), this.neededFoundedAuditLog.getUuidId()).get(30L, TimeUnit.SECONDS);
        this.checkFoundedAuditLog(foundedAuditLogById);
    }

    private void checkFoundedAuditLog(AuditLog foundedAuditLogById) {
        Assert.assertNotNull((Object)foundedAuditLogById);
        Assert.assertEquals((Object)this.neededFoundedAuditLog, (Object)foundedAuditLogById);
    }

    @Test
    public void testFindAuditLogsByTenantId() {
        List foundedAuditLogs = this.auditLogDao.findAuditLogsByTenantId(this.tenantId, List.of(ActionType.ADDED), new TimePageLink(40)).getData();
        this.checkFoundedAuditLogsList(foundedAuditLogs, 30);
    }

    @Test
    public void testFindAuditLogsByTenantIdAndCustomerId() {
        List foundedAuditLogs = this.auditLogDao.findAuditLogsByTenantIdAndCustomerId(this.tenantId, this.customerId1, List.of(ActionType.ADDED), new TimePageLink(20)).getData();
        this.checkFoundedAuditLogsList(foundedAuditLogs, 15);
    }

    @Test
    public void testFindAuditLogsByTenantIdAndUserId() {
        List foundedAuditLogs = this.auditLogDao.findAuditLogsByTenantIdAndUserId(this.tenantId, this.userId1, List.of(ActionType.ADDED), new TimePageLink(20)).getData();
        this.checkFoundedAuditLogsList(foundedAuditLogs, 10);
    }

    @Test
    public void testFindAuditLogsByTenantIdAndEntityId() {
        List foundedAuditLogs = this.auditLogDao.findAuditLogsByTenantIdAndEntityId(this.tenantId, this.entityId1, List.of(ActionType.ADDED), new TimePageLink(10)).getData();
        this.checkFoundedAuditLogsList(foundedAuditLogs, 6);
    }

    private void checkFoundedAuditLogsList(List<AuditLog> foundedAuditLogs, int neededSizeForFoundedList) {
        Assert.assertNotNull(foundedAuditLogs);
        Assert.assertEquals((long)neededSizeForFoundedList, (long)foundedAuditLogs.size());
    }

    private AuditLog createAuditLog(int number, ActionType actionType, CustomerId customerId, UserId userId, EntityId entityId) {
        AuditLog auditLog = new AuditLog();
        auditLog.setTenantId(TenantId.fromUUID((UUID)this.tenantId));
        auditLog.setCustomerId(customerId);
        auditLog.setUserId(userId);
        auditLog.setEntityId(entityId);
        auditLog.setUserName("AUDIT_LOG_" + number);
        auditLog.setActionType(actionType);
        return (AuditLog)this.auditLogDao.save(TenantId.fromUUID((UUID)this.tenantId), (Object)auditLog);
    }
}

