/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.asset;

import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.server.common.data.EntitySubtype;
import org.thingsboard.server.common.data.asset.Asset;
import org.thingsboard.server.common.data.asset.AssetProfile;
import org.thingsboard.server.common.data.id.AssetId;
import org.thingsboard.server.common.data.id.AssetProfileId;
import org.thingsboard.server.common.data.id.CustomerId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.page.PageData;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.AbstractJpaDaoTest;
import org.thingsboard.server.dao.asset.AssetDao;
import org.thingsboard.server.dao.asset.AssetProfileDao;

public class JpaAssetDaoTest
extends AbstractJpaDaoTest {
    UUID tenantId1;
    UUID tenantId2;
    UUID customerId1;
    UUID customerId2;
    List<Asset> assets = new ArrayList<Asset>();
    @Autowired
    private AssetDao assetDao;
    @Autowired
    private AssetProfileDao assetProfileDao;
    private Map<String, AssetProfileId> savedAssetProfiles = new HashMap<String, AssetProfileId>();

    @Before
    public void setUp() {
        this.tenantId1 = Uuids.timeBased();
        this.tenantId2 = Uuids.timeBased();
        this.customerId1 = Uuids.timeBased();
        this.customerId2 = Uuids.timeBased();
        for (int i = 0; i < 60; ++i) {
            UUID assetId = Uuids.timeBased();
            UUID tenantId = i % 2 == 0 ? this.tenantId1 : this.tenantId2;
            UUID customerId = i % 2 == 0 ? this.customerId1 : this.customerId2;
            this.assets.add(this.saveAsset(assetId, tenantId, customerId, "ASSET_" + i, "label_" + i));
        }
        Assert.assertEquals((long)this.assets.size(), (long)this.assetDao.find(TenantId.fromUUID((UUID)this.tenantId1)).size());
    }

    @After
    public void tearDown() {
        for (Asset asset : this.assets) {
            this.assetDao.removeById(asset.getTenantId(), asset.getUuidId());
        }
        this.assets.clear();
        for (AssetProfileId assetProfileId : this.savedAssetProfiles.values()) {
            this.assetProfileDao.removeById(TenantId.SYS_TENANT_ID, assetProfileId.getId());
        }
        this.savedAssetProfiles.clear();
    }

    @Test
    public void testSaveDeviceName0x00_thenSomeDatabaseException() {
        Assertions.assertThatThrownBy(() -> this.assets.add(this.saveAsset(UUID.randomUUID(), this.tenantId2, this.customerId2, "F0929906\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000")));
    }

    @Test
    public void testFindAssetsByTenantId() {
        PageLink pageLink = new PageLink(20, 0, "ASSET_");
        PageData assets1 = this.assetDao.findAssetsByTenantId(this.tenantId1, pageLink);
        Assert.assertEquals((long)20L, (long)assets1.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData assets2 = this.assetDao.findAssetsByTenantId(this.tenantId1, pageLink);
        Assert.assertEquals((long)10L, (long)assets2.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData assets3 = this.assetDao.findAssetsByTenantId(this.tenantId1, pageLink);
        Assert.assertEquals((long)0L, (long)assets3.getData().size());
    }

    @Test
    public void testFindAssetsByTenantIdAndCustomerId() {
        PageLink pageLink = new PageLink(20, 0, "ASSET_");
        PageData assets1 = this.assetDao.findAssetsByTenantIdAndCustomerId(this.tenantId1, this.customerId1, pageLink);
        Assert.assertEquals((long)20L, (long)assets1.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData assets2 = this.assetDao.findAssetsByTenantIdAndCustomerId(this.tenantId1, this.customerId1, pageLink);
        Assert.assertEquals((long)10L, (long)assets2.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData assets3 = this.assetDao.findAssetsByTenantIdAndCustomerId(this.tenantId1, this.customerId1, pageLink);
        Assert.assertEquals((long)0L, (long)assets3.getData().size());
    }

    @Test
    public void testFindAssetsByTenantIdAndCustomerIdByLabel() {
        PageLink pageLink = new PageLink(20, 0, "label_");
        PageData assets1 = this.assetDao.findAssetsByTenantIdAndCustomerId(this.tenantId1, this.customerId1, pageLink);
        Assert.assertEquals((long)20L, (long)assets1.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData assets2 = this.assetDao.findAssetsByTenantIdAndCustomerId(this.tenantId1, this.customerId1, pageLink);
        Assert.assertEquals((long)10L, (long)assets2.getData().size());
        pageLink = pageLink.nextPageLink();
        PageData assets3 = this.assetDao.findAssetsByTenantIdAndCustomerId(this.tenantId1, this.customerId1, pageLink);
        Assert.assertEquals((long)0L, (long)assets3.getData().size());
    }

    @Test
    public void testFindAssetsByTenantIdAndIdsAsync() throws ExecutionException, InterruptedException, TimeoutException {
        List<UUID> searchIds = this.getAssetsUuids(this.tenantId1);
        ListenableFuture assetsFuture = this.assetDao.findAssetsByTenantIdAndIdsAsync(this.tenantId1, searchIds);
        List assets = (List)assetsFuture.get(30L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)searchIds.size(), (long)assets.size());
    }

    @Test
    public void testFindAssetsByTenantIdCustomerIdAndIdsAsync() throws ExecutionException, InterruptedException, TimeoutException {
        List<UUID> searchIds = this.getAssetsUuids(this.tenantId1);
        ListenableFuture assetsFuture = this.assetDao.findAssetsByTenantIdAndCustomerIdAndIdsAsync(this.tenantId1, this.customerId1, searchIds);
        List assets = (List)assetsFuture.get(30L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)assets);
        Assert.assertEquals((long)searchIds.size(), (long)assets.size());
    }

    private List<UUID> getAssetsUuids(UUID tenantId) {
        ArrayList<UUID> result = new ArrayList<UUID>();
        for (Asset asset : this.assets) {
            if (!asset.getTenantId().getId().equals(tenantId)) continue;
            result.add(asset.getUuidId());
        }
        return result;
    }

    @Test
    public void testFindAssetsByTenantIdAndName() {
        UUID assetId = Uuids.timeBased();
        String name = "TEST_ASSET";
        this.assets.add(this.saveAsset(assetId, this.tenantId2, this.customerId2, name));
        Optional assetOpt1 = this.assetDao.findAssetsByTenantIdAndName(this.tenantId2, name);
        Assert.assertTrue((String)"Optional expected to be non-empty", (boolean)assetOpt1.isPresent());
        Assert.assertEquals((Object)assetId, (Object)((Asset)assetOpt1.get()).getId().getId());
        Optional assetOpt2 = this.assetDao.findAssetsByTenantIdAndName(this.tenantId2, "NON_EXISTENT_NAME");
        Assert.assertFalse((String)"Optional expected to be empty", (boolean)assetOpt2.isPresent());
    }

    @Test
    public void testFindAssetsByTenantIdAndType() {
        String type = "TYPE_2";
        String testLabel = "test_label";
        this.assets.add(this.saveAsset(Uuids.timeBased(), this.tenantId2, this.customerId2, "TEST_ASSET", type, testLabel));
        List foundedAssetsByType = this.assetDao.findAssetsByTenantIdAndType(this.tenantId2, type, new PageLink(3)).getData();
        this.compareFoundedAssetByType(foundedAssetsByType, type);
        List foundedAssetsByTypeAndLabel = this.assetDao.findAssetsByTenantIdAndType(this.tenantId2, type, new PageLink(3, 0, testLabel)).getData();
        Assert.assertEquals((long)1L, (long)foundedAssetsByTypeAndLabel.size());
    }

    @Test
    public void testFindAssetsByTenantIdAndCustomerIdAndType() {
        String type = "TYPE_2";
        String testLabel = "test_label";
        this.assets.add(this.saveAsset(Uuids.timeBased(), this.tenantId2, this.customerId2, "TEST_ASSET", type, testLabel));
        List foundedAssetsByType = this.assetDao.findAssetsByTenantIdAndCustomerIdAndType(this.tenantId2, this.customerId2, type, new PageLink(3)).getData();
        this.compareFoundedAssetByType(foundedAssetsByType, type);
        List foundedAssetsByTypeAndLabel = this.assetDao.findAssetsByTenantIdAndCustomerIdAndType(this.tenantId2, this.customerId2, type, new PageLink(3, 0, testLabel)).getData();
        Assert.assertEquals((long)1L, (long)foundedAssetsByTypeAndLabel.size());
    }

    private void compareFoundedAssetByType(List<Asset> foundedAssetsByType, String type) {
        Assert.assertNotNull(foundedAssetsByType);
        Assert.assertEquals((long)1L, (long)foundedAssetsByType.size());
        Assert.assertEquals((Object)type, (Object)foundedAssetsByType.get(0).getType());
    }

    @Test
    public void testFindTenantAssetTypesAsync() throws ExecutionException, InterruptedException, TimeoutException {
        this.assets.add(this.saveAsset(Uuids.timeBased(), this.tenantId1, this.customerId1, "TEST_ASSET_3", "TYPE_2"));
        this.assets.add(this.saveAsset(Uuids.timeBased(), this.tenantId1, this.customerId1, "TEST_ASSET_4", "TYPE_3"));
        this.assets.add(this.saveAsset(Uuids.timeBased(), this.tenantId1, this.customerId1, "TEST_ASSET_5", "TYPE_3"));
        this.assets.add(this.saveAsset(Uuids.timeBased(), this.tenantId1, this.customerId1, "TEST_ASSET_6", "TYPE_3"));
        this.assets.add(this.saveAsset(Uuids.timeBased(), this.tenantId2, this.customerId2, "TEST_ASSET_7", "TYPE_4"));
        List tenant1Types = (List)this.assetDao.findTenantAssetTypesAsync(this.tenantId1).get(30L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)tenant1Types);
        List tenant2Types = (List)this.assetDao.findTenantAssetTypesAsync(this.tenantId2).get(30L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)tenant2Types);
        List<String> types = List.of("default", "TYPE_1", "TYPE_2", "TYPE_3", "TYPE_4");
        Assert.assertEquals((long)this.getDifferentTypesCount(types, tenant1Types), (long)tenant1Types.size());
        Assert.assertEquals((long)this.getDifferentTypesCount(types, tenant2Types), (long)tenant2Types.size());
    }

    private long getDifferentTypesCount(List<String> types, List<EntitySubtype> foundedAssetsTypes) {
        return foundedAssetsTypes.stream().filter(type -> types.contains(type.getType())).count();
    }

    private Asset saveAsset(UUID id, UUID tenantId, UUID customerId, String name) {
        return this.saveAsset(id, tenantId, customerId, name, null, null);
    }

    private Asset saveAsset(UUID id, UUID tenantId, UUID customerId, String name, String label) {
        return this.saveAsset(id, tenantId, customerId, name, null, label);
    }

    private Asset saveAsset(UUID id, UUID tenantId, UUID customerId, String name, String type, String label) {
        if (type == null) {
            type = "default";
        }
        Asset asset = new Asset();
        asset.setId((UUIDBased)new AssetId(id));
        asset.setTenantId(TenantId.fromUUID((UUID)tenantId));
        asset.setCustomerId(new CustomerId(customerId));
        asset.setName(name);
        asset.setType(type);
        asset.setLabel(label);
        asset.setAssetProfileId(this.assetProfileId(type));
        return this.assetDao.save(TenantId.fromUUID((UUID)tenantId), asset);
    }

    private AssetProfileId assetProfileId(String type) {
        AssetProfileId assetProfileId = this.savedAssetProfiles.get(type);
        if (assetProfileId == null) {
            AssetProfile assetProfile = new AssetProfile();
            assetProfile.setName(type);
            assetProfile.setTenantId(TenantId.SYS_TENANT_ID);
            assetProfile.setDescription("Test");
            AssetProfile savedAssetProfile = this.assetProfileDao.save(TenantId.SYS_TENANT_ID, assetProfile);
            assetProfileId = savedAssetProfile.getId();
            this.savedAssetProfiles.put(type, assetProfileId);
        }
        return assetProfileId;
    }
}

