/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.alarm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.Generated;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.Tenant;
import org.thingsboard.server.common.data.TenantProfile;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmApiCallResult;
import org.thingsboard.server.common.data.alarm.AlarmCreateOrUpdateActiveRequest;
import org.thingsboard.server.common.data.alarm.AlarmInfo;
import org.thingsboard.server.common.data.alarm.AlarmSeverity;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.tenant.profile.DefaultTenantProfileConfiguration;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileConfiguration;
import org.thingsboard.server.common.data.tenant.profile.TenantProfileData;
import org.thingsboard.server.dao.AbstractJpaDaoTest;
import org.thingsboard.server.dao.alarm.AlarmDao;
import org.thingsboard.server.dao.tenant.TenantDao;
import org.thingsboard.server.dao.tenant.TenantProfileDao;

public class JpaAlarmDaoTest
extends AbstractJpaDaoTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JpaAlarmDaoTest.class);
    @Autowired
    private AlarmDao alarmDao;
    @Autowired
    protected TenantProfileDao tenantProfileDao;
    @Autowired
    protected TenantDao tenantDao;

    @Test
    public void testFindLatestByOriginatorAndType() throws ExecutionException, InterruptedException, TimeoutException {
        log.info("Current system time in millis = {}", (Object)System.currentTimeMillis());
        TenantId tenantId = TenantId.fromUUID((UUID)UUID.randomUUID());
        UUID originator1Id = UUID.fromString("d4b68f41-3e96-11e7-a884-898080180d6b");
        UUID originator2Id = UUID.fromString("d4b68f42-3e96-11e7-a884-898080180d6b");
        UUID alarm1Id = UUID.fromString("d4b68f43-3e96-11e7-a884-898080180d6b");
        UUID alarm2Id = UUID.fromString("d4b68f44-3e96-11e7-a884-898080180d6b");
        UUID alarm3Id = UUID.fromString("d4b68f45-3e96-11e7-a884-898080180d6b");
        List alarmsBeforeSave = this.alarmDao.find(tenantId).stream().filter(a -> a.getTenantId().equals((Object)tenantId)).collect(Collectors.toList());
        int alarmCountBeforeSave = alarmsBeforeSave.size();
        this.saveAlarm(alarm1Id, tenantId.getId(), originator1Id, "TEST_ALARM");
        Thread.sleep(1L);
        this.saveAlarm(alarm2Id, tenantId.getId(), originator1Id, "TEST_ALARM");
        this.saveAlarm(alarm3Id, tenantId.getId(), originator2Id, "TEST_ALARM");
        List alarmsAfterSave = this.alarmDao.find(tenantId).stream().filter(a -> a.getTenantId().equals((Object)tenantId)).collect(Collectors.toList());
        int alarmCountAfterSave = alarmsAfterSave.size();
        int diff = alarmCountAfterSave - alarmCountBeforeSave;
        if (diff != 3) {
            System.out.println("test");
        }
        Assert.assertEquals((long)3L, (long)diff);
        ListenableFuture future = this.alarmDao.findLatestByOriginatorAndTypeAsync(tenantId, (EntityId)new DeviceId(originator1Id), "TEST_ALARM");
        Alarm alarm = (Alarm)future.get(30L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)alarm);
        Assert.assertEquals((Object)alarm2Id, (Object)alarm.getId().getId());
    }

    @Test
    public void createOrUpdateActiveAlarm() {
        Tenant tenant = this.createTenant();
        TenantId tenantId = tenant.getId();
        DeviceId deviceId = new DeviceId(UUID.randomUUID());
        AlarmCreateOrUpdateActiveRequest request = AlarmCreateOrUpdateActiveRequest.builder().tenantId(tenantId).originator((EntityId)deviceId).type("ALARM_TYPE").severity(AlarmSeverity.MAJOR).build();
        AlarmApiCallResult result = this.alarmDao.createOrUpdateActiveAlarm(request, true);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isSuccessful());
        Assert.assertTrue((boolean)result.isCreated());
        Assert.assertTrue((boolean)result.isModified());
        Assert.assertNotNull((Object)result.getAlarm());
        UUID newAlarmId = result.getAlarm().getUuidId();
        AlarmInfo afterSave = this.alarmDao.findAlarmInfoById(tenantId, newAlarmId);
        Assert.assertEquals((Object)afterSave, (Object)result.getAlarm());
        request = AlarmCreateOrUpdateActiveRequest.builder().tenantId(tenantId).originator((EntityId)deviceId).type("ALARM_TYPE").severity(AlarmSeverity.CRITICAL).build();
        result = this.alarmDao.createOrUpdateActiveAlarm(request, true);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isSuccessful());
        Assert.assertFalse((boolean)result.isCreated());
        Assert.assertTrue((boolean)result.isModified());
        Assert.assertNotNull((Object)result.getAlarm());
        Assert.assertEquals((Object)newAlarmId, (Object)result.getAlarm().getUuidId());
        afterSave = this.alarmDao.findAlarmInfoById(tenantId, newAlarmId);
        Assert.assertEquals((Object)afterSave, (Object)result.getAlarm());
        this.alarmDao.clearAlarm(tenantId, result.getAlarm().getId(), System.currentTimeMillis(), result.getAlarm().getDetails());
        request = AlarmCreateOrUpdateActiveRequest.builder().tenantId(tenantId).originator((EntityId)deviceId).type("ALARM_TYPE").severity(AlarmSeverity.CRITICAL).build();
        result = this.alarmDao.createOrUpdateActiveAlarm(request, true);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isSuccessful());
        Assert.assertTrue((boolean)result.isCreated());
        Assert.assertTrue((boolean)result.isModified());
        Assert.assertNotNull((Object)result.getAlarm());
        Assert.assertNotEquals((Object)newAlarmId, (Object)result.getAlarm().getUuidId());
        afterSave = this.alarmDao.findAlarmInfoById(tenantId, result.getAlarm().getUuidId());
        Assert.assertEquals((Object)afterSave, (Object)result.getAlarm());
        this.alarmDao.clearAlarm(tenantId, result.getAlarm().getId(), System.currentTimeMillis(), result.getAlarm().getDetails());
        request = AlarmCreateOrUpdateActiveRequest.builder().tenantId(tenantId).originator((EntityId)deviceId).type("ALARM_TYPE2").severity(AlarmSeverity.CRITICAL).build();
        result = this.alarmDao.createOrUpdateActiveAlarm(request, true);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isSuccessful());
        Assert.assertTrue((boolean)result.isCreated());
        Assert.assertTrue((boolean)result.isModified());
        Assert.assertNotNull((Object)result.getAlarm());
        Assert.assertNotEquals((Object)newAlarmId, (Object)result.getAlarm().getUuidId());
        this.tenantDao.removeById(TenantId.SYS_TENANT_ID, tenant.getUuidId());
        this.tenantProfileDao.removeById(TenantId.SYS_TENANT_ID, tenant.getTenantProfileId().getId());
    }

    @Test
    public void testCantCreateAlarmIfCreateIsDisabled() {
        TenantId tenantId = TenantId.fromUUID((UUID)UUID.randomUUID());
        DeviceId deviceId = new DeviceId(UUID.randomUUID());
        AlarmCreateOrUpdateActiveRequest request = AlarmCreateOrUpdateActiveRequest.builder().tenantId(tenantId).originator((EntityId)deviceId).type("ALARM_TYPE").severity(AlarmSeverity.MAJOR).build();
        AlarmApiCallResult result = this.alarmDao.createOrUpdateActiveAlarm(request, false);
        Assert.assertFalse((boolean)result.isSuccessful());
    }

    @Test
    public void testAckAlarmProcedure() {
        UUID tenantId = UUID.randomUUID();
        UUID originator1Id = UUID.fromString("d4b68f41-3e96-11e7-a884-898080180d6b");
        UUID alarm1Id = UUID.fromString("d4b68f43-3e96-11e7-a884-898080180d6b");
        Alarm alarm = this.saveAlarm(alarm1Id, tenantId, originator1Id, "TEST_ALARM");
        long ackTs = System.currentTimeMillis();
        AlarmApiCallResult result = this.alarmDao.acknowledgeAlarm(alarm.getTenantId(), alarm.getId(), ackTs);
        AlarmInfo afterSave = this.alarmDao.findAlarmInfoById(alarm.getTenantId(), alarm.getUuidId());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isSuccessful());
        Assert.assertTrue((boolean)result.isModified());
        Assert.assertNotNull((Object)result.getAlarm());
        Assert.assertEquals((Object)afterSave, (Object)result.getAlarm());
        Assert.assertEquals((long)ackTs, (long)result.getAlarm().getAckTs());
        Assert.assertTrue((boolean)result.getAlarm().isAcknowledged());
        result = this.alarmDao.acknowledgeAlarm(alarm.getTenantId(), alarm.getId(), ackTs + 1L);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getAlarm());
        Assert.assertEquals((Object)afterSave, (Object)result.getAlarm());
        Assert.assertTrue((boolean)result.isSuccessful());
        Assert.assertFalse((boolean)result.isModified());
        Assert.assertEquals((long)ackTs, (long)result.getAlarm().getAckTs());
        Assert.assertTrue((boolean)result.getAlarm().isAcknowledged());
    }

    @Test
    public void testClearAlarmProcedure() {
        UUID tenantId = UUID.randomUUID();
        UUID originator1Id = UUID.fromString("d4b68f41-3e96-11e7-a884-898080180d6b");
        UUID alarm1Id = UUID.fromString("d4b68f43-3e96-11e7-a884-898080180d6b");
        Alarm alarm = this.saveAlarm(alarm1Id, tenantId, originator1Id, "TEST_ALARM");
        long clearTs = System.currentTimeMillis();
        ObjectNode details = JacksonUtil.newObjectNode().put("test", 123);
        AlarmApiCallResult result = this.alarmDao.clearAlarm(alarm.getTenantId(), alarm.getId(), clearTs, (JsonNode)details);
        AlarmInfo afterSave = this.alarmDao.findAlarmInfoById(alarm.getTenantId(), alarm.getUuidId());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isSuccessful());
        Assert.assertTrue((boolean)result.isCleared());
        Assert.assertNotNull((Object)result.getAlarm());
        Assert.assertEquals((Object)afterSave, (Object)result.getAlarm());
        Assert.assertEquals((long)clearTs, (long)result.getAlarm().getClearTs());
        Assert.assertTrue((boolean)result.getAlarm().isCleared());
        Assert.assertEquals((Object)details, (Object)result.getAlarm().getDetails());
        result = this.alarmDao.clearAlarm(alarm.getTenantId(), alarm.getId(), clearTs + 1L, (JsonNode)JacksonUtil.newObjectNode());
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getAlarm());
        Assert.assertEquals((Object)afterSave, (Object)result.getAlarm());
        Assert.assertTrue((boolean)result.isSuccessful());
        Assert.assertFalse((boolean)result.isCleared());
        Assert.assertEquals((long)clearTs, (long)result.getAlarm().getClearTs());
        Assert.assertTrue((boolean)result.getAlarm().isCleared());
    }

    @Test
    public void testClearAlarmWithoutDetailsProcedure() {
        UUID tenantId = UUID.randomUUID();
        UUID originator1Id = UUID.fromString("d4b68f41-3e96-11e7-a884-898080180d6b");
        UUID alarm1Id = UUID.fromString("d4b68f43-3e96-11e7-a884-898080180d6b");
        Alarm alarm = this.saveAlarm(alarm1Id, tenantId, originator1Id, "TEST_ALARM");
        long clearTs = System.currentTimeMillis();
        AlarmApiCallResult result = this.alarmDao.clearAlarm(alarm.getTenantId(), alarm.getId(), clearTs, null);
        AlarmInfo afterSave = this.alarmDao.findAlarmInfoById(alarm.getTenantId(), alarm.getUuidId());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isSuccessful());
        Assert.assertTrue((boolean)result.isCleared());
        Assert.assertNotNull((Object)result.getAlarm());
        Assert.assertEquals((Object)afterSave, (Object)result.getAlarm());
        Assert.assertEquals((long)clearTs, (long)result.getAlarm().getClearTs());
        Assert.assertTrue((boolean)result.getAlarm().isCleared());
        Assert.assertEquals((Object)alarm.getDetails(), (Object)result.getAlarm().getDetails());
        result = this.alarmDao.clearAlarm(alarm.getTenantId(), alarm.getId(), clearTs + 1L, (JsonNode)JacksonUtil.newObjectNode());
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getAlarm());
        Assert.assertEquals((Object)afterSave, (Object)result.getAlarm());
        Assert.assertTrue((boolean)result.isSuccessful());
        Assert.assertFalse((boolean)result.isCleared());
        Assert.assertEquals((long)clearTs, (long)result.getAlarm().getClearTs());
        Assert.assertTrue((boolean)result.getAlarm().isCleared());
    }

    @Test
    public void testAssignAlarmProcedure() {
        UUID tenantId = UUID.randomUUID();
        UUID originator1Id = UUID.fromString("d4b68f41-3e96-11e7-a884-898080180d6b");
        UUID alarmId = UUID.fromString("d4b68f43-3e96-11e7-a884-898080180d6b");
        UserId userId1 = new UserId(UUID.fromString("d4b68f43-3e96-11e7-a884-898080180d7b"));
        UserId userId2 = new UserId(UUID.fromString("d4b68f43-3e96-11e7-a884-898080180d8b"));
        Alarm alarm = this.saveAlarm(alarmId, tenantId, originator1Id, "TEST_ALARM");
        long assignTs = System.currentTimeMillis();
        AlarmApiCallResult result = this.alarmDao.assignAlarm(alarm.getTenantId(), alarm.getId(), userId1, assignTs);
        AlarmInfo afterSave = this.alarmDao.findAlarmInfoById(alarm.getTenantId(), alarm.getUuidId());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isSuccessful());
        Assert.assertTrue((boolean)result.isModified());
        Assert.assertNotNull((Object)result.getAlarm());
        Assert.assertEquals((Object)afterSave, (Object)result.getAlarm());
        Assert.assertEquals((long)assignTs, (long)result.getAlarm().getAssignTs());
        Assert.assertNotNull((Object)result.getAlarm().getAssigneeId());
        Assert.assertEquals((Object)userId1, (Object)result.getAlarm().getAssigneeId());
        result = this.alarmDao.assignAlarm(alarm.getTenantId(), alarm.getId(), userId1, assignTs + 1L);
        afterSave = this.alarmDao.findAlarmInfoById(alarm.getTenantId(), alarm.getUuidId());
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getAlarm());
        Assert.assertEquals((Object)afterSave, (Object)result.getAlarm());
        Assert.assertTrue((boolean)result.isSuccessful());
        Assert.assertFalse((boolean)result.isModified());
        Assert.assertEquals((long)assignTs, (long)result.getAlarm().getAssignTs());
        Assert.assertNotNull((Object)result.getAlarm().getAssigneeId());
        Assert.assertEquals((Object)userId1, (Object)result.getAlarm().getAssigneeId());
        result = this.alarmDao.assignAlarm(alarm.getTenantId(), alarm.getId(), userId2, assignTs + 1L);
        afterSave = this.alarmDao.findAlarmInfoById(alarm.getTenantId(), alarm.getUuidId());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isSuccessful());
        Assert.assertTrue((boolean)result.isModified());
        Assert.assertNotNull((Object)result.getAlarm());
        Assert.assertEquals((Object)afterSave, (Object)result.getAlarm());
        Assert.assertEquals((long)(assignTs + 1L), (long)result.getAlarm().getAssignTs());
        Assert.assertNotNull((Object)result.getAlarm().getAssigneeId());
        Assert.assertEquals((Object)userId2, (Object)result.getAlarm().getAssigneeId());
        result = this.alarmDao.unassignAlarm(alarm.getTenantId(), alarm.getId(), assignTs + 1L);
        afterSave = this.alarmDao.findAlarmInfoById(alarm.getTenantId(), alarm.getUuidId());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isSuccessful());
        Assert.assertTrue((boolean)result.isModified());
        Assert.assertNotNull((Object)result.getAlarm());
        Assert.assertEquals((Object)afterSave, (Object)result.getAlarm());
        Assert.assertNull((Object)result.getAlarm().getAssigneeId());
        result = this.alarmDao.unassignAlarm(alarm.getTenantId(), alarm.getId(), assignTs + 1L);
        afterSave = this.alarmDao.findAlarmInfoById(alarm.getTenantId(), alarm.getUuidId());
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.isSuccessful());
        Assert.assertFalse((boolean)result.isModified());
        Assert.assertNotNull((Object)result.getAlarm());
        Assert.assertEquals((Object)afterSave, (Object)result.getAlarm());
        Assert.assertNull((Object)result.getAlarm().getAssigneeId());
    }

    private Alarm saveAlarm(UUID id, UUID tenantId, UUID deviceId, String type) {
        Alarm alarm = new Alarm();
        alarm.setId((UUIDBased)new AlarmId(id));
        alarm.setTenantId(TenantId.fromUUID((UUID)tenantId));
        alarm.setOriginator((EntityId)new DeviceId(deviceId));
        alarm.setType(type);
        alarm.setPropagate(true);
        alarm.setStartTs(System.currentTimeMillis());
        alarm.setEndTs(System.currentTimeMillis());
        alarm.setAcknowledged(false);
        alarm.setCleared(false);
        alarm.setDetails(JacksonUtil.newObjectNode().put("a", UUID.randomUUID().toString()).set("b", (JsonNode)JacksonUtil.newObjectNode().put("a", "[}/.`1321421!@@$$(%&&$")));
        return this.alarmDao.save(TenantId.fromUUID((UUID)tenantId), alarm);
    }

    private Tenant createTenant() {
        TenantProfile tenantProfile = new TenantProfile();
        tenantProfile.setName("My tenant profile " + String.valueOf(UUID.randomUUID()));
        TenantProfileData profileData = new TenantProfileData();
        profileData.setConfiguration((TenantProfileConfiguration)new DefaultTenantProfileConfiguration());
        tenantProfile.setProfileData(profileData);
        TenantProfile savedTenantProfile = this.tenantProfileDao.save(TenantId.SYS_TENANT_ID, tenantProfile);
        Assert.assertNotNull((Object)savedTenantProfile);
        Tenant tenant = new Tenant();
        tenant.setTitle("My tenant " + String.valueOf(UUID.randomUUID()));
        tenant.setTenantProfileId(savedTenantProfile.getId());
        Tenant savedTenant = this.tenantDao.save(TenantId.SYS_TENANT_ID, tenant);
        Assert.assertNotNull((Object)savedTenant);
        return savedTenant;
    }
}

