/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.sql.alarm;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.UUID;
import lombok.Generated;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.testcontainers.shaded.org.apache.commons.lang3.RandomStringUtils;
import org.thingsboard.common.util.JacksonUtil;
import org.thingsboard.server.common.data.alarm.Alarm;
import org.thingsboard.server.common.data.alarm.AlarmComment;
import org.thingsboard.server.common.data.alarm.AlarmCommentType;
import org.thingsboard.server.common.data.id.AlarmCommentId;
import org.thingsboard.server.common.data.id.AlarmId;
import org.thingsboard.server.common.data.id.DeviceId;
import org.thingsboard.server.common.data.id.EntityId;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.id.UUIDBased;
import org.thingsboard.server.common.data.id.UserId;
import org.thingsboard.server.common.data.page.PageLink;
import org.thingsboard.server.dao.AbstractJpaDaoTest;
import org.thingsboard.server.dao.alarm.AlarmCommentDao;
import org.thingsboard.server.dao.alarm.AlarmDao;

public class JpaAlarmCommentDaoTest
extends AbstractJpaDaoTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JpaAlarmCommentDaoTest.class);
    @Autowired
    private AlarmCommentDao alarmCommentDao;
    @Autowired
    private AlarmDao alarmDao;

    @Test
    public void testFindAlarmCommentsByAlarmId() {
        log.info("Current system time in millis = {}", (Object)System.currentTimeMillis());
        UUID tenantId = UUID.randomUUID();
        UUID userId = UUID.randomUUID();
        UUID alarmId1 = UUID.randomUUID();
        UUID alarmId2 = UUID.randomUUID();
        UUID commentId1 = UUID.randomUUID();
        UUID commentId2 = UUID.randomUUID();
        UUID commentId3 = UUID.randomUUID();
        this.saveAlarm(alarmId1, UUID.randomUUID(), UUID.randomUUID(), "TEST_ALARM");
        this.saveAlarm(alarmId2, UUID.randomUUID(), UUID.randomUUID(), "TEST_ALARM");
        this.saveAlarmComment(commentId1, alarmId1, userId, AlarmCommentType.OTHER);
        this.saveAlarmComment(commentId2, alarmId1, userId, AlarmCommentType.OTHER);
        this.saveAlarmComment(commentId3, alarmId2, userId, AlarmCommentType.OTHER);
        int count = this.alarmCommentDao.findAlarmComments(TenantId.fromUUID((UUID)tenantId), new AlarmId(alarmId1), new PageLink(10, 0)).getData().size();
        Assert.assertEquals((long)2L, (long)count);
    }

    private void saveAlarm(UUID id, UUID tenantId, UUID deviceId, String type) {
        Alarm alarm = new Alarm();
        alarm.setId((UUIDBased)new AlarmId(id));
        alarm.setTenantId(TenantId.fromUUID((UUID)tenantId));
        alarm.setOriginator((EntityId)new DeviceId(deviceId));
        alarm.setType(type);
        alarm.setPropagate(true);
        alarm.setStartTs(System.currentTimeMillis());
        alarm.setEndTs(System.currentTimeMillis());
        this.alarmDao.save(TenantId.fromUUID((UUID)tenantId), alarm);
    }

    private void saveAlarmComment(UUID id, UUID alarmId, UUID userId, AlarmCommentType type) {
        AlarmComment alarmComment = new AlarmComment();
        alarmComment.setId((UUIDBased)new AlarmCommentId(id));
        alarmComment.setAlarmId(new AlarmId(alarmId));
        alarmComment.setUserId(new UserId(userId));
        alarmComment.setType(type);
        alarmComment.setComment((JsonNode)JacksonUtil.newObjectNode().put("text", RandomStringUtils.randomAlphanumeric((int)10)));
        this.alarmCommentDao.save(TenantId.fromUUID((UUID)UUID.randomUUID()), (Object)alarmComment);
    }
}

