/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.dao.service.validator;

import java.util.UUID;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.BDDMockito;
import org.mockito.Mockito;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.boot.test.mock.mockito.SpyBean;
import org.thingsboard.server.common.data.id.TenantId;
import org.thingsboard.server.common.data.widget.WidgetsBundle;
import org.thingsboard.server.dao.service.validator.WidgetsBundleDataValidator;
import org.thingsboard.server.dao.tenant.TenantService;
import org.thingsboard.server.dao.widget.WidgetsBundleDao;

@SpringBootTest(classes={WidgetsBundleDataValidator.class})
class WidgetsBundleDataValidatorTest {
    @MockBean
    WidgetsBundleDao widgetsBundleDao;
    @MockBean
    TenantService tenantService;
    @SpyBean
    WidgetsBundleDataValidator validator;
    TenantId tenantId = TenantId.fromUUID((UUID)UUID.fromString("9ef79cdf-37a8-4119-b682-2e7ed4e018da"));

    WidgetsBundleDataValidatorTest() {
    }

    @BeforeEach
    void setUp() {
        ((TenantService)BDDMockito.willReturn((Object)true).given((Object)this.tenantService)).tenantExists(this.tenantId);
    }

    @Test
    void testValidateNameInvocation() {
        WidgetsBundle widgetsBundle = new WidgetsBundle();
        widgetsBundle.setTitle("my fancy WB");
        widgetsBundle.setTenantId(this.tenantId);
        this.validator.validateDataImpl(this.tenantId, widgetsBundle);
        ((WidgetsBundleDataValidator)Mockito.verify((Object)this.validator)).validateString("Widgets bundle title", widgetsBundle.getTitle());
    }
}

